/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.util.StackedIterator;

public class PrecedingAxisIterator
implements Iterator {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    private Object contextNode;
    private Navigator navigator;
    private Iterator siblings;
    private Iterator currentSibling;

    public PrecedingAxisIterator(Object object, Navigator navigator) throws UnsupportedAxisException {
        this.contextNode = object;
        this.navigator = navigator;
        this.siblings = navigator.getPrecedingSiblingAxisIterator(object);
        this.currentSibling = EMPTY_ITERATOR;
    }

    private boolean goBack() {
        while (!this.siblings.hasNext()) {
            if (this.goUp()) continue;
            return false;
        }
        Object e = this.siblings.next();
        try {
            this.currentSibling = new ReverseDescendantOrSelfAxisIterator(e);
            return true;
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            return false;
        }
    }

    private boolean goUp() {
        if (this.contextNode == null || this.navigator.isDocument(this.contextNode)) {
            return false;
        }
        try {
            this.contextNode = this.navigator.getParentNode(this.contextNode);
            if (this.contextNode != null && !this.navigator.isDocument(this.contextNode)) {
                this.siblings = this.navigator.getPrecedingSiblingAxisIterator(this.contextNode);
                return true;
            }
            return false;
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            return false;
        }
    }

    public boolean hasNext() {
        while (!this.currentSibling.hasNext()) {
            if (this.goBack()) continue;
            return false;
        }
        return true;
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentSibling.next();
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private final class ReverseDescendantOrSelfAxisIterator
    extends StackedIterator {
        ReverseDescendantOrSelfAxisIterator(Object object) throws UnsupportedAxisException {
            this.pushIterator(PrecedingAxisIterator.this.navigator.getSelfAxisIterator(object));
            this.init(object, PrecedingAxisIterator.this.navigator);
        }

        protected Iterator createIterator(Object object) {
            try {
                Iterator iterator = PrecedingAxisIterator.this.navigator.getChildAxisIterator(object);
                if (iterator == null) {
                    return null;
                }
                LinkedList linkedList = new LinkedList();
                while (iterator.hasNext()) {
                    linkedList.addFirst(iterator.next());
                }
                return linkedList.iterator();
            }
            catch (UnsupportedAxisException unsupportedAxisException) {
                return null;
            }
        }
    }
}

