/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import java.util.Map;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkObjectTypeConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.NestableEclipseLinkConversionValueAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceEclipseLinkConversionValueAnnotation
extends SourceAnnotation<Member>
implements NestableEclipseLinkConversionValueAnnotation {
    private DeclarationAnnotationElementAdapter<String> dataValueDeclarationAdapter = this.buildDataValueDeclarationAdapter();
    private AnnotationElementAdapter<String> dataValueAdapter = this.buildDataValueAdapter();
    private String dataValue;
    private DeclarationAnnotationElementAdapter<String> objectValueDeclarationAdapter = this.buildObjectValueDeclarationAdapter();
    private AnnotationElementAdapter<String> objectValueAdapter = this.buildObjectValueAdapter();
    private String objectValue;

    SourceEclipseLinkConversionValueAnnotation(EclipseLinkObjectTypeConverterAnnotation parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        super((JavaResourceNode)parent, (AnnotatedElement)member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter((AnnotatedElement)member, idaa));
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ConversionValue";
    }

    public void initialize(CompilationUnit astRoot) {
        this.dataValue = this.buildDataValue(astRoot);
        this.objectValue = this.buildObjectValue(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncDataValue(this.buildDataValue(astRoot));
        this.syncObjectValue(this.buildObjectValue(astRoot));
    }

    @Override
    public String getDataValue() {
        return this.dataValue;
    }

    @Override
    public void setDataValue(String dataValue) {
        if (this.attributeValueHasChanged(this.dataValue, dataValue)) {
            this.dataValue = dataValue;
            this.dataValueAdapter.setValue((Object)dataValue);
        }
    }

    private void syncDataValue(String astDataValue) {
        String old = this.dataValue;
        this.dataValue = astDataValue;
        this.firePropertyChanged("dataValue", old, astDataValue);
    }

    private String buildDataValue(CompilationUnit astRoot) {
        return (String)this.dataValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDataValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.dataValueDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildDataValueDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"dataValue");
    }

    private AnnotationElementAdapter<String> buildDataValueAdapter() {
        return this.buildStringElementAdapter(this.dataValueDeclarationAdapter);
    }

    @Override
    public String getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(String objectValue) {
        if (this.attributeValueHasChanged(this.objectValue, objectValue)) {
            this.objectValue = objectValue;
            this.objectValueAdapter.setValue((Object)objectValue);
        }
    }

    private void syncObjectValue(String astObjectValue) {
        String old = this.objectValue;
        this.objectValue = astObjectValue;
        this.firePropertyChanged("objectValue", old, astObjectValue);
    }

    private String buildObjectValue(CompilationUnit astRoot) {
        return (String)this.objectValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getObjectValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.objectValueDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildObjectValueDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"objectValue");
    }

    private AnnotationElementAdapter<String> buildObjectValueAdapter() {
        return this.buildStringElementAdapter(this.objectValueDeclarationAdapter);
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    public boolean isUnset() {
        return super.isUnset() && this.dataValue == null && this.objectValue == null;
    }

    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.dataValueDeclarationAdapter = this.buildDataValueDeclarationAdapter();
        this.dataValueAdapter = this.buildDataValueAdapter();
        this.objectValueDeclarationAdapter = this.buildObjectValueDeclarationAdapter();
        this.objectValueAdapter = this.buildObjectValueAdapter();
    }

    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        map.put("dataValue", this.dataValue);
        this.dataValue = null;
        map.put("objectValue", this.objectValue);
        this.objectValue = null;
    }

    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        this.setDataValue((String)map.get("dataValue"));
        this.setObjectValue((String)map.get("objectValue"));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.dataValue);
        sb.append("=>");
        sb.append(this.objectValue);
    }

    static NestableEclipseLinkConversionValueAnnotation createConversionValue(EclipseLinkObjectTypeConverterAnnotation parent, Member member, DeclarationAnnotationAdapter daa, int index) {
        return new SourceEclipseLinkConversionValueAnnotation(parent, member, SourceEclipseLinkConversionValueAnnotation.buildConversionValueAnnotationAdapter(daa, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildConversionValueAnnotationAdapter(DeclarationAnnotationAdapter daa, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(daa, "conversionValues", index, "org.eclipse.persistence.annotations.ConversionValue");
    }
}

