/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.io;

import com.objfac.util.Misc;
import com.objfac.xml.io.IDocumentStore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultDocumentStore
implements IDocumentStore {
    private String fDirUrl;
    private File fMetaFile;
    private LinkedList fMeta = new LinkedList();
    private HashMap fPubToMeta = new HashMap();
    private HashMap fAbsToMeta = new HashMap();
    private int fMaxRel = 0;
    private static final String NULPUB = "<pub null='true'/>";
    private static final String BEGPUB = "<pub>";
    private static final String ENDPUB = "</pub>";
    private static final String NULABS = "<abs null='true'/>";
    private static final String BEGABS = "<abs>";
    private static final String ENDABS = "</abs>";
    private static final String BEGREL = "<rel>";
    private static final String ENDREL = "</rel>";
    private static final String BEGFIL = "<file>";
    private static final String ENDFIL = "</file>";

    public void setStoreLocation(String string) throws IOException {
        if (!string.startsWith("file:")) {
            throw new IllegalArgumentException("Must be a file: URL " + string);
        }
        String string2 = Misc.fileUrlToPath((String)string);
        File file = new File(string2);
        if (!file.exists()) {
            if (!file.mkdir()) {
                throw new IllegalArgumentException("Can't make directory " + string2);
            }
        } else if (!file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory " + string2);
        }
        if (!string.endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        this.fDirUrl = string;
        String string3 = String.valueOf(this.fDirUrl) + "meta.xml";
        String string4 = Misc.fileUrlToPath((String)string3);
        this.fMetaFile = new File(string4);
        if (this.fMetaFile.exists()) {
            this.parseMeta();
        } else {
            if (!this.fMetaFile.createNewFile()) {
                throw new IOException("Unable to create meta file at " + string4);
            }
            this.writeMeta();
        }
    }

    public synchronized boolean isStored(String string, String string2) {
        return string != null && this.fPubToMeta.containsKey(string) || string2 != null && this.fAbsToMeta.containsKey(string2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store(String string, String string2, char[] cArray) throws IOException {
        Object object;
        Object object2;
        String string3 = "f" + ++this.fMaxRel;
        File file = null;
        while ((file = new File((String)(object2 = Misc.fileUrlToPath((String)(object = String.valueOf(this.fDirUrl) + string3))))).exists()) {
        }
        file.createNewFile();
        object = new Meta(string, string2, string3);
        object2 = this.fileWriter(file);
        try {
            Misc.write((Writer)object2, (char[])cArray);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((Writer)object2).close();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        ((Writer)object2).close();
        this.checkRemove((Meta)object);
        this.addMeta((Meta)object);
        this.writeMeta();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store(String string, String string2, StringBuffer stringBuffer, int n, int n2) throws IOException {
        Object object;
        Object object2;
        String string3 = null;
        File file = null;
        do {
            string3 = "f" + ++this.fMaxRel;
        } while ((file = new File((String)(object2 = Misc.fileUrlToPath((String)(object = String.valueOf(this.fDirUrl) + string3))))).exists());
        file.createNewFile();
        object = new Meta(string, string2, string3);
        object2 = this.fileWriter(file);
        try {
            Misc.write((Writer)object2, (StringBuffer)stringBuffer, (int)n, (int)n2);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            ((Writer)object2).close();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        ((Writer)object2).close();
        this.checkRemove((Meta)object);
        this.addMeta((Meta)object);
        this.writeMeta();
    }

    public synchronized char[] load(String string, String string2) throws IOException {
        Meta meta = this.findMeta(string, string2);
        if (meta == null) {
            return null;
        }
        File file = this.relFile(meta.rel);
        Reader reader = this.fileReader(file);
        return Misc.readContents((Reader)reader);
    }

    private Meta findMeta(String string, String string2) {
        Meta meta;
        Meta meta2 = meta = string == null ? null : (Meta)this.fPubToMeta.get(string);
        if (meta == null) {
            meta = string2 == null ? null : (Meta)this.fAbsToMeta.get(string2);
        }
        return meta;
    }

    public synchronized boolean load(String string, String string2, StringBuffer stringBuffer) throws IOException {
        Meta meta = this.findMeta(string, string2);
        if (meta == null) {
            return false;
        }
        File file = this.relFile(meta.rel);
        Reader reader = this.fileReader(file);
        Misc.readContents((Reader)reader, (StringBuffer)stringBuffer);
        return true;
    }

    private Reader fileReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
    }

    private Writer fileWriter(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
    }

    private void parseMeta() throws IOException {
        char[] cArray = Misc.readContents((Reader)this.fileReader(this.fMetaFile));
        int n = 0;
        int n2 = cArray.length;
        while ((n = this.skipto('<', cArray, n, n2)) != n2) {
            int n3;
            boolean bl = this.match(BEGPUB, cArray, n, n2);
            if (!bl && !this.match(NULPUB, cArray, n, n2)) {
                ++n;
                continue;
            }
            String string = null;
            if (bl) {
                n3 = n += BEGPUB.length();
                if ((n = this.skipto('<', cArray, n, n2)) == n2 || !this.match(ENDPUB, cArray, n, n2)) {
                    throw new IllegalStateException("Missing </pub> in meta file");
                }
                string = this.decode(new String(cArray, n3, n - n3));
                n += ENDPUB.length();
            } else {
                n += NULPUB.length();
            }
            String string2 = null;
            n = this.skipto('<', cArray, n, n2);
            if (this.match(NULABS, cArray, n, n2)) {
                n += NULABS.length();
            } else {
                if (n == n2 || !this.match(BEGABS, cArray, n, n2)) {
                    throw new IllegalStateException("Missing <abs> in meta file");
                }
                n3 = n += BEGABS.length();
                if ((n = this.skipto('<', cArray, n, n2)) == n2 || !this.match(ENDABS, cArray, n, n2)) {
                    throw new IllegalStateException("Missing </abs> in meta file");
                }
                string2 = this.decode(new String(cArray, n3, n - n3));
                n += ENDABS.length();
            }
            n = this.skipto('<', cArray, n, n2);
            if (n == n2 || !this.match(BEGREL, cArray, n, n2)) {
                throw new IllegalStateException("Missing <rel> in meta file");
            }
            n3 = n += BEGREL.length();
            if ((n = this.skipto('<', cArray, n, n2)) == n2 || !this.match(ENDREL, cArray, n, n2)) {
                throw new IllegalStateException("Missing </rel> in meta file");
            }
            String string3 = new String(cArray, n3, n - n3);
            n += ENDREL.length();
            try {
                int n4 = Integer.parseInt(string3.substring(1));
                if (this.fMaxRel < n4) {
                    this.fMaxRel = n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Unknown rel format " + string3);
            }
            Meta meta = new Meta(string, string2, string3);
            this.addMeta(meta);
        }
    }

    private void addMeta(Meta meta) {
        this.fMeta.add(meta);
        if (meta.pub != null) {
            this.fPubToMeta.put(meta.pub, meta);
        }
        if (meta.abs != null) {
            this.fAbsToMeta.put(meta.abs, meta);
        }
    }

    private void checkRemove(Meta meta) {
        Meta meta2 = meta.pub != null ? this.fPubToMeta.get(meta.pub) : null;
        if (meta2 != null) {
            if (meta2.abs == null || meta2.abs.equals(meta.abs)) {
                this.removeFile(meta2);
            } else {
                meta2.pub = null;
            }
        }
        if ((meta2 = (Meta)(meta.abs != null ? this.fAbsToMeta.get(meta.abs) : null)) != null) {
            if (meta2.pub == null || meta2.pub.equals(meta.pub)) {
                this.removeFile(meta2);
            } else {
                meta2.abs = null;
            }
        }
    }

    private void removeFile(Meta meta) {
        File file = this.relFile(meta.rel);
        if (file.exists()) {
            file.delete();
        }
        Iterator iterator = this.fMeta.iterator();
        while (iterator.hasNext()) {
            Meta meta2 = (Meta)iterator.next();
            if (meta2 != meta) continue;
            iterator.remove();
            break;
        }
        if (meta.pub != null && meta == this.fPubToMeta.get(meta.pub)) {
            this.fPubToMeta.remove(meta.pub);
        }
        if (meta.abs != null && meta == this.fAbsToMeta.get(meta.abs)) {
            this.fAbsToMeta.remove(meta.abs);
        }
    }

    private File relFile(String string) {
        String string2 = String.valueOf(this.fDirUrl) + string;
        String string3 = Misc.fileUrlToPath((String)string2);
        return new File(string3);
    }

    private int skipto(char c, char[] cArray, int n, int n2) {
        while (n < n2 && cArray[n] != c) {
            if (cArray[n] == c) break;
            ++n;
        }
        return n;
    }

    private boolean match(String string, char[] cArray, int n, int n2) {
        int n3 = n + string.length();
        if (n3 > n2) {
            return false;
        }
        int n4 = 0;
        while (n < n3) {
            if (cArray[n] != string.charAt(n4)) {
                return false;
            }
            ++n4;
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeMeta() throws IOException {
        Writer writer = this.fileWriter(this.fMetaFile);
        try {
            writer.write("<?xml version='1.0' encoding='UTF-8'?>");
            this.writeEOL(writer);
            writer.write("<!-- Cached file directory. Do not edit this file by hand -->");
            this.writeEOL(writer);
            writer.write("<meta>");
            this.writeEOL(writer);
            Iterator iterator = this.fMeta.iterator();
            while (true) {
                block8: {
                    if (iterator.hasNext()) break block8;
                    writer.write("</meta>");
                    this.writeEOL(writer);
                    break;
                }
                Meta meta = (Meta)iterator.next();
                writer.write("  <file>");
                this.writeEOL(writer);
                if (meta.pub != null) {
                    writer.write("    <pub>");
                    writer.write(this.encode(meta.pub));
                    writer.write(ENDPUB);
                } else {
                    writer.write("    <pub null='true'/>");
                }
                this.writeEOL(writer);
                if (meta.abs != null) {
                    writer.write("    <abs>");
                    writer.write(this.encode(meta.abs));
                    writer.write(ENDABS);
                } else {
                    writer.write("    <abs null='true'/>");
                }
                this.writeEOL(writer);
                writer.write("    <rel>");
                writer.write(meta.rel);
                writer.write(ENDREL);
                this.writeEOL(writer);
                writer.write("  </file>");
                this.writeEOL(writer);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        writer.close();
    }

    private void writeEOL(Writer writer) throws IOException {
        writer.write(Misc.EOL);
    }

    private String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (cArray[n] == '&') {
                if (this.match("&lt;", cArray, n, n2)) {
                    stringBuffer.append('<');
                    n += 3;
                } else if (this.match("&amp;", cArray, n, n2)) {
                    stringBuffer.append('&');
                    n += 4;
                } else {
                    stringBuffer.append('&');
                }
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getSysid(String string) {
        Meta meta = (Meta)this.fPubToMeta.get(string);
        return meta != null ? meta.abs : null;
    }

    public List getIds() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.fMeta.iterator();
        while (iterator.hasNext()) {
            Meta meta = (Meta)iterator.next();
            linkedList.add(meta.pub);
            linkedList.add(meta.abs);
        }
        return linkedList;
    }

    public void clear() throws IOException {
        this.fMeta.clear();
        this.writeMeta();
    }

    private static class Meta {
        public String pub;
        public String abs;
        public String rel;

        public Meta(String string, String string2, String string3) {
            this.pub = string;
            this.abs = string2;
            this.rel = string3;
        }
    }
}

