/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.io;

import com.objfac.util.Misc;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.io.IDocumentCache;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.io.IDocumentStore;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DocumentCache
implements IDocumentCache {
    private static DocumentCache fCache = new DocumentCache();
    private LinkedList fStores = new LinkedList();
    private boolean fEnabled;

    public synchronized char[] getContents(String string, String string2, String string3, IDocumentReaderFactory iDocumentReaderFactory) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getContents(stringBuffer, string, string2, string3, iDocumentReaderFactory);
        return Misc.toCharArray((StringBuffer)stringBuffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void getContents(StringBuffer stringBuffer, String string, String string2, String string3, IDocumentReaderFactory iDocumentReaderFactory) throws IOException {
        URL uRL;
        String string4 = Misc.getAbsUrl((String)string3, (String)string2);
        String string5 = iDocumentReaderFactory.resolve(string, string2, string3, string4);
        if (this.fEnabled && string5 == null && this.getContentsFromCache(stringBuffer, string, string4, iDocumentReaderFactory)) {
            return;
        }
        if (string5 != null) {
            string4 = string5;
        }
        if (string4 == null) {
            throw new FileNotFoundException("No file found for PUBLIC id or namespace " + string);
        }
        int n = stringBuffer.length();
        Reader reader = iDocumentReaderFactory.getReader(string4);
        try {
            try {
                Misc.readContents((Reader)reader, (StringBuffer)stringBuffer);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                reader.close();
                uRL = new URL(string4);
                InputStream inputStream = uRL.openStream();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                stringBuffer.setLength(0);
                Misc.readContents((Reader)reader, (StringBuffer)stringBuffer);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            reader.close();
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        reader.close();
        if (!this.fEnabled) return;
        if (string5 != null) return;
        if (this.fStores.size() == 0) {
            return;
        }
        IDocumentStore iDocumentStore = (IDocumentStore)this.fStores.getFirst();
        uRL = iDocumentStore;
        if (uRL == null) return;
        if (string4.startsWith("file:")) return;
        if (uRL.isReadOnly()) return;
        uRL.store(string, string4, stringBuffer, n, stringBuffer.length());
    }

    public synchronized boolean getContentsFromCache(StringBuffer stringBuffer, String string, String string2, IDocumentReaderFactory iDocumentReaderFactory) throws IOException {
        if (string2 == null || !string2.startsWith("file:")) {
            string = XMLCharacter.normalize(string);
            Iterator iterator = this.fStores.iterator();
            while (iterator.hasNext()) {
                IDocumentStore iDocumentStore = (IDocumentStore)iterator.next();
                if (!iDocumentStore.isStored(string, string2) || !iDocumentStore.load(string, string2, stringBuffer)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized String getSysid(String string) throws IOException {
        string = XMLCharacter.normalize(string);
        Iterator iterator = this.fStores.iterator();
        while (iterator.hasNext()) {
            IDocumentStore iDocumentStore = (IDocumentStore)iterator.next();
            String string2 = iDocumentStore.getSysid(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public static DocumentCache getCache() {
        return fCache;
    }

    public synchronized void enableCache(boolean bl) {
        this.fEnabled = bl;
    }

    public synchronized boolean isEnabled() {
        return this.fEnabled;
    }

    public synchronized void clearCache() throws IOException {
        Iterator iterator = this.fStores.iterator();
        while (iterator.hasNext()) {
            IDocumentStore iDocumentStore = (IDocumentStore)iterator.next();
            iDocumentStore.clear();
        }
    }

    public synchronized void addStore(IDocumentStore iDocumentStore) {
        this.fStores.addFirst(iDocumentStore);
    }

    public synchronized void removeStore(IDocumentStore iDocumentStore) {
        this.fStores.remove(iDocumentStore);
    }

    private DocumentCache() {
    }

    public List getIds() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.fStores.iterator();
        while (iterator.hasNext()) {
            IDocumentStore iDocumentStore = (IDocumentStore)iterator.next();
            List list = iDocumentStore.getIds();
            linkedList.addAll(list);
        }
        return linkedList;
    }
}

