/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.io;

import com.objfac.util.Misc;
import com.objfac.xml.io.AbstractDocumentStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDocumentStore
extends AbstractDocumentStore {
    private boolean fReadOnly;
    private String fCacheDir;

    public FileDocumentStore(String string, boolean bl) {
        this.fCacheDir = string.endsWith("/") ? string : String.valueOf(string) + "/";
        this.fReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    protected String abs(String string) {
        return String.valueOf(this.fCacheDir) + string;
    }

    protected File getFile(String string) {
        String string2 = Misc.fileUrlToPath((String)this.abs(string));
        return new File(string2);
    }

    public boolean exists(String string) {
        return this.getFile(string).exists();
    }

    public InputStream getInputStream(String string) throws IOException {
        return new FileInputStream(this.getFile(string));
    }

    public boolean create(String string) throws IOException {
        if (this.isReadOnly()) {
            return super.create(string);
        }
        return this.getFile(string).createNewFile();
    }

    public boolean remove(String string) throws IOException {
        if (this.isReadOnly()) {
            return super.remove(string);
        }
        return this.getFile(string).delete();
    }

    public OutputStream getOutputStream(String string) throws IOException {
        if (this.isReadOnly()) {
            return super.getOutputStream(string);
        }
        return new FileOutputStream(this.getFile(string));
    }

    public void clear() throws IOException {
        if (!this.isReadOnly()) {
            this.clearStore();
        }
    }
}

