/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.parsers;

import com.objfac.util.Local;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.parsers.IEntityHandler;
import com.objfac.xml.parsers.IErrorHandler;
import com.objfac.xml.schema.IExternalEntity;
import java.util.LinkedList;

public class Lexer {
    public static final int BAD = 1;
    public static final int EOF = 2;
    public static final int LT = 4;
    public static final int GT = 8;
    public static final int QUESTION = 16;
    public static final int ID = 32;
    public static final int STRING = 64;
    public static final int COMMENT = 128;
    public static final int ENTITY = 256;
    public static final int ELEMENT = 512;
    public static final int ATTLIST = 1024;
    public static final int INCBEG = 2048;
    public static final int INCEND = 4096;
    public static final int LBRACKET = 8192;
    public static final int KEYWORD = 16384;
    public static final int LPAREN = 32768;
    public static final int RPAREN = 65536;
    public static final int COMMA = 131072;
    public static final int OR = 262144;
    public static final int STAR = 524288;
    public static final int PLUS = 0x100000;
    public static final int NM = 0x200000;
    public static final int RBRACKET = 0x400000;
    public static final int EQ = 0x800000;
    public static final int NOTATION = 0x1000000;
    public static final int PE = 0x2000000;
    public static final int GE = 0x4000000;
    public static final int PERCENT = 0x8000000;
    public static final int TEXT = 0x10000000;
    public static final int CDATA = 0x20000000;
    public static final int DOCTYPE = 0x40000000;
    public static final int OTHER = Integer.MIN_VALUE;
    private static final int MALMAX = 10;
    private static final int NONMAX = 10;
    private char[] fBuf;
    private int fBeg;
    private int fPos;
    private int fEnd;
    private int fLin;
    private LinkedList fStack;
    private String fValue;
    private String fString;
    private int fToken;
    private int fTokBeg;
    private int fTokEnd;
    private int fBad;
    private IExternalEntity fEnt;
    private static char[] fOne = new char[1];
    private boolean fInternal = true;
    private boolean fEof = false;
    private int fMal = 0;
    private int fNon = 0;
    private int fMalMax = 10;
    private int fNonMax = 10;
    private Object fObj;
    private IEntityHandler fEntityHandler;
    private IErrorHandler fErrorHandler;

    public Lexer() {
    }

    public Lexer(char[] cArray, int n, int n2, IExternalEntity iExternalEntity, String string) {
        this.pushBuffer(cArray, n, n2, iExternalEntity, string);
    }

    public void pushBuffer(char[] cArray, int n, int n2, IExternalEntity iExternalEntity, Object object) {
        if (this.fStack == null) {
            this.fStack = new LinkedList();
        } else {
            Entry entry = new Entry();
            entry.fBuf = this.fBuf;
            entry.fBeg = this.fBeg;
            entry.fEnd = this.fEnd;
            entry.fLin = this.fLin;
            entry.fPos = this.fPos;
            entry.fObj = this.fObj;
            this.fStack.addFirst(entry);
        }
        this.fBuf = cArray;
        this.fBeg = n;
        this.fEnd = n2;
        this.fEnt = iExternalEntity;
        this.fLin = 0;
        this.fPos = 0;
        this.fObj = object;
    }

    public boolean popBuffer() {
        if (this.fStack == null || this.fStack.size() == 0) {
            return false;
        }
        Entry entry = (Entry)this.fStack.removeFirst();
        this.fBuf = entry.fBuf;
        this.fBeg = entry.fBeg;
        this.fEnd = entry.fEnd;
        this.fLin = entry.fLin;
        this.fPos = entry.fPos;
        this.fObj = entry.fObj;
        return true;
    }

    public void popAllBuffers() {
        this.fStack = null;
        this.fBuf = null;
        this.fEnt = null;
        this.fObj = null;
    }

    public int getNumBuffers() {
        return 1 + (this.fStack == null ? 0 : this.fStack.size());
    }

    public int getLineNumber(int n) {
        this.checkIndex(n);
        return n == 0 ? this.fLin : this.getEntry((int)(n - 1)).fLin;
    }

    public int getLineOffset(int n) {
        this.checkIndex(n);
        return this.internalGetLineOffset(n);
    }

    private int internalGetLineOffset(int n) {
        char[] cArray = n == 0 ? this.fBuf : this.getEntry((int)(n - 1)).fBuf;
        int n2 = n == 0 ? this.fPos : this.getEntry((int)(n - 1)).fPos;
        while (n2 > 0 && cArray[n2] != '\n' && cArray[n2] != '\r') {
            --n2;
        }
        return n2;
    }

    public int getBufferOffset(int n) {
        this.checkIndex(n);
        return this.internalGetBufferOffset(n);
    }

    private int internalGetBufferOffset(int n) {
        return n == 0 ? this.fPos : this.getEntry((int)(n - 1)).fPos;
    }

    public int getCharOffset(int n) {
        this.checkIndex(n);
        return this.internalGetBufferOffset(n) - this.internalGetLineOffset(n);
    }

    private void checkIndex(int n) {
        int n2 = this.getNumBuffers();
        if (n >= n2 || n < 0) {
            throw new IllegalArgumentException(Local.format((String)"Index {0} out of bounds", (Object)("" + n)));
        }
    }

    private Entry getEntry(int n) {
        return (Entry)this.fStack.get(n);
    }

    public IExternalEntity getEntity(int n) {
        this.checkIndex(n);
        return n == 0 ? this.fEnt : this.getEntry((int)(n - 1)).fEnt;
    }

    public Object getParserObject(int n) {
        this.checkIndex(n);
        return n == 0 ? this.fObj : this.getEntry((int)(n - 1)).fObj;
    }

    public void setXml(boolean bl) {
        this.fInternal = bl;
    }

    public void setErrorLimits(int n, int n2) {
        this.fMalMax = n;
        this.fNonMax = n2;
    }

    public boolean isXml() {
        return this.fInternal;
    }

    public String getToken() {
        return this.fValue;
    }

    public String getString() {
        return this.fString;
    }

    public int getTokenBegin() {
        return this.fTokBeg;
    }

    public int getTokenEnd() {
        return this.fTokEnd;
    }

    public int getPosition() {
        return this.fPos;
    }

    public int nextToken() {
        int n;
        this.fToken = 1;
        do {
            n = this.skipWS();
            this.fTokBeg = this.fTokEnd = this.fPos - 1;
            if (n >= 0) continue;
            this.fTokBeg = this.fTokEnd = this.fPos;
            break;
        } while (n == 37 && !this.fInternal && this.expandPE());
        if (n < 0) {
            this.fToken = 2;
        } else {
            switch (XMLCharacter.charType(n)) {
                case 11: {
                    n = this.nextChar();
                    if (n == 33) {
                        n = this.nextChar();
                        if (n == 91) {
                            this.fValue = "<![";
                            this.fToken = 2048;
                            break;
                        }
                        this.pushChar();
                    }
                    this.pushChar();
                    this.fValue = "<";
                    this.fToken = 4;
                    break;
                }
                case 12: {
                    this.fValue = ">";
                    this.fToken = 8;
                    break;
                }
                case 8: {
                    this.fValue = "=";
                    this.fToken = 0x800000;
                    break;
                }
                case 19: {
                    this.fValue = "?";
                    this.fToken = 16;
                    break;
                }
                case 15: {
                    this.fValue = "(";
                    this.fToken = 32768;
                    break;
                }
                case 16: {
                    this.fValue = ")";
                    this.fToken = 65536;
                    break;
                }
                case 26: {
                    this.fValue = ",";
                    this.fToken = 131072;
                    break;
                }
                case 27: {
                    this.fValue = "|";
                    this.fToken = 262144;
                    break;
                }
                case 9: 
                case 10: {
                    Lexer.fOne[0] = (char)n;
                    this.fValue = new String(fOne);
                    this.collectString(n);
                    return 64;
                }
                case 14: {
                    n = this.nextChar();
                    if (n == 45) {
                        n = this.nextChar();
                        if (n == 45) {
                            this.scanComment();
                            this.fValue = "!--";
                            this.fToken = 128;
                            break;
                        }
                        this.pushChar();
                        break;
                    }
                    if (n == 91) {
                        this.fValue = "![";
                        this.fToken = 2048;
                        break;
                    }
                    if (XMLCharacter.isIDStart((char)n)) {
                        this.fValue = this.collectId(n);
                        if (this.fValue.equals("DOCTYPE")) {
                            this.fToken = 0x40000000;
                        }
                        if (this.fValue.equals("ELEMENT")) {
                            this.fToken = 512;
                            break;
                        }
                        if (this.fValue.equals("ENTITY")) {
                            this.fToken = 256;
                            break;
                        }
                        if (this.fValue.equals("ATTLIST")) {
                            this.fToken = 1024;
                            break;
                        }
                        if (!this.fValue.equals("NOTATION")) break;
                        this.fToken = 0x1000000;
                        break;
                    }
                    this.pushChar();
                    break;
                }
                case 17: {
                    this.fValue = "[";
                    this.fToken = 8192;
                    break;
                }
                case 18: {
                    n = this.nextChar();
                    if (n == 93) {
                        n = this.nextChar();
                        if (n == 62) {
                            this.fValue = "]]>";
                            this.fToken = 4096;
                            break;
                        }
                        this.pushChar();
                    }
                    this.pushChar();
                    this.fValue = "]";
                    this.fToken = 0x400000;
                    break;
                }
                case 24: {
                    this.fValue = "*";
                    this.fToken = 524288;
                    break;
                }
                case 25: {
                    this.fValue = "+";
                    this.fToken = 0x100000;
                    break;
                }
                case 22: {
                    this.fValue = this.collectId(n);
                    this.fToken = 16384;
                    break;
                }
                case 23: {
                    this.fValue = this.parsePE();
                    if (this.fValue.length() <= 0) break;
                    this.fToken = 0x2000000;
                    break;
                }
                case 0: {
                    if (this.nextChar() < 0) {
                        this.malformedError(n);
                        this.pushChar();
                        break;
                    }
                    this.error("dtdparser_illegal_token_4", Integer.toHexString(0x100000 + n));
                    break;
                }
                case 2: {
                    this.malformedError(n);
                    break;
                }
                case 1: {
                    this.nonXmlError(n);
                    break;
                }
                case 6: {
                    this.fValue = this.collectId(n);
                    this.fToken = 32;
                    break;
                }
                case 7: {
                    this.fValue = this.collectId(n);
                    this.fToken = 0x200000;
                    break;
                }
                default: {
                    this.fToken = Integer.MIN_VALUE;
                    this.fValue = this.collectOther(n);
                }
            }
        }
        this.fTokEnd = this.fPos;
        return this.fToken;
    }

    private String collectOther(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)n);
        while (!XMLCharacter.isWhitespace(n = this.nextChar())) {
            int n2 = XMLCharacter.charType(n);
            if (n2 != 28) break;
            stringBuffer.append((char)n);
        }
        this.pushChar();
        return stringBuffer.toString();
    }

    private int nextChar() {
        this.fEof = false;
        while (true) {
            if (this.fPos < this.fEnd) {
                char c;
                if ((c = this.fBuf[this.fPos++]) == '\n' || c == '\r' && this.fPos < this.fEnd && this.fBuf[this.fPos] != '\n') {
                    ++this.fLin;
                }
                return c;
            }
            if (this.fStack == null || this.fStack.size() <= 0) break;
            this.popBuffer();
        }
        this.fEof = true;
        return -1;
    }

    private void pushChar() {
        if (this.fPos == this.fBeg) {
            throw new IllegalStateException("dtdparser_internal_pushChar()_before_start_7");
        }
        if (!this.fEof && this.fBuf[--this.fPos] == '\n') {
            --this.fLin;
        }
    }

    private String collectId(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append((char)n);
        } while (XMLCharacter.isIDPart((char)(n = this.nextChar())));
        this.pushChar();
        return stringBuffer.toString();
    }

    private String collectId() {
        int n = this.nextChar();
        if (XMLCharacter.isIDStart((char)n)) {
            return this.collectId(n);
        }
        this.pushChar();
        return "";
    }

    private String parsePE() {
        String string = this.collectId();
        if (string.length() == 0) {
            this.error("dtdparser_pe_name_expected_9");
        } else {
            int n = this.nextChar();
            if (n != 59) {
                this.error("dtdparser_;_expected_after_pe_name_10");
                string = "";
                this.pushChar();
            }
        }
        return string;
    }

    private void collectString(int n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.nextChar()) != n2 && n >= 0) {
            if (!this.goodChar(n)) continue;
            stringBuffer.append((char)n);
        }
        this.fString = stringBuffer.toString();
        if (n >= 0) {
            stringBuffer.append((char)n);
        }
        stringBuffer.insert(0, (char)n2);
        this.fValue = stringBuffer.toString();
    }

    private boolean scanComment() {
        block4: {
            while (true) {
                int n;
                if (!this.goodChar(n = this.nextChar())) continue;
                if (n == 45) {
                    n = this.nextChar();
                    if (n == 45) {
                        n = this.nextChar();
                        if (n != 62) {
                            return this.error("dtdparser_--_not_fol_by_>_12");
                        }
                        break block4;
                    }
                    this.pushChar();
                    continue;
                }
                if (n < 0) break;
            }
            return this.error("dtdparser_unterminated_comment_13");
        }
        return true;
    }

    private boolean goodChar(int n) {
        switch (XMLCharacter.charType(n)) {
            case 2: {
                return this.malformedError(n);
            }
            case 1: {
                return this.nonXmlError(n);
            }
            case 0: {
                if (this.nextChar() >= 0) break;
                this.malformedError(n);
                this.pushChar();
                return false;
            }
        }
        return true;
    }

    private boolean malformedError(int n) {
        if (++this.fMal <= this.fMalMax) {
            if (this.fMal == this.fMalMax) {
                return this.error("dtdparser_too_many_malformed_characters_17");
            }
            return this.error("dtdparser_malformed_character_{0}_18", "[" + Integer.toHexString(n) + "]");
        }
        return false;
    }

    private boolean nonXmlError(int n) {
        if (++this.fNon <= this.fNonMax) {
            if (this.fNon == this.fNonMax) {
                return this.error("dtdparser_too_many_non-XML_characters_21");
            }
            return this.error("dtdparser_non-XML_character_{0}_22", "[" + Integer.toHexString(n) + "]");
        }
        return false;
    }

    private boolean expandPE() {
        return this.expandEntity(false);
    }

    private boolean expandEntity(boolean bl) {
        int n = this.fPos;
        String string = this.parseEntity();
        if (string == null || this.fEntityHandler == null || !this.fEntityHandler.entityToken(string, bl)) {
            this.fPos = n;
            return false;
        }
        return true;
    }

    private String parseEntity() {
        return null;
    }

    private int skipWS() {
        int n;
        while ((n = this.nextChar()) >= 0 && XMLCharacter.isWhitespace(n)) {
        }
        return n;
    }

    private void requireWS(String string) {
        int n = this.nextChar();
        if (!XMLCharacter.isWhitespace(n)) {
            this.error(string);
        }
        this.pushChar();
    }

    private void noWS(String string) {
        int n = this.nextChar();
        if (XMLCharacter.isWhitespace(n)) {
            this.error(string);
        }
        this.pushChar();
    }

    private boolean peekWS() {
        int n = this.nextChar();
        boolean bl = XMLCharacter.isWhitespace(n);
        this.pushChar();
        return bl;
    }

    private boolean error(String string) {
        return this.handleError(Local.getString((String)string));
    }

    private boolean error(String string, String string2) {
        return this.handleError(Local.format((String)string, (Object)string2));
    }

    private boolean error(String string, String string2, String string3) {
        return this.handleError(Local.format((String)string, (Object)string2, (Object)string3));
    }

    private boolean handleError(String string) {
        if (this.fErrorHandler != null) {
            return this.fErrorHandler.error(string);
        }
        return false;
    }

    private static class Entry {
        public char[] fBuf;
        public int fPos;
        public int fBeg;
        public int fEnd;
        public int fLin;
        public IExternalEntity fEnt;
        public Object fObj;

        Entry() {
        }
    }
}

