/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.bm.view;

import aurora.ide.editor.textpage.TextPage;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.project.AuroraProject;
import aurora.ide.screen.editor.ServiceEditor;
import aurora.ide.views.Activator;
import aurora.ide.views.IListener;
import aurora.ide.views.bm.BMTransferDropTargetListener;
import aurora.ide.views.bm.view.BMViewer;
import aurora.ide.views.bm.view.ModulesComposite;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class BusinessModelView
extends ViewPart {
    private IListener moduleChangedListener = new IListener(){

        @Override
        public void handleEvent(Object object) {
            BusinessModelView.this.modelsViewer.setInput((IFolder)object);
        }
    };
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof ServiceEditor) {
                TextPage textPage = ((ServiceEditor)part).getTextPage();
                StyledText textWidget = (StyledText)textPage.getAdapter(StyledText.class);
                BMTransferDropTargetListener listener = new BMTransferDropTargetListener(textPage);
                DropTarget realDropTarget = (DropTarget)textWidget.getData("DropTarget");
                if (realDropTarget == null) {
                    return;
                }
                realDropTarget.addDropListener((DropTargetListener)listener);
                Transfer[] transfers = realDropTarget.getTransfer();
                Transfer[] allTransfers = new Transfer[transfers.length + 1];
                int curTransfer = 0;
                int i = 0;
                while (i < transfers.length) {
                    allTransfers[curTransfer++] = transfers[i];
                    ++i;
                }
                allTransfers[curTransfer++] = listener.getTransfer();
                realDropTarget.setTransfer(allTransfers);
            }
        }
    };
    private ModulesComposite modulesComposite;
    private BMViewer modelsViewer;
    private Action projectSelectionAtion;

    public BusinessModelView() {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IPartService partService = window.getPartService();
        partService.addPartListener(this.partListener);
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference e = iEditorReferenceArray[n2];
                IEditorPart editor = e.getEditor(false);
                this.partListener.partOpened((IWorkbenchPart)editor);
                ++n2;
            }
        }
    }

    public void dispose() {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        window.getPartService().removePartListener(this.partListener);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite p = new Composite(parent, 0);
        p.setLayout((Layout)new GridLayout(2, false));
        ScrolledComposite sc1 = new ScrolledComposite(p, 2816);
        sc1.setLayoutData((Object)new GridData(1040));
        this.modulesComposite = new ModulesComposite((Composite)sc1, 0);
        sc1.setMinSize(70, 400);
        sc1.setContent((Control)this.modulesComposite);
        this.modulesComposite.addListener(this.moduleChangedListener);
        this.modelsViewer = new BMViewer(p);
        this.modelsViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectObject = BusinessModelView.this.modelsViewer.getSelectObject();
                if (selectObject instanceof IFile) {
                    try {
                        IDE.openEditor((IWorkbenchPage)BusinessModelView.this.getSite().getPage(), (IFile)((IFile)selectObject), (boolean)true);
                    }
                    catch (PartInitException e) {
                        DialogUtil.logErrorException((Throwable)e);
                    }
                }
            }
        });
        this.createActions();
        this.contributeToActionBars();
    }

    public void setInput(IProject p) {
        AuroraProject ap = new AuroraProject(p);
        IFolder web_classes = ap.getWeb_classes();
        if (web_classes != null) {
            this.setInput(web_classes);
        }
    }

    private void setInput(IFolder web_classes) {
        this.modulesComposite.setInput((IContainer)web_classes);
        this.modelsViewer.setInput(web_classes);
    }

    public void setFocus() {
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager menuManager = bars.getMenuManager();
        this.fillLocalPullDown(menuManager);
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void createActions() {
        this.projectSelectionAtion = new Action("Project Selection", 4){
            private List<IProject> projects;
            {
                this.setId("projectSelectionAtion");
                this.projects = ProjectUtil.getALLAuroraProjects();
            }

            public IMenuCreator getMenuCreator() {
                return new MenuCreator();
            }

            public void run() {
                if (this.projects != null && this.projects.size() > 0) {
                    BusinessModelView.this.setInput(this.projects.get(0));
                }
            }

            class MenuCreator
            implements IMenuCreator,
            SelectionListener {
                MenuCreator() {
                }

                public void dispose() {
                }

                public Menu getMenu(Control parent) {
                    final Menu menu = new Menu(parent);
                    menu.addMenuListener(new MenuListener(){

                        public void menuShown(MenuEvent e) {
                            MenuCreator.this.fillMenu(menu);
                        }

                        public void menuHidden(MenuEvent e) {
                        }
                    });
                    return menu;
                }

                public void fillMenu(Menu menu) {
                    projects = ProjectUtil.getALLAuroraProjects();
                    for (IProject p : projects) {
                        MenuItem mi = new MenuItem(menu, 0);
                        mi.setText("Load : " + p.getName());
                        mi.setData((Object)p);
                        mi.setImage(ImagesUtils.getImage((String)"prj_obj.gif"));
                        mi.addSelectionListener((SelectionListener)this);
                    }
                }

                public Menu getMenu(Menu parent) {
                    final Menu menu = new Menu(parent);
                    menu.addMenuListener(new MenuListener(){

                        public void menuShown(MenuEvent e) {
                            MenuCreator.this.fillMenu(menu);
                        }

                        public void menuHidden(MenuEvent e) {
                        }
                    });
                    return menu;
                }

                public void widgetSelected(SelectionEvent e) {
                    MenuItem mi = (MenuItem)e.getSource();
                    BusinessModelView.this.setInput((IProject)mi.getData());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            }
        };
        this.projectSelectionAtion.setImageDescriptor(ImagesUtils.getImageDescriptor((String)"prj_obj.gif"));
    }

    private void fillLocalToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.projectSelectionAtion);
    }
}

