/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceSelector
implements ISelectionChangedListener {
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
    private Color borderColor = new Color(null, 171, 173, 179);
    private TreeViewer treeViewer;
    private IResource result;
    private CLabel parLabel;
    private Dialog dia;
    private IContainer root;
    private String[] extFilters = null;
    private boolean dirOnly = false;

    public ResourceSelector(Shell shell) {
        this.dia = new Dialog(shell){

            protected Control createDialogArea(Composite parent) {
                Composite container = (Composite)super.createDialogArea(parent);
                ResourceSelector.this.createControl(container);
                return container;
            }

            protected Point getInitialSize() {
                return new Point(400, 450);
            }
        };
    }

    public ResourceSelector(Composite parent, int style) {
        Composite com = new Composite(parent, style);
        this.createControl(com);
    }

    protected void createControl(Composite com) {
        com.setLayout((Layout)new GridLayout(1, true));
        Label l = new Label(com, 0);
        l.setForeground(new Color(null, 87, 87, 87));
        l.setText("? = any character , * = any string");
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        FilteredTree ff = new FilteredTree(com, 4, new PatternFilter(), true);
        ff.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = ff.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.root != null) {
            this.treeViewer.setInput((Object)this.root);
        }
        this.parLabel = new CLabel(com, 0);
        this.parLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.parLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ResourceSelector.this.borderColor);
                Point p = ResourceSelector.this.parLabel.getSize();
                e.gc.drawRectangle(0, 0, p.x - 1, p.y - 1);
            }
        });
        ff.getViewer().getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem ti = ResourceSelector.this.getTreeViewer().getTree().getItem(new Point(e.x, e.y));
                if (ti != null) {
                    if (!ResourceSelector.this.dirOnly && ti.getData() instanceof IContainer) {
                        return;
                    }
                    ResourceSelector.this.result = (IResource)ti.getData();
                    if (ResourceSelector.this.dia != null) {
                        ResourceSelector.this.dia.close();
                    }
                }
            }
        });
    }

    public void setExtFilter(String[] exts) {
        this.extFilters = exts;
    }

    public void setDirOnly(boolean donly) {
        this.dirOnly = donly;
    }

    public void setInput(IContainer iContainer) {
        this.root = iContainer;
        if (this.dia != null) {
            this.dia.setBlockOnOpen(true);
            this.dia.create();
            String title = this.root.getProject() == null ? "/" : this.root.getProject().getName();
            this.dia.getShell().setText("Select Resource [" + title + "]");
            if (this.dia.open() != 0) {
                this.result = null;
            }
        }
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.setInput((Object)iContainer);
        }
    }

    public IResource getSelection() {
        return this.result;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection ss;
        ISelection s = event.getSelection();
        if (s instanceof IStructuredSelection && !(ss = (IStructuredSelection)s).isEmpty()) {
            this.result = (IResource)ss.getFirstElement();
            IContainer r = this.result.getParent();
            this.parLabel.setImage(this.labelProvider.getImage((Object)r));
            this.parLabel.setText(r.getFullPath().toString());
        }
    }

    protected boolean accept(IResource res) {
        if (res instanceof IFile) {
            if (this.dirOnly) {
                return false;
            }
            if (this.extFilters == null) {
                return true;
            }
            String fileName = res.getName().toLowerCase();
            String[] stringArray = this.extFilters;
            int n = this.extFilters.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (fileName.endsWith("." + ext.toLowerCase())) {
                    return true;
                }
                ++n2;
            }
        } else if (res instanceof IContainer) {
            return this.dirOnly;
        }
        return false;
    }

    public Dialog getDialog() {
        return this.dia;
    }

    public void setResult(IResource result) {
        this.result = result;
    }

    class ResourceContentProvider
    extends WorkbenchContentProvider
    implements Comparator<IResource> {
        ResourceContentProvider() {
        }

        public Object[] getChildren(Object element) {
            Object[] objs = super.getChildren(element);
            ArrayList<IResource> als = new ArrayList<IResource>();
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IResource r = (IResource)o;
                if (!r.getName().startsWith(".")) {
                    if (ResourceSelector.this.accept(r)) {
                        als.add(r);
                    } else if (this.hasChildren(r)) {
                        als.add(r);
                    }
                }
                ++n2;
            }
            Object[] res = new IResource[als.size()];
            als.toArray(res);
            Arrays.sort(res, this);
            return res;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IContainer) {
                IContainer folder = (IContainer)element;
                Object[] res = this.getChildren(folder);
                if (res.length == 0) {
                    return false;
                }
                Object[] objectArray = res;
                int n = res.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (ResourceSelector.this.accept((IResource)o)) {
                        return true;
                    }
                    if (this.hasChildren(o)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        @Override
        public int compare(IResource o1, IResource o2) {
            int i2;
            int i1 = o1 instanceof IFolder ? 0 : 1;
            int r = i1 - (i2 = o2 instanceof IFolder ? 0 : 1);
            if (r == 0) {
                r = o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
            return r;
        }
    }
}

