/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.wizard;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.meta.gef.editors.template.Template;
import aurora.ide.views.wizard.Messages;
import aurora.ide.views.wizard.OldTemplateWizardPage;
import aurora.ide.views.wizard.ScreenGenerator;
import aurora.ide.views.wizard.SelectBmWizardPage;
import aurora.ide.views.wizard.SelectTemplatelWizardPage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;

public class NewScreenWizard
extends Wizard
implements INewWizard {
    private SelectTemplatelWizardPage selectTplWizardPage = new SelectTemplatelWizardPage();
    private SelectBmWizardPage selectBmWizardPage = new SelectBmWizardPage();
    private OldTemplateWizardPage oldTemplatesWizardPage = new OldTemplateWizardPage();
    private UserInput us = new UserInput();
    private IWorkbench workbench;
    static final Color WRONG_COLOR = new Color(null, 243, 180, 212);

    public NewScreenWizard() {
        this.setWindowTitle(Messages.NewScreenWizard_0);
        this.selectTplWizardPage.setUserInput(this.us);
        this.selectBmWizardPage.setUserInput(this.us);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object obj;
        this.workbench = workbench;
        if (selection instanceof IStructuredSelection && (obj = selection.getFirstElement()) instanceof IResource) {
            IResource resource = (IResource)obj;
            IProject proj = resource.getProject();
            if (resource instanceof IProject && ResourceUtil.isAuroraProject((IProject)proj)) {
                String webHome = ResourceUtil.getWebHome((IProject)proj);
                if (webHome != null) {
                    this.us.setDir(webHome);
                }
            } else if (resource instanceof IFolder) {
                this.us.setDir(resource.getFullPath().toString());
            } else if (resource instanceof IFile) {
                this.us.setDir(resource.getParent().getFullPath().toString());
            }
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.selectTplWizardPage);
        this.addPage((IWizardPage)this.selectBmWizardPage);
        this.addPage((IWizardPage)this.oldTemplatesWizardPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectTplWizardPage) {
            return this.us.noUseModel ? this.oldTemplatesWizardPage : this.selectBmWizardPage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page != this.selectTplWizardPage) {
            return this.selectTplWizardPage;
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.selectTplWizardPage) {
            return false;
        }
        return page.isPageComplete();
    }

    public boolean performFinish() {
        Path path = new Path(this.us.dir);
        String fn = this.us.fileName;
        int idx = fn.indexOf(46);
        if (idx == -1) {
            fn = String.valueOf(fn) + "." + "screen";
        }
        path = path.append(fn);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (!this.us.noUseModel) {
            this.createViaMetaTemplate(f);
        } else {
            this.createViaEcpeTemplate(f);
        }
        try {
            IDE.openEditor((IWorkbenchPage)this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)f, (String)"aurora.ide.ServiceEditor");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return true;
    }

    void createViaMetaTemplate(IFile f) {
        ScreenGenerator generator = new ScreenGenerator();
        try {
            CompositeMap screenMap = generator.gen(this.us.template);
            String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + AuroraResourceUtil.getSign() + AuroraResourceUtil.LineSeparator + screenMap.toXML();
            this.writeToFile(f, content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void createViaEcpeTemplate(IFile f) {
        String content = this.oldTemplatesWizardPage.getTemplateContent();
        try {
            if (content == null || content.length() == 0) {
                QualifiedName screenQN = AuroraConstant.ScreenQN;
                CommentCompositeMap rootElement = new CommentCompositeMap("a", screenQN.getNameSpace(), screenQN.getLocalName());
                content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + AuroraResourceUtil.getSign() + AuroraResourceUtil.LineSeparator + rootElement.toXML();
            }
            this.writeToFile(f, content);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void writeToFile(IFile file, String content) throws CoreException, IOException, ExecutionException {
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes("UTF-8"));
        if (file.exists()) {
            file.setContents((InputStream)is, 1, (IProgressMonitor)new NullProgressMonitor());
            ((InputStream)is).close();
        } else {
            CreateFileOperation cfo = new CreateFileOperation(file, null, (InputStream)is, "Create " + file.getFullPath());
            cfo.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
    }

    public class UserInput {
        public boolean noUseModel = false;
        public Template template = null;
        public String dir = "";
        public String fileName = "";

        public boolean isNoUseModel() {
            return this.noUseModel;
        }

        public void setNoUseModel(boolean noUseModel) {
            this.noUseModel = noUseModel;
        }

        public Template getTemplate() {
            return this.template;
        }

        public void setTemplate(Template template) {
            this.template = template;
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }
    }
}

