/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring.descriptors;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.DescriptorMessages;
import org.eclipse.jdt.internal.core.refactoring.descriptors.JavaRefactoringDescriptorUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameResourceDescriptor
extends JavaRefactoringDescriptor {
    private String fName = null;
    private IPath fResourcePath = null;

    public RenameResourceDescriptor() {
        super("org.eclipse.jdt.ui.rename.resource");
    }

    public RenameResourceDescriptor(String project, String description, String comment, Map arguments, int flags) {
        super("org.eclipse.jdt.ui.rename.resource", project, description, comment, arguments, flags);
        this.fResourcePath = JavaRefactoringDescriptorUtil.getResourcePath(arguments, "input", project);
        this.fName = JavaRefactoringDescriptorUtil.getString(arguments, "name");
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        JavaRefactoringDescriptorUtil.setResourcePath(this.fArguments, "input", this.getProject(), this.fResourcePath);
        JavaRefactoringDescriptorUtil.setString(this.fArguments, "name", this.fName);
    }

    public void setNewName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = name;
    }

    public String getNewName() {
        return this.fName;
    }

    public void setProject(String project) {
        super.setProject(project);
    }

    public void setResource(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.fResourcePath = resource.getFullPath();
    }

    public IPath getResourcePath() {
        return this.fResourcePath;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.fResourcePath == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_resource));
        }
        if (this.fName == null || "".equals(this.fName)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_new_name));
        }
        if (this.fResourcePath.segmentCount() == 1 && this.getProject() != null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_project_constraint));
        }
        return status;
    }
}

