/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.OrderRelation;
import com.thaiopensource.datatype.xsd.RegexDatatype;
import java.util.Date;
import java.util.GregorianCalendar;
import org.relaxng.datatype.ValidationContext;

public class DateTimeDatatype
extends RegexDatatype
implements OrderRelation {
    private static final String YEAR_PATTERN = "-?([1-9][0-9]*)?[0-9]{4}";
    private static final String MONTH_PATTERN = "[0-9]{2}";
    private static final String DAY_OF_MONTH_PATTERN = "[0-9]{2}";
    private static final String TIME_PATTERN = "[0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]*)?";
    private static final String TZ_PATTERN = "(Z|[+\\-][0-9][0-9]:[0-5][0-9])?";
    private final String template;
    private static final int TIME_ZONE_MAX = 50400000;

    DateTimeDatatype(String string, String string2) {
        super(DateTimeDatatype.makePattern(string), string2);
        this.template = string;
    }

    private static String makePattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case 'Y': {
                    stringBuffer.append(YEAR_PATTERN);
                    break;
                }
                case 'M': {
                    stringBuffer.append("[0-9]{2}");
                    break;
                }
                case 'D': {
                    stringBuffer.append("[0-9]{2}");
                    break;
                }
                case 't': {
                    stringBuffer.append(TIME_PATTERN);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        stringBuffer.append(TZ_PATTERN);
        return stringBuffer.toString();
    }

    boolean allowsValue(String string, ValidationContext validationContext) {
        return this.getValue(string, validationContext) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    Object getValue(String string, ValidationContext validationContext) {
        int n;
        boolean bl = false;
        int n2 = 2000;
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = string.length();
        boolean bl2 = false;
        boolean bl3 = this.template.length();
        while (bl2 < bl3) {
            n = this.template.charAt(bl2 ? 1 : 0);
            switch (n) {
                case 89: {
                    bl = string.charAt(n9) == '-';
                    int n11 = bl ? n9 + 1 : n9;
                    n9 = DateTimeDatatype.skipDigits(string, n11);
                    try {
                        n2 = Integer.parseInt(string.substring(n11, n9));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                }
                case 77: {
                    n3 = DateTimeDatatype.parse2Digits(string, n9);
                    n9 += 2;
                    break;
                }
                case 68: {
                    n4 = DateTimeDatatype.parse2Digits(string, n9);
                    n9 += 2;
                    break;
                }
                case 116: {
                    n5 = DateTimeDatatype.parse2Digits(string, n9);
                    n6 = DateTimeDatatype.parse2Digits(string, n9 += 3);
                    n7 = DateTimeDatatype.parse2Digits(string, n9 += 3);
                    if ((n9 += 2) >= n10 || string.charAt(n9) != '.') break;
                    int n12 = DateTimeDatatype.skipDigits(string, ++n9);
                    int n13 = 0;
                    while (n13 < 3) {
                        n8 *= 10;
                        if (n9 < n12) {
                            n8 += string.charAt(n9++) - 48;
                        }
                        ++n13;
                    }
                    n9 = n12;
                    break;
                }
                default: {
                    ++n9;
                }
            }
            bl2 += 1;
        }
        boolean bl4 = bl2 = n9 < n10;
        if (bl2 && string.charAt(n9) != 'Z') {
            int n14 = DateTimeDatatype.parseTimeZone(string, n9);
        } else {
            boolean bl5 = false;
        }
        if (n7 == 60) {
            n = n8 + 1;
            n8 = 999;
            n7 = 59;
        } else {
            n = 0;
        }
        try {
            Date date;
            void var14_17;
            GregorianCalendar gregorianCalendar = CalendarFactory.getCalendar();
            if (gregorianCalendar == CalendarFactory.cal) {
                GregorianCalendar gregorianCalendar2 = gregorianCalendar;
                synchronized (gregorianCalendar2) {
                    date = DateTimeDatatype.createDate(gregorianCalendar, (int)var14_17, bl, n2, n3, n4, n5, n6, n7, n8);
                }
            } else {
                date = DateTimeDatatype.createDate(gregorianCalendar, (int)var14_17, bl, n2, n3, n4, n5, n6, n7, n8);
            }
            return new DateTime(date, n, bl2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static Date createDate(GregorianCalendar gregorianCalendar, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        gregorianCalendar.setLenient(false);
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        gregorianCalendar.clear();
        gregorianCalendar.set(15, n);
        gregorianCalendar.set(16, 0);
        gregorianCalendar.set(0, bl ? 0 : 1);
        gregorianCalendar.set(n2, --n3, n4, n5, n6, n7);
        gregorianCalendar.set(14, n8);
        DateTimeDatatype.checkDate(gregorianCalendar.isLeapYear(n2), n3, n4);
        return gregorianCalendar.getTime();
    }

    private static void checkDate(boolean bl, int n, int n2) {
        int n3;
        if (n < 0 || n > 11 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                n3 = 30;
                break;
            }
            case 1: {
                n3 = bl ? 29 : 28;
                break;
            }
            default: {
                n3 = 31;
            }
        }
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
    }

    private static int parseTimeZone(String string, int n) {
        int n2 = string.charAt(n) == '-' ? -1 : 1;
        return (Integer.parseInt(string.substring(n + 1, n + 3)) * 60 + Integer.parseInt(string.substring(n + 4))) * 60 * 1000 * n2;
    }

    private static int parse2Digits(String string, int n) {
        return (string.charAt(n) - 48) * 10 + (string.charAt(n + 1) - 48);
    }

    private static int skipDigits(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if ("0123456789".indexOf(string.charAt(n)) < 0) break;
            ++n;
        }
        return n;
    }

    OrderRelation getOrderRelation() {
        return this;
    }

    public boolean isLessThan(Object object, Object object2) {
        DateTime dateTime = (DateTime)object;
        DateTime dateTime2 = (DateTime)object2;
        long l = dateTime.getDate().getTime();
        long l2 = dateTime2.getDate().getTime();
        if (dateTime.getHasTimeZone() == dateTime2.getHasTimeZone()) {
            return DateTimeDatatype.isLessThan(l, dateTime.getLeapMilliseconds(), l2, dateTime2.getLeapMilliseconds());
        }
        if (!dateTime2.getHasTimeZone()) {
            return DateTimeDatatype.isLessThan(l, dateTime.getLeapMilliseconds(), l2 - 50400000L, dateTime2.getLeapMilliseconds());
        }
        return DateTimeDatatype.isLessThan(l + 50400000L, dateTime.getLeapMilliseconds(), l2, dateTime2.getLeapMilliseconds());
    }

    private static boolean isLessThan(long l, int n, long l2, int n2) {
        if (l < l2) {
            return true;
        }
        if (l > l2) {
            return false;
        }
        return n < n2;
    }

    private static class DateTime {
        private final Date date;
        private final int leapMilliseconds;
        private final boolean hasTimeZone;

        DateTime(Date date, int n, boolean bl) {
            this.date = date;
            this.leapMilliseconds = n;
            this.hasTimeZone = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DateTime)) {
                return false;
            }
            DateTime dateTime = (DateTime)object;
            return this.date.equals(dateTime.date) && this.leapMilliseconds == dateTime.leapMilliseconds && this.hasTimeZone == dateTime.hasTimeZone;
        }

        public int hashCode() {
            return this.date.hashCode();
        }

        Date getDate() {
            return this.date;
        }

        int getLeapMilliseconds() {
            return this.leapMilliseconds;
        }

        boolean getHasTimeZone() {
            return this.hasTimeZone;
        }
    }

    static class CalendarFactory {
        private static final int UNKNOWN = -1;
        private static final int SLOW = 0;
        private static final int FAST = 1;
        private static final int LIMIT = 10;
        private static int speed = -1;
        static GregorianCalendar cal = new GregorianCalendar();

        CalendarFactory() {
        }

        static GregorianCalendar getCalendar() {
            switch (speed) {
                case 0: {
                    return cal;
                }
                case 1: {
                    return new GregorianCalendar();
                }
            }
            long l = System.currentTimeMillis();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            long l2 = System.currentTimeMillis() - l;
            speed = l2 > 10L ? 0 : 1;
            return gregorianCalendar;
        }
    }
}

