/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.objfac.walker.DocumentContext;
import com.thaiopensource.relaxng.impl.AfterAttributePattern;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.DerivFunction;
import com.thaiopensource.relaxng.impl.DocumentContextWrapper;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternPool;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

public class DerivDataFunction
extends DerivFunction {
    private String str;
    private ValidationContext vc = null;

    public Pattern deriv(Pattern pattern, String string, PatternPool patternPool, DocumentContext documentContext) {
        this.str = string;
        this.pool = patternPool;
        this.vc = new DocumentContextWrapper(documentContext);
        return pattern.applyForPattern(this);
    }

    public Pattern deriv(Pattern pattern, String string, PatternPool patternPool, ValidationContext validationContext) {
        this.str = string;
        this.pool = patternPool;
        this.vc = validationContext;
        return pattern.applyForPattern(this);
    }

    static boolean isBlank(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public Object caseText(TextPattern textPattern) {
        return textPattern;
    }

    public Object caseList(ListPattern listPattern) {
        int n = this.str.length();
        int n2 = -1;
        Pattern pattern = this.pool.memo(listPattern.getOperand());
        int n3 = 0;
        while (n3 < n) {
            switch (this.str.charAt(n3)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n2 < 0) break;
                    pattern = this.tokenDeriv(pattern, n2, n3);
                    n2 = -1;
                    break;
                }
                default: {
                    if (n2 >= 0) break;
                    n2 = n3;
                }
            }
            ++n3;
        }
        if (n2 >= 0) {
            pattern = this.tokenDeriv(pattern, n2, n);
        }
        if (pattern.isNullable()) {
            return this.pool.makeEmpty();
        }
        return this.pool.makeNotAllowed();
    }

    private Pattern tokenDeriv(Pattern pattern, int n, int n2) {
        String string = this.str.substring(n, n2);
        return this.tokenDeriv(pattern, string);
    }

    private Pattern tokenDeriv(Pattern pattern, String string) {
        String string2 = this.str;
        this.str = string;
        Pattern pattern2 = pattern.applyForPattern(this);
        this.str = string2;
        return pattern2;
    }

    public Object caseValue(ValuePattern valuePattern) {
        Datatype datatype = valuePattern.getDatatype();
        Object object = datatype.createValue(this.str, this.vc);
        if (object != null && datatype.sameValue(valuePattern.getValue(), object)) {
            return this.pool.makeEmpty();
        }
        return this.pool.makeNotAllowed();
    }

    public Object caseData(DataPattern dataPattern) {
        if (dataPattern.allowsAnyString()) {
            return this.pool.makeEmpty();
        }
        if (dataPattern.getDatatype().isValid(this.str, this.vc)) {
            return this.pool.makeEmpty();
        }
        return this.pool.makeNotAllowed();
    }

    public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
        Pattern pattern = (Pattern)this.caseData(dataExceptPattern);
        if (pattern.isNullable() && this.memoApply(dataExceptPattern.getExcept()).isNullable()) {
            return this.pool.makeNotAllowed();
        }
        return pattern;
    }

    public Object caseAfter(AfterPattern afterPattern) {
        Pattern pattern = afterPattern.getOperand1();
        Pattern pattern2 = pattern.applyForPattern(this);
        if (pattern2.isNotAllowed()) {
            return this.pool.makeNotAllowed();
        }
        if (afterPattern instanceof AfterAttributePattern) {
            if (pattern2.isNullable() || pattern.isNullable() && DerivDataFunction.isBlank(this.str)) {
                return afterPattern.getOperand2();
            }
            return this.pool.makeNotAllowed();
        }
        return this.pool.makeAfter(pattern2, afterPattern.p2);
    }

    public Object caseChoice(ChoicePattern choicePattern) {
        return this.pool.makeChoice(this.memoApply(choicePattern.getOperand1()), this.memoApply(choicePattern.getOperand2()));
    }

    public Object caseGroup(GroupPattern groupPattern) {
        Pattern pattern = groupPattern.getOperand1();
        Pattern pattern2 = groupPattern.getOperand2();
        Pattern pattern3 = this.pool.makeGroup(this.memoApply(pattern), pattern2);
        if (!pattern.isNullable()) {
            return pattern3;
        }
        return this.pool.makeChoice(pattern3, this.memoApply(pattern2));
    }

    public Object caseInterleave(InterleavePattern interleavePattern) {
        Pattern pattern = interleavePattern.getOperand1();
        Pattern pattern2 = interleavePattern.getOperand2();
        return this.pool.makeChoice(this.pool.makeInterleave(this.memoApply(pattern), pattern2), this.pool.makeInterleave(pattern, this.memoApply(pattern2)));
    }

    public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        return this.pool.makeGroup(this.memoApply(oneOrMorePattern.getOperand()), this.pool.makeOptional(oneOrMorePattern));
    }

    public Object caseOther(Pattern pattern) {
        return this.pool.makeNotAllowed();
    }

    private Pattern memoApply(Pattern pattern) {
        return this.pool.memo(pattern).applyForPattern(this);
    }
}

