/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.BinaryPattern;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;

class InterleavePattern
extends BinaryPattern {
    InterleavePattern(Pattern pattern, Pattern pattern2) {
        super(pattern.isNullable() && pattern2.isNullable(), InterleavePattern.combineHashCode(17, pattern.hashCode(), pattern2.hashCode()), pattern, pattern2);
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p1.expand(schemaPatternBuilder);
        Pattern pattern2 = this.p2.expand(schemaPatternBuilder);
        if (pattern != this.p1 || pattern2 != this.p2) {
            return schemaPatternBuilder.makeInterleave(pattern, pattern2);
        }
        return this;
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_interleave");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_interleave");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_interleave");
            }
        }
        if (n == 2) {
            n = 4;
        }
        Alphabet alphabet2 = alphabet != null && alphabet.isEmpty() ? alphabet : new Alphabet();
        this.p1.checkRestrictions(n, duplicateAttributeDetector, alphabet2);
        if (alphabet2.isEmpty()) {
            this.p2.checkRestrictions(n, duplicateAttributeDetector, alphabet2);
        } else {
            Alphabet alphabet3 = new Alphabet();
            this.p2.checkRestrictions(n, duplicateAttributeDetector, alphabet3);
            alphabet2.checkOverlap(alphabet3);
            if (alphabet != null) {
                if (alphabet != alphabet2) {
                    alphabet.addAlphabet(alphabet2);
                }
                alphabet.addAlphabet(alphabet3);
            }
        }
        if (!InterleavePattern.contentTypeGroupable(this.p1.getContentType(), this.p2.getContentType())) {
            throw new RestrictionViolationException("interleave_string");
        }
        if (this.p1.getContentType() == 2 && this.p2.getContentType() == 2) {
            throw new RestrictionViolationException("interleave_text_overlap");
        }
    }

    void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitInterleave(this.p1, this.p2);
    }

    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseInterleave(this);
    }

    int binaryKind() {
        return 2;
    }
}

