/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.MPatternFunction;
import com.thaiopensource.relaxng.impl.MPatternVisitor;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import org.xml.sax.SAXException;

public class MStarPattern
extends Pattern {
    private final Pattern p;
    private final int m;

    public MStarPattern(Pattern pattern, int n) {
        super(pattern.isNullable(), pattern.getContentType(), MStarPattern.combineHashCode(47, pattern.hashCode()));
        this.p = pattern;
        this.m = n;
    }

    boolean samePattern(Pattern pattern) {
        if (!(pattern instanceof MStarPattern)) {
            return false;
        }
        MStarPattern mStarPattern = (MStarPattern)pattern;
        return this.p.samePattern(mStarPattern.p) && this.m == mStarPattern.m;
    }

    void accept(PatternVisitor patternVisitor) {
        if (patternVisitor instanceof MPatternVisitor) {
            ((MPatternVisitor)patternVisitor).visitMStar(this.p, this.m);
        }
    }

    Object apply(PatternFunction patternFunction) {
        if (patternFunction instanceof MPatternFunction) {
            return ((MPatternFunction)patternFunction).caseMStar(this);
        }
        return null;
    }

    Pattern getOperand() {
        return this.p;
    }

    int getM() {
        return this.m;
    }

    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_one_or_more");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_one_or_more");
            }
        }
        this.p.checkRestrictions(n == 1 ? 2 : n, duplicateAttributeDetector, alphabet);
        if (n != 6 && !MStarPattern.contentTypeGroupable(this.p.getContentType(), this.p.getContentType())) {
            throw new RestrictionViolationException("one_or_more_string");
        }
    }
}

