/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.objfac.xml.node.AttributeModel;
import com.objfac.xml.node.ElementModel;
import com.objfac.xml.node.Name;
import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.EmptyPattern;
import com.thaiopensource.relaxng.impl.ErrorPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.NotAllowedPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.relaxng.datatype.Datatype;

public class PatternCondenser {
    private Pattern pattern;
    private LinkedList elements;
    private LinkedList startElements;
    AttributeValueWalker attributeValueWalker = new AttributeValueWalker();

    public PatternCondenser(Pattern pattern) {
        this.elements = new LinkedList();
        this.startElements = new LinkedList();
        this.pattern = pattern;
        TreeWalker treeWalker = new TreeWalker();
        treeWalker.walk(pattern);
    }

    public List getStartElements() {
        return this.startElements;
    }

    public List getAllElements() {
        return this.elements;
    }

    public static class Element
    extends Name
    implements Comparable,
    ElementModel {
        public TreeSet attributes;
        public boolean hasText;
        public boolean hasElements;

        public TreeSet getAttributes() {
            return this.attributes;
        }

        public boolean canHaveElements() {
            return this.hasElements;
        }

        public boolean canHaveText() {
            return this.hasText;
        }
    }

    public static class Attribute
    extends Name
    implements Comparable,
    AttributeModel {
        public boolean isList;
        public String typeName;
    }

    private class TreeWalker
    implements PatternFunction {
        private boolean first;
        private HashMap elementMap;
        private ArrayList currentElements;
        private HashSet recursive;
        ElementNameClassVisitor elementNameClassVisitor = new ElementNameClassVisitor();
        AttributeNameClassVisitor attributeNameClassVisitor = new AttributeNameClassVisitor();

        TreeWalker() {
        }

        public void walk(Pattern pattern) {
            this.first = true;
            this.elementMap = new HashMap();
            this.currentElements = null;
            this.recursive = new HashSet();
            pattern.apply(this);
            this.elementMap = null;
            this.currentElements = null;
            this.recursive = null;
        }

        public Object caseEmpty(EmptyPattern emptyPattern) {
            return null;
        }

        public Object caseNotAllowed(NotAllowedPattern notAllowedPattern) {
            return null;
        }

        public Object caseError(ErrorPattern errorPattern) {
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            GroupPattern groupPattern2;
            Pattern pattern = groupPattern.p1;
            while (pattern instanceof GroupPattern) {
                groupPattern2 = (GroupPattern)pattern;
                pattern = groupPattern2.p1;
                groupPattern2.p2.apply(this);
            }
            pattern.apply(this);
            pattern = groupPattern.p2;
            while (pattern instanceof GroupPattern) {
                groupPattern2 = (GroupPattern)pattern;
                pattern = groupPattern2.p1;
                groupPattern2.p2.apply(this);
            }
            pattern.apply(this);
            return null;
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            InterleavePattern interleavePattern2;
            Pattern pattern = interleavePattern.p1;
            while (pattern instanceof InterleavePattern) {
                interleavePattern2 = (InterleavePattern)pattern;
                pattern = interleavePattern2.p1;
                interleavePattern2.p2.apply(this);
            }
            pattern.apply(this);
            pattern = interleavePattern.p2;
            while (pattern instanceof InterleavePattern) {
                interleavePattern2 = (InterleavePattern)pattern;
                pattern = interleavePattern2.p1;
                interleavePattern2.p2.apply(this);
            }
            pattern.apply(this);
            return null;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            ChoicePattern choicePattern2;
            Pattern pattern = choicePattern.p1;
            while (pattern instanceof ChoicePattern) {
                choicePattern2 = (ChoicePattern)pattern;
                pattern = choicePattern2.p1;
                choicePattern2.p2.apply(this);
            }
            pattern.apply(this);
            pattern = choicePattern.p2;
            while (pattern instanceof ChoicePattern) {
                choicePattern2 = (ChoicePattern)pattern;
                pattern = choicePattern2.p1;
                choicePattern2.p2.apply(this);
            }
            pattern.apply(this);
            return null;
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.getOperand().apply(this);
            return null;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object caseElement(ElementPattern elementPattern) {
            if (this.currentElements != null) {
                int n = 0;
                int n2 = this.currentElements.size();
                while (n < n2) {
                    ((Element)this.currentElements.get((int)n)).hasElements = true;
                    ++n;
                }
            }
            if (this.recursive.contains(elementPattern)) {
                return null;
            }
            NameClass nameClass = elementPattern.getNameClass();
            ArrayList arrayList = this.currentElements;
            this.currentElements = null;
            nameClass.accept(this.elementNameClassVisitor);
            boolean bl = this.first;
            this.first = false;
            this.recursive.add(elementPattern);
            try {
                elementPattern.getContent().apply(this);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.currentElements = arrayList;
                this.first = bl;
                throw throwable;
            }
            {
                Object var5_9 = null;
                this.currentElements = arrayList;
                this.first = bl;
                return null;
            }
        }

        private void addToCurrentElements(com.thaiopensource.xml.util.Name name) {
            Element element = new Element();
            element.namespace = name.getNamespaceUri();
            element.localname = name.getLocalName();
            Element element2 = (Element)this.elementMap.get(element);
            if (element2 == null) {
                this.elementMap.put(element, element);
                element2 = element;
                if (this.first) {
                    PatternCondenser.this.startElements.add(element2);
                }
                PatternCondenser.this.elements.add(element2);
            }
            if (this.currentElements == null) {
                this.currentElements = new ArrayList();
            }
            this.currentElements.add(element2);
        }

        private Attribute addAttribute(com.thaiopensource.xml.util.Name name) {
            if (this.currentElements != null) {
                Attribute attribute = new Attribute();
                attribute.namespace = name.getNamespaceUri();
                attribute.localname = name.getLocalName();
                int n = 0;
                int n2 = this.currentElements.size();
                while (n < n2) {
                    Element element = (Element)this.currentElements.get(n);
                    if (element.attributes == null) {
                        element.attributes = new TreeSet();
                    }
                    element.attributes.add(attribute);
                    ++n;
                }
                return attribute;
            }
            return null;
        }

        private void setHasText() {
            if (this.currentElements != null) {
                Iterator iterator = this.currentElements.iterator();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    element.hasText = true;
                }
            }
        }

        private void setHasElements() {
            if (this.currentElements != null) {
                Iterator iterator = this.currentElements.iterator();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    element.hasElements = true;
                }
            }
        }

        public Object caseAttribute(AttributePattern attributePattern) {
            if (this.currentElements != null) {
                List list = this.attributeNameClassVisitor.attributes;
                list.clear();
                attributePattern.getNameClass().accept(this.attributeNameClassVisitor);
                if (list.size() > 0) {
                    PatternCondenser.this.attributeValueWalker.walk(attributePattern.getContent());
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Attribute attribute = (Attribute)iterator.next();
                        this.setType(attribute, PatternCondenser.this.attributeValueWalker);
                    }
                }
            }
            return null;
        }

        private void setType(Attribute attribute, AttributeValueWalker attributeValueWalker) {
            if (attributeValueWalker.isListType) {
                attribute.isList = true;
            }
            if (attributeValueWalker.typeName != null && !attributeValueWalker.multipleTypes && !attributeValueWalker.complex) {
                attribute.typeName = attributeValueWalker.typeName;
            }
        }

        public Object caseData(DataPattern dataPattern) {
            this.setHasText();
            return null;
        }

        public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
            this.setHasText();
            return null;
        }

        public Object caseValue(ValuePattern valuePattern) {
            this.setHasText();
            return null;
        }

        public Object caseText(TextPattern textPattern) {
            this.setHasText();
            return null;
        }

        public Object caseList(ListPattern listPattern) {
            this.setHasText();
            return null;
        }

        public Object caseRef(RefPattern refPattern) {
            if (refPattern.getPattern() == null) {
                return null;
            }
            refPattern.getPattern().apply(this);
            return null;
        }

        public Object caseAfter(AfterPattern afterPattern) {
            afterPattern.getOperand1().apply(this);
            return null;
        }

        private class ElementNameClassVisitor
        implements NameClassVisitor {
            ElementNameClassVisitor() {
            }

            public void visitChoice(NameClass nameClass, NameClass nameClass2) {
                nameClass.accept(this);
                nameClass2.accept(this);
            }

            public void visitName(com.thaiopensource.xml.util.Name name) {
                TreeWalker.this.addToCurrentElements(name);
            }

            public void visitNsName(String string) {
            }

            public void visitNsNameExcept(String string, NameClass nameClass) {
            }

            public void visitAnyName() {
            }

            public void visitAnyNameExcept(NameClass nameClass) {
            }

            public void visitNull() {
            }

            public void visitError() {
            }
        }

        private class AttributeNameClassVisitor
        implements NameClassVisitor {
            public List attributes = new ArrayList();

            AttributeNameClassVisitor() {
            }

            public void visitChoice(NameClass nameClass, NameClass nameClass2) {
                nameClass.accept(this);
                nameClass2.accept(this);
            }

            public void visitName(com.thaiopensource.xml.util.Name name) {
                Attribute attribute = TreeWalker.this.addAttribute(name);
                if (attribute != null) {
                    this.attributes.add(attribute);
                }
            }

            public void visitNsName(String string) {
            }

            public void visitNsNameExcept(String string, NameClass nameClass) {
            }

            public void visitAnyName() {
            }

            public void visitAnyNameExcept(NameClass nameClass) {
            }

            public void visitNull() {
            }

            public void visitError() {
            }
        }
    }

    private class AttributeValueWalker
    implements PatternFunction {
        private boolean isTextType;
        private boolean isListType;
        private boolean isNotAllowed;
        private ArrayList enumeration;
        private boolean complex;
        private ArrayList sequence;
        private boolean inGroup;
        private boolean inChoice;
        private boolean inOneOrMore;
        private String typeName;
        private boolean multipleTypes;

        AttributeValueWalker() {
        }

        public void walk(Pattern pattern) {
            this.isTextType = false;
            this.isListType = false;
            this.isNotAllowed = false;
            this.enumeration = null;
            this.sequence = null;
            this.complex = false;
            this.inGroup = false;
            this.inChoice = false;
            this.inOneOrMore = false;
            this.typeName = null;
            pattern.apply(this);
        }

        public Object caseEmpty(EmptyPattern emptyPattern) {
            return null;
        }

        public Object caseNotAllowed(NotAllowedPattern notAllowedPattern) {
            this.isNotAllowed = true;
            return null;
        }

        public Object caseError(ErrorPattern errorPattern) {
            this.isNotAllowed = true;
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            boolean bl = this.inGroup;
            this.inGroup = true;
            groupPattern.p1.apply(this);
            groupPattern.p2.apply(this);
            this.inGroup = bl;
            return null;
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            this.complex = true;
            return null;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            if (this.inOneOrMore || this.inGroup) {
                this.complex = true;
            } else {
                boolean bl = this.inChoice;
                this.inChoice = true;
                choicePattern.p1.apply(this);
                choicePattern.p2.apply(this);
                this.inChoice = bl;
            }
            return null;
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            if (this.inOneOrMore || this.inGroup || this.inChoice) {
                this.complex = true;
            } else {
                this.inOneOrMore = true;
                oneOrMorePattern.getOperand().apply(this);
                this.inOneOrMore = false;
            }
            return null;
        }

        public Object caseElement(ElementPattern elementPattern) {
            return null;
        }

        public Object caseAttribute(AttributePattern attributePattern) {
            return null;
        }

        public Object caseData(DataPattern dataPattern) {
            if (dataPattern.allowsAnyString()) {
                this.isTextType = true;
            } else {
                Datatype datatype = dataPattern.getDatatype();
                if (datatype.getIdType() != 0) {
                    this.isTextType = true;
                } else if (datatype instanceof Datatype2) {
                    if (this.typeName != null) {
                        this.multipleTypes = true;
                    }
                    Datatype2 datatype2 = (Datatype2)datatype;
                    this.typeName = datatype2.getTypeName();
                } else {
                    this.isTextType = true;
                }
            }
            return null;
        }

        public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
            this.isTextType = true;
            return null;
        }

        public Object caseValue(ValuePattern valuePattern) {
            if (this.inGroup || this.inOneOrMore) {
                this.complex = true;
            } else {
                if (this.enumeration == null) {
                    this.enumeration = new ArrayList();
                }
                this.enumeration.add(valuePattern.getValue());
                this.isTextType = true;
            }
            return null;
        }

        public Object caseText(TextPattern textPattern) {
            this.isTextType = true;
            return null;
        }

        public Object caseList(ListPattern listPattern) {
            if (this.inGroup || this.inOneOrMore || this.inChoice || this.isListType) {
                this.complex = true;
            } else {
                this.isListType = true;
                listPattern.getOperand().apply(this);
            }
            return null;
        }

        public Object caseRef(RefPattern refPattern) {
            refPattern.apply(this);
            return null;
        }

        public Object caseAfter(AfterPattern afterPattern) {
            return null;
        }
    }
}

