/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.datatype.xsd.DatatypeLibraryImpl;
import com.thaiopensource.relaxng.impl.AfterAttributePattern;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.AnyNameClass;
import com.thaiopensource.relaxng.impl.AnyNameExceptNameClass;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.BuiltinDatatypeLibrary;
import com.thaiopensource.relaxng.impl.ChoiceNameClass;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.DatatypeWrapper;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.EmptyPattern;
import com.thaiopensource.relaxng.impl.ErrorPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.MNPattern;
import com.thaiopensource.relaxng.impl.MPatternVisitor;
import com.thaiopensource.relaxng.impl.MStarPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NotAllowedPattern;
import com.thaiopensource.relaxng.impl.NsNameClass;
import com.thaiopensource.relaxng.impl.NsNameExceptNameClass;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.OtherNameClass;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternInterner;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.UnexpandedNotAllowedPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import com.thaiopensource.relaxng.parse.Location;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.Locator;

public class PatternPool {
    private static DatatypeLibraryImpl schemaDatatypeLibrary;
    private static BuiltinDatatypeLibrary builtinDatatypeLibrary;
    private static DummyValidationContext dummyValidationContext;
    private PoolLocator loc = new PoolLocator();
    private final EmptyPattern empty;
    protected final NotAllowedPattern notAllowed;
    protected final PatternInterner interner;
    private boolean idTypes;
    private final UnexpandedNotAllowedPattern unexpandedNotAllowed = new UnexpandedNotAllowedPattern();
    private final TextPattern text = new TextPattern();
    private HashMap idmap = new HashMap();
    private int uniqueId = 0;
    private Datatype tokenDatatype;
    private Datatype stringDatatype;

    static {
        dummyValidationContext = new DummyValidationContext();
    }

    public PatternPool() {
        try {
            this.tokenDatatype = new DatatypeMakerImpl("", "token").createDatatype();
            this.stringDatatype = new DatatypeMakerImpl("", "string").createDatatype();
        }
        catch (DatatypeException datatypeException) {}
        this.empty = new EmptyPattern();
        this.notAllowed = new NotAllowedPattern();
        this.interner = new PatternInterner();
    }

    public void setLocatorIds(String string, String string2) {
        this.loc.pubid = string;
        this.loc.sysid = string2;
    }

    public void setLocatorLoc(int n, int n2) {
        this.loc.lineno = n;
        this.loc.colmno = n2;
    }

    public NameClass makeName(String string, String string2) {
        return new SimpleNameClass(new Name(string, string2));
    }

    public NameClass makeNsName(String string, Location location) {
        return new NsNameClass(string);
    }

    public NameClass makeNsName(String string) {
        return new NsNameClass(string);
    }

    public NameClass makeOtherName(String string) {
        return new OtherNameClass(string);
    }

    public NameClass makeNsName(String string, NameClass nameClass) {
        return new NsNameExceptNameClass(string, nameClass);
    }

    public NameClass makeAnyName() {
        return new AnyNameClass();
    }

    public NameClass makeAnyName(NameClass nameClass) {
        return new AnyNameExceptNameClass(nameClass);
    }

    public NameClass makeChoiceNameClass(NameClass nameClass, NameClass nameClass2) {
        return new ChoiceNameClass(nameClass, nameClass2);
    }

    public Pattern makeElement(String string, String string2, Pattern pattern) {
        ElementPattern elementPattern = new ElementPattern(this.makeName(string, string2), pattern, this.loc.copy());
        return this.interner.intern(elementPattern);
    }

    public Pattern makeElement(NameClass nameClass, Pattern pattern) {
        ElementPattern elementPattern = new ElementPattern(nameClass, pattern, this.loc.copy());
        return this.interner.intern(elementPattern);
    }

    public RefPattern makeRef(String string) {
        return new RefPattern(string);
    }

    public PrettyRefPattern makePrettyRef(String string) {
        return new PrettyRefPattern(string);
    }

    public Pattern makeAttribute(String string, String string2, Pattern pattern) {
        if (pattern.isNotAllowed()) {
            return pattern;
        }
        AttributePattern attributePattern = new AttributePattern(this.makeName(string, string2), pattern, this.loc.copy());
        return this.interner.intern(attributePattern);
    }

    public Pattern makeAttribute(NameClass nameClass, Pattern pattern) {
        if (pattern.isNotAllowed()) {
            return pattern;
        }
        AttributePattern attributePattern = new AttributePattern(nameClass, pattern, this.loc.copy());
        return this.interner.intern(attributePattern);
    }

    public Pattern makeEmpty() {
        return this.empty;
    }

    public Pattern makeNotAllowed() {
        return this.notAllowed;
    }

    public Pattern makeGroup(Pattern pattern, Pattern pattern2) {
        if (pattern == this.empty) {
            return pattern2;
        }
        if (pattern2 == this.empty) {
            return pattern;
        }
        if (pattern.isNotAllowed() || pattern2.isNotAllowed()) {
            return this.notAllowed;
        }
        GroupPattern groupPattern = new GroupPattern(pattern, pattern2);
        return this.interner.intern(groupPattern);
    }

    public Pattern makeData(Datatype datatype) {
        this.noteDatatype(datatype);
        DataPattern dataPattern = new DataPattern(datatype);
        return this.interner.intern(dataPattern);
    }

    public Pattern makeDataExcept(Datatype datatype, Pattern pattern, Locator locator) {
        this.noteDatatype(datatype);
        DataExceptPattern dataExceptPattern = new DataExceptPattern(datatype, pattern, locator);
        return this.interner.intern(dataExceptPattern);
    }

    public Pattern makeValue(Datatype datatype, Object object) {
        this.noteDatatype(datatype);
        Object object2 = object;
        if (object instanceof String) {
            object2 = datatype.createValue((String)object, dummyValidationContext);
        }
        ValuePattern valuePattern = new ValuePattern(datatype, object2);
        return this.interner.intern(valuePattern);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pattern makeQNameValue(Datatype datatype, String string, String string2) {
        this.noteDatatype(datatype);
        int n = string.indexOf(58);
        dummyValidationContext.pushPrefix(n < 0 ? "" : string.substring(0, n), string2);
        Object object = string;
        try {
            object = datatype.createValue(string, dummyValidationContext);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            dummyValidationContext.popPrefix();
            throw throwable;
        }
        {
            ValuePattern valuePattern = null;
            dummyValidationContext.popPrefix();
            valuePattern = new ValuePattern(datatype, object);
            return this.interner.intern(valuePattern);
        }
    }

    public DatatypeMaker makeDatatypeMaker(String string, String string2) throws DatatypeException {
        return new DatatypeMakerImpl(string, string2);
    }

    public Pattern makeText() {
        return this.text;
    }

    public Pattern makeOneOrMore(Pattern pattern) {
        if (pattern == this.text || pattern == this.empty || pattern.isNotAllowed() || pattern instanceof OneOrMorePattern || this.isZeroOrMore(pattern)) {
            return pattern;
        }
        OneOrMorePattern oneOrMorePattern = new OneOrMorePattern(pattern);
        return this.interner.intern(oneOrMorePattern);
    }

    public Pattern makeZeroOrMore(Pattern pattern) {
        if (pattern == this.text || pattern == this.empty || pattern.isNotAllowed() || this.isZeroOrMore(pattern)) {
            return pattern;
        }
        if (pattern instanceof OneOrMorePattern) {
            return this.makeChoice(pattern, this.makeEmpty());
        }
        return this.makeChoice(this.makeOneOrMore(pattern), this.makeEmpty());
    }

    private boolean isZeroOrMore(Pattern pattern) {
        return pattern instanceof ChoicePattern && ((ChoicePattern)pattern).p1 instanceof OneOrMorePattern && ((ChoicePattern)pattern).p2 instanceof EmptyPattern;
    }

    private boolean isOneOrMore(Pattern pattern) {
        return pattern instanceof OneOrMorePattern;
    }

    public Pattern makeUnexpandedNotAllowed() {
        return this.unexpandedNotAllowed;
    }

    public Pattern makeError() {
        ErrorPattern errorPattern = new ErrorPattern();
        return this.interner.intern(errorPattern);
    }

    public Pattern makeChoice(Pattern pattern, Pattern pattern2) {
        if (pattern.isNotAllowed() || pattern == pattern2) {
            return pattern2;
        }
        if (pattern2.isNotAllowed()) {
            return pattern;
        }
        if (pattern == this.empty && pattern2.isNullable()) {
            return pattern2;
        }
        if (pattern2 == this.empty && pattern.isNullable()) {
            return pattern;
        }
        ChoicePattern choicePattern = new ChoicePattern(pattern, pattern2);
        return this.interner.intern(choicePattern);
    }

    public Pattern makeList(Pattern pattern) {
        if (pattern.isNotAllowed()) {
            return pattern;
        }
        ListPattern listPattern = new ListPattern(pattern, null);
        return this.interner.intern(listPattern);
    }

    public Pattern makeMixed(Pattern pattern) {
        return this.makeInterleave(this.text, pattern);
    }

    public Pattern makeAfter(Pattern pattern, Pattern pattern2) {
        if (pattern.isNotAllowed()) {
            return this.makeNotAllowed();
        }
        if (pattern2.isNotAllowed()) {
            return pattern;
        }
        return this.interner.intern(new AfterPattern(pattern, pattern2));
    }

    public Pattern makeAfterAttribute(Pattern pattern, Pattern pattern2) {
        if (pattern.isNotAllowed()) {
            return this.makeNotAllowed();
        }
        if (pattern2.isNotAllowed()) {
            return pattern;
        }
        return this.interner.intern(new AfterAttributePattern(pattern, pattern2));
    }

    public Pattern makeInterleave(Pattern pattern, Pattern pattern2) {
        if (pattern == this.empty) {
            return pattern2;
        }
        if (pattern2 == this.empty) {
            return pattern;
        }
        if (pattern.isNotAllowed() || pattern2.isNotAllowed()) {
            return this.notAllowed;
        }
        InterleavePattern interleavePattern = new InterleavePattern(pattern, pattern2);
        return this.interner.intern(interleavePattern);
    }

    public Pattern makeOptional(Pattern pattern) {
        return this.makeChoice(pattern, this.empty);
    }

    public Pattern memo(Pattern pattern) {
        return this.interner.intern(pattern);
    }

    public Datatype makeTokenDatatype() {
        return this.tokenDatatype;
    }

    public Datatype makeStringDatatype() {
        return this.stringDatatype;
    }

    private int getId(Pattern pattern) {
        Integer n = (Integer)this.idmap.get(pattern);
        if (n == null) {
            n = new Integer(this.uniqueId++);
            this.idmap.put(pattern, n);
        }
        return n;
    }

    private void noteDatatype(Datatype datatype) {
        if (datatype.getIdType() != 0) {
            this.idTypes = true;
        }
    }

    public Pattern makeMN(Pattern pattern, int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n == 0 && n2 == 0) {
            return this.makeEmpty();
        }
        MNPattern mNPattern = new MNPattern(pattern, n, n2);
        return this.interner.intern(mNPattern);
    }

    public Pattern makeMStar(Pattern pattern, int n) {
        if (n == 0) {
            return this.makeOptional(this.makeOneOrMore(pattern));
        }
        MStarPattern mStarPattern = new MStarPattern(pattern, n);
        return this.interner.intern(mStarPattern);
    }

    private static class DummyValidationContext
    implements ValidationContext {
        ArrayList nsmap = new ArrayList(2);

        public DummyValidationContext() {
            this.nsmap.add("xml");
            this.nsmap.add("http://www.w3.org/XML/1998/namespace");
        }

        public String resolveNamespacePrefix(String string) {
            int n = 0;
            int n2 = this.nsmap.size();
            while (n < n2) {
                if (string.equals(this.nsmap.get(n))) {
                    return (String)this.nsmap.get(n + 1);
                }
                n += 2;
            }
            return null;
        }

        public void pushPrefix(String string, String string2) {
            this.nsmap.add(string);
            this.nsmap.add(string2);
        }

        public void popPrefix() {
            if (this.nsmap.size() > 2) {
                this.nsmap.remove(this.nsmap.size() - 1);
                this.nsmap.remove(this.nsmap.size() - 1);
            }
        }

        public String getBaseUri() {
            return null;
        }

        public boolean isUnparsedEntity(String string) {
            return false;
        }

        public boolean isNotation(String string) {
            return false;
        }
    }

    public static interface DatatypeMaker
    extends DatatypeBuilder {
        public void addParameter(String var1, String var2) throws DatatypeException;

        public boolean haveParameters();

        public Datatype createDatatype() throws DatatypeException;
    }

    private class DatatypeMakerImpl
    implements DatatypeMaker {
        private DatatypeWrapper wrapper;
        private DatatypeBuilder builder;
        private boolean haveParameters = false;
        static /* synthetic */ Class class$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public DatatypeMakerImpl(String string, String string2) throws DatatypeException {
            if (SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(string) || "http://www.w3.org/2001/XMLSchema-datatypes".equals(string) || "http://relaxng.org/ns/compatibility/datatypes/1.0".equals(string)) {
                if (schemaDatatypeLibrary == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.thaiopensource.relaxng.impl.PatternPool");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class<?> clazz2 = clazz;
                    // MONITORENTER : clazz
                    if (schemaDatatypeLibrary == null) {
                        schemaDatatypeLibrary = new DatatypeLibraryImpl();
                    }
                    // MONITOREXIT : clazz2
                }
                if ("anySimpleType".equals(string2)) {
                    string2 = "string";
                }
                this.builder = schemaDatatypeLibrary.createDatatypeBuilder(string2);
            } else {
                if (!"".equals(string)) throw new DatatypeException();
                if (builtinDatatypeLibrary == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.thaiopensource.relaxng.impl.PatternPool");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class<?> clazz3 = clazz;
                    // MONITORENTER : clazz
                    if (builtinDatatypeLibrary == null) {
                        PatternPool.builtinDatatypeLibrary = new BuiltinDatatypeLibrary();
                    }
                    // MONITOREXIT : clazz3
                }
                this.builder = builtinDatatypeLibrary.createDatatypeBuilder(string2);
            }
            this.wrapper = new DatatypeWrapper(string, string2);
        }

        public void addParameter(String string, String string2) throws DatatypeException {
            this.builder.addParameter(string, string2, dummyValidationContext);
            this.wrapper.addParam(string, string2);
            this.haveParameters = true;
        }

        public Datatype createDatatype() throws DatatypeException {
            return this.wrapper.setDatatype(this.builder.createDatatype());
        }

        public void addParameter(String string, String string2, ValidationContext validationContext) throws DatatypeException {
            this.builder.addParameter(string, string2, validationContext);
            this.wrapper.addParam(string, string2);
        }

        public boolean haveParameters() {
            return this.haveParameters;
        }
    }

    public static class PrettyRefPattern
    extends RefPattern {
        public int level;
        public int uses = 1;
        public boolean recursive = false;

        public PrettyRefPattern(String string) {
            super(string);
        }

        void accept(PatternVisitor patternVisitor) {
            if (patternVisitor instanceof RefPatternVisitor) {
                ((RefPatternVisitor)patternVisitor).visitRef(this);
            } else {
                super.accept(patternVisitor);
            }
        }
    }

    public static interface RefPatternVisitor
    extends MPatternVisitor {
        public void visitRef(RefPattern var1);
    }

    private class PoolLocator
    implements Locator {
        public int colmno;
        public int lineno;
        public String sysid;
        public String pubid;

        PoolLocator() {
        }

        public Locator copy() {
            PoolLocator poolLocator = new PoolLocator();
            poolLocator.colmno = this.colmno;
            poolLocator.lineno = this.lineno;
            poolLocator.sysid = this.sysid;
            poolLocator.pubid = this.pubid;
            return poolLocator;
        }

        public String getPublicId() {
            return this.pubid;
        }

        public String getSystemId() {
            return this.sysid;
        }

        public int getLineNumber() {
            return this.lineno;
        }

        public int getColumnNumber() {
            return this.colmno;
        }
    }
}

