/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate;

import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ValidationDriver {
    private static final PropertyId[] requiredProperties = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER};
    private static final Class[] defaultClasses;
    private final XMLReaderCreator xrc;
    private XMLReader xr;
    private final CountingErrorHandler eh;
    private final SchemaReader sr;
    private final PropertyMap schemaProperties;
    private final PropertyMap instanceProperties;
    private Validator validator;
    private Schema schema;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.thaiopensource.xml.sax.ErrorHandlerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        defaultClasses = classArray;
    }

    public ValidationDriver(PropertyMap propertyMap, PropertyMap propertyMap2, SchemaReader schemaReader) {
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(propertyMap);
        int n = 0;
        while (n < requiredProperties.length) {
            if (!propertyMapBuilder.contains(requiredProperties[n])) {
                try {
                    propertyMapBuilder.put(requiredProperties[n], defaultClasses[n].newInstance());
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n;
        }
        this.schemaProperties = propertyMapBuilder.toPropertyMap();
        propertyMapBuilder = new PropertyMapBuilder(propertyMap2);
        n = 0;
        while (n < requiredProperties.length) {
            if (!propertyMapBuilder.contains(requiredProperties[n])) {
                propertyMapBuilder.put(requiredProperties[n], this.schemaProperties.get(requiredProperties[n]));
            }
            ++n;
        }
        this.eh = new CountingErrorHandler((ErrorHandler)propertyMapBuilder.get(ValidateProperty.ERROR_HANDLER));
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, this.eh);
        this.instanceProperties = propertyMapBuilder.toPropertyMap();
        this.xrc = ValidateProperty.XML_READER_CREATOR.get(this.instanceProperties);
        this.sr = schemaReader == null ? new AutoSchemaReader() : schemaReader;
    }

    public ValidationDriver(PropertyMap propertyMap, PropertyMap propertyMap2) {
        this(propertyMap, propertyMap2, null);
    }

    public ValidationDriver(PropertyMap propertyMap, SchemaReader schemaReader) {
        this(propertyMap, propertyMap, schemaReader);
    }

    public ValidationDriver(PropertyMap propertyMap) {
        this(propertyMap, propertyMap, null);
    }

    public ValidationDriver(SchemaReader schemaReader) {
        this(PropertyMap.EMPTY, schemaReader);
    }

    public ValidationDriver() {
        this(PropertyMap.EMPTY, PropertyMap.EMPTY, null);
    }

    public void setSchemaFragment(boolean bl) {
        SchemaBuilderImpl.schemaFragment = bl;
    }

    public boolean loadSchema(InputSource inputSource) throws SAXException, IOException {
        try {
            this.schema = this.sr.createSchema(inputSource, this.schemaProperties);
            this.validator = null;
            return true;
        }
        catch (IncorrectSchemaException incorrectSchemaException) {
            return false;
        }
    }

    public boolean validate(InputSource inputSource) throws SAXException, IOException {
        if (this.schema == null) {
            throw new IllegalStateException("cannot validate without schema");
        }
        if (this.validator == null) {
            this.validator = this.schema.createValidator(this.instanceProperties);
        }
        if (this.xr == null) {
            this.xr = this.xrc.createXMLReader();
            this.xr.setErrorHandler(this.eh);
        }
        this.eh.reset();
        this.xr.setContentHandler(this.validator.getContentHandler());
        DTDHandler dTDHandler = this.validator.getDTDHandler();
        if (dTDHandler != null) {
            this.xr.setDTDHandler(dTDHandler);
        }
        try {
            this.xr.parse(inputSource);
            boolean bl = !this.eh.getHadErrorOrFatalError();
            Object var3_4 = null;
            this.validator.reset();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.validator.reset();
            throw throwable;
        }
    }

    public static InputSource fileInputSource(String string) throws MalformedURLException {
        return ValidationDriver.fileInputSource(new File(string));
    }

    public static InputSource fileInputSource(File file) throws MalformedURLException {
        return new InputSource(UriOrFile.fileToUri(file));
    }

    public static InputSource uriOrFileInputSource(String string) throws MalformedURLException {
        return new InputSource(UriOrFile.toUri(string));
    }
}

