/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DOMStringListImpl;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.DOMStringList;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.XSModelImpl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.DefaultErrorHandler;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;

public class XMLSchemaLoader
implements XMLGrammarLoader,
XMLComponent,
XSLoader,
DOMConfiguration {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String STANDARD_URI_CONFORMANT_FEATURE = "http://apache.org/xml/features/standard-uri-conformant";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/continue-after-fatal-error", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/standard-uri-conformant"};
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource"};
    private boolean fIsCheckedFully = false;
    private boolean fAllowJavaEncodings = false;
    private boolean fStrictURI = false;
    private SymbolTable fSymbolTable = null;
    private XMLErrorReporter fErrorReporter = new XMLErrorReporter();
    private XMLEntityResolver fEntityResolver = null;
    private XMLGrammarPool fGrammarPool = null;
    private String fExternalSchemas = null;
    private String fExternalNoNSSchema = null;
    private Object fJAXPSource = null;
    private Hashtable fJAXPCache;
    private Locale fLocale = Locale.getDefault();
    private XSDHandler fSchemaHandler;
    private XSGrammarBucket fGrammarBucket;
    private XSDeclarationPool fDeclPool = null;
    private SubstitutionGroupHandler fSubGroupHandler;
    private CMBuilder fCMBuilder;
    private boolean fJAXPProcessed = false;
    private DOMStringList fRecognizedParameters = null;
    private DOMErrorHandlerWrapper fErrorHandler = null;
    private XSDDescription fXSDDescription = new XSDDescription();
    private boolean fUseDeclPool = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public XMLSchemaLoader() {
        this(new SymbolTable(), null, new XMLEntityManager(), null, null, null);
    }

    public XMLSchemaLoader(SymbolTable symbolTable) {
        this(symbolTable, null, new XMLEntityManager(), null, null, null);
    }

    XMLSchemaLoader(XMLErrorReporter xMLErrorReporter, XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder) {
        this(null, xMLErrorReporter, null, xSGrammarBucket, substitutionGroupHandler, cMBuilder);
    }

    XMLSchemaLoader(SymbolTable symbolTable, XMLErrorReporter xMLErrorReporter, XMLEntityResolver xMLEntityResolver, XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder) {
        this.fSymbolTable = symbolTable;
        if (xMLErrorReporter == null) {
            xMLErrorReporter = new XMLErrorReporter();
            xMLErrorReporter.setProperty(ERROR_HANDLER, new DefaultErrorHandler());
        }
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityResolver = xMLEntityResolver;
        if (xSGrammarBucket == null) {
            xSGrammarBucket = new XSGrammarBucket();
        }
        this.fGrammarBucket = xSGrammarBucket;
        if (substitutionGroupHandler == null) {
            substitutionGroupHandler = new SubstitutionGroupHandler(this.fGrammarBucket);
        }
        this.fSubGroupHandler = substitutionGroupHandler;
        CMNodeFactory cMNodeFactory = new CMNodeFactory();
        if (cMBuilder == null) {
            cMBuilder = new CMBuilder(cMNodeFactory);
        }
        this.fCMBuilder = cMBuilder;
        this.fSchemaHandler = new XSDHandler(this.fGrammarBucket);
        this.fDeclPool = new XSDeclarationPool();
        this.fJAXPCache = new Hashtable();
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public boolean getFeature(String string) throws XMLConfigurationException {
        if (string.equals(SCHEMA_FULL_CHECKING)) {
            return this.fIsCheckedFully;
        }
        if (string.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            return this.fErrorReporter.getFeature(CONTINUE_AFTER_FATAL_ERROR);
        }
        throw new XMLConfigurationException(0, string);
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if (string.equals(SCHEMA_FULL_CHECKING)) {
            this.fIsCheckedFully = bl;
        } else if (string.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, bl);
        } else if (string.equals(ALLOW_JAVA_ENCODINGS)) {
            this.fAllowJavaEncodings = bl;
        } else if (string.equals(STANDARD_URI_CONFORMANT_FEATURE)) {
            this.fStrictURI = bl;
        } else {
            throw new XMLConfigurationException(0, string);
        }
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public Object getProperty(String string) throws XMLConfigurationException {
        if (string.equals(SYMBOL_TABLE)) {
            return this.fSymbolTable;
        }
        if (string.equals(ERROR_REPORTER)) {
            return this.fErrorReporter;
        }
        if (string.equals(ERROR_HANDLER)) {
            return this.fErrorReporter.getErrorHandler();
        }
        if (string.equals(ENTITY_RESOLVER)) {
            return this.fEntityResolver;
        }
        if (string.equals(XMLGRAMMAR_POOL)) {
            return this.fGrammarPool;
        }
        if (string.equals(SCHEMA_LOCATION)) {
            return this.fExternalSchemas;
        }
        if (string.equals(SCHEMA_NONS_LOCATION)) {
            return this.fExternalNoNSSchema;
        }
        if (string.equals(JAXP_SCHEMA_SOURCE)) {
            return this.fJAXPSource;
        }
        throw new XMLConfigurationException(0, string);
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.equals(SYMBOL_TABLE)) {
            this.fSymbolTable = (SymbolTable)object;
        } else if (string.equals(ERROR_REPORTER)) {
            this.fErrorReporter = (XMLErrorReporter)object;
        } else if (string.equals(ERROR_HANDLER)) {
            this.fErrorReporter.setProperty(string, object);
        } else if (string.equals(ENTITY_RESOLVER)) {
            this.fEntityResolver = (XMLEntityResolver)object;
        } else if (string.equals(XMLGRAMMAR_POOL)) {
            this.fGrammarPool = (XMLGrammarPool)object;
        } else if (string.equals(SCHEMA_LOCATION)) {
            this.fExternalSchemas = (String)object;
        } else if (string.equals(SCHEMA_NONS_LOCATION)) {
            this.fExternalNoNSSchema = (String)object;
        } else if (string.equals(JAXP_SCHEMA_SOURCE)) {
            this.fJAXPSource = object;
            this.fJAXPProcessed = false;
        } else {
            throw new XMLConfigurationException(0, string);
        }
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, xMLErrorHandler);
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fEntityResolver = xMLEntityResolver;
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public void reset() {
        this.fGrammarBucket.reset();
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
        }
        if (this.fGrammarPool != null) {
            Grammar[] grammarArray = this.fGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
            int n = 0;
            while (n < grammarArray.length) {
                if (!this.fGrammarBucket.putGrammar((SchemaGrammar)grammarArray[n], true)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
                }
                ++n;
            }
        }
        if (this.fUseDeclPool) {
            this.fDeclPool.reset();
            this.fCMBuilder.setDeclPool(this.fDeclPool);
            this.fSchemaHandler.setDeclPool(this.fDeclPool);
        } else {
            this.fCMBuilder.setDeclPool(null);
            this.fSchemaHandler.setDeclPool(null);
        }
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityResolver, this.fSymbolTable, this.fGrammarPool, this.fAllowJavaEncodings, this.fStrictURI);
        this.fSubGroupHandler.reset();
        this.fJAXPProcessed = false;
    }

    public Grammar loadGrammar(XMLInputSource xMLInputSource) throws IOException, XNIException {
        this.reset();
        XSDDescription xSDDescription = new XSDDescription();
        xSDDescription.fContextType = (short)3;
        xSDDescription.setBaseSystemId(xMLInputSource.getBaseSystemId());
        xSDDescription.setLiteralSystemId(xMLInputSource.getSystemId());
        Hashtable hashtable = new Hashtable();
        XMLSchemaLoader.processExternalHints(this.fExternalSchemas, this.fExternalNoNSSchema, hashtable, this.fErrorReporter);
        SchemaGrammar schemaGrammar = this.loadSchema(xSDDescription, xMLInputSource, hashtable);
        if (schemaGrammar != null && this.fGrammarPool != null) {
            this.fGrammarPool.cacheGrammars("http://www.w3.org/2001/XMLSchema", this.fGrammarBucket.getGrammars());
        }
        return schemaGrammar;
    }

    SchemaGrammar loadSchema(XSDDescription xSDDescription, XMLInputSource xMLInputSource, Hashtable hashtable) throws IOException, XNIException {
        if (!this.fJAXPProcessed) {
            this.processJAXPSchemaSource(hashtable);
        }
        SchemaGrammar schemaGrammar = this.fSchemaHandler.parseSchema(xMLInputSource, xSDDescription, hashtable);
        if (this.fIsCheckedFully) {
            XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
        }
        return schemaGrammar;
    }

    public static XMLInputSource resolveDocument(XSDDescription xSDDescription, Hashtable hashtable, XMLEntityResolver xMLEntityResolver) throws IOException {
        Object object;
        String string;
        LocationArray locationArray;
        String string2 = null;
        if ((xSDDescription.getContextType() == 2 || xSDDescription.fromInstance()) && (locationArray = (LocationArray)hashtable.get(string = (object = xSDDescription.getTargetNamespace()) == null ? XMLSymbols.EMPTY_STRING : object)) != null) {
            string2 = locationArray.getFirstLocation();
        }
        if (string2 == null && (object = xSDDescription.getLocationHints()) != null && ((String[])object).length > 0) {
            string2 = object[0];
        }
        object = XMLEntityManager.expandSystemId(string2, xSDDescription.getBaseSystemId(), false);
        xSDDescription.setLiteralSystemId(string2);
        xSDDescription.setExpandedSystemId((String)object);
        return xMLEntityResolver.resolveEntity(xSDDescription);
    }

    public static void processExternalHints(String string, String string2, Hashtable hashtable, XMLErrorReporter xMLErrorReporter) {
        XSAttributeDecl xSAttributeDecl;
        if (string != null) {
            try {
                xSAttributeDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_SCHEMALOCATION);
                xSAttributeDecl.fType.validate(string, null, null);
                if (!XMLSchemaLoader.tokenizeSchemaLocationStr(string, hashtable)) {
                    xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{string}, (short)0);
                }
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs(), (short)0);
            }
        }
        if (string2 != null) {
            try {
                xSAttributeDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
                xSAttributeDecl.fType.validate(string2, null, null);
                LocationArray locationArray = (LocationArray)hashtable.get(XMLSymbols.EMPTY_STRING);
                if (locationArray == null) {
                    locationArray = new LocationArray();
                    hashtable.put(XMLSymbols.EMPTY_STRING, locationArray);
                }
                locationArray.addLocation(string2);
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs(), (short)0);
            }
        }
    }

    public static boolean tokenizeSchemaLocationStr(String string, Hashtable hashtable) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    return false;
                }
                String string3 = stringTokenizer.nextToken();
                LocationArray locationArray = (LocationArray)hashtable.get(string2);
                if (locationArray == null) {
                    locationArray = new LocationArray();
                    hashtable.put(string2, locationArray);
                }
                locationArray.addLocation(string3);
            }
        }
        return true;
    }

    private void processJAXPSchemaSource(Hashtable hashtable) throws IOException {
        this.fJAXPProcessed = true;
        if (this.fJAXPSource == null) {
            return;
        }
        Class<?> clazz = this.fJAXPSource.getClass().getComponentType();
        XMLInputSource xMLInputSource = null;
        String string = null;
        if (clazz == null) {
            SchemaGrammar schemaGrammar;
            if ((this.fJAXPSource instanceof InputStream || this.fJAXPSource instanceof InputSource) && (schemaGrammar = (SchemaGrammar)this.fJAXPCache.get(this.fJAXPSource)) != null) {
                this.fGrammarBucket.putGrammar(schemaGrammar);
                return;
            }
            this.fXSDDescription.reset();
            xMLInputSource = this.xsdToXMLInputSource(this.fJAXPSource);
            string = xMLInputSource.getSystemId();
            this.fXSDDescription.fContextType = (short)3;
            if (string != null) {
                this.fXSDDescription.setBaseSystemId(xMLInputSource.getBaseSystemId());
                this.fXSDDescription.setLiteralSystemId(string);
                this.fXSDDescription.setExpandedSystemId(string);
                this.fXSDDescription.fLocationHints = new String[]{string};
            }
            schemaGrammar = this.loadSchema(this.fXSDDescription, xMLInputSource, hashtable);
            if (this.fJAXPSource instanceof InputStream || this.fJAXPSource instanceof InputSource) {
                this.fJAXPCache.put(this.fJAXPSource, schemaGrammar);
            }
            this.fGrammarBucket.putGrammar(schemaGrammar);
            return;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz != clazz2) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz3) {
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("java.io.File");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz4) {
                    Class<?> clazz5 = class$3;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$3 = Class.forName("java.io.InputStream");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz != clazz5) {
                        Class<?> clazz6 = class$4;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$4 = Class.forName("org.xml.sax.InputSource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz != clazz6) {
                            throw new XMLConfigurationException(1, "\"http://java.sun.com/xml/jaxp/properties/schemaSource\" property cannot have an array of type {" + clazz.getName() + "}. Possible types of the array supported are Object, String, File, " + "InputStream, InputSource.");
                        }
                    }
                }
            }
        }
        Object[] objectArray = (Object[])this.fJAXPSource;
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            if ((objectArray[n] instanceof InputStream || objectArray[n] instanceof InputSource) && (object = (SchemaGrammar)this.fJAXPCache.get(objectArray[n])) != null) {
                this.fGrammarBucket.putGrammar((SchemaGrammar)object);
            } else {
                this.fXSDDescription.reset();
                xMLInputSource = this.xsdToXMLInputSource(objectArray[n]);
                string = xMLInputSource.getSystemId();
                this.fXSDDescription.fContextType = (short)3;
                if (string != null) {
                    this.fXSDDescription.setBaseSystemId(xMLInputSource.getBaseSystemId());
                    this.fXSDDescription.setLiteralSystemId(string);
                    this.fXSDDescription.setExpandedSystemId(string);
                    this.fXSDDescription.fLocationHints = new String[]{string};
                }
                object = null;
                SchemaGrammar schemaGrammar = this.fSchemaHandler.parseSchema(xMLInputSource, this.fXSDDescription, hashtable);
                if (this.fIsCheckedFully) {
                    XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
                }
                if (schemaGrammar != null) {
                    object = schemaGrammar.getTargetNamespace();
                    if (vector.contains(object)) {
                        throw new IllegalArgumentException(" When using array of Objects as the value of SCHEMA_SOURCE property , no two Schemas should share the same targetNamespace. ");
                    }
                    vector.add(object);
                    if (objectArray[n] instanceof InputStream || objectArray[n] instanceof InputSource) {
                        this.fJAXPCache.put(objectArray[n], schemaGrammar);
                    }
                    this.fGrammarBucket.putGrammar(schemaGrammar);
                }
            }
            ++n;
        }
    }

    private XMLInputSource xsdToXMLInputSource(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (this.fEntityResolver != null) {
                this.fXSDDescription.reset();
                this.fXSDDescription.setValues(null, string, null, null);
                XMLInputSource xMLInputSource = null;
                try {
                    xMLInputSource = this.fEntityResolver.resolveEntity(this.fXSDDescription);
                }
                catch (IOException iOException) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{string}, (short)1);
                }
                if (xMLInputSource == null) {
                    return new XMLInputSource(null, string, null);
                }
                return xMLInputSource;
            }
        } else {
            if (object instanceof InputSource) {
                return XMLSchemaLoader.saxToXMLInputSource((InputSource)object);
            }
            if (object instanceof InputStream) {
                return new XMLInputSource(null, null, null, (InputStream)object, null);
            }
            if (object instanceof File) {
                File file = (File)object;
                BufferedInputStream bufferedInputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{file.toString()}, (short)1);
                }
                return new XMLInputSource(null, null, null, bufferedInputStream, null);
            }
        }
        throw new XMLConfigurationException(1, "\"http://java.sun.com/xml/jaxp/properties/schemaSource\" property cannot have a value of type {" + object.getClass().getName() + "}. Possible types of the value supported are String, File, InputStream, " + "InputSource OR an array of these types.");
    }

    private static XMLInputSource saxToXMLInputSource(InputSource inputSource) {
        String string = inputSource.getPublicId();
        String string2 = inputSource.getSystemId();
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            return new XMLInputSource(string, string2, null, reader, null);
        }
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            return new XMLInputSource(string, string2, null, inputStream, inputSource.getEncoding());
        }
        return new XMLInputSource(string, string2, null);
    }

    public Boolean getFeatureDefault(String string) {
        return null;
    }

    public Object getPropertyDefault(String string) {
        return null;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fGrammarBucket.reset();
        this.initGrammarBucket();
        if (this.fUseDeclPool) {
            this.fDeclPool.reset();
            this.fCMBuilder.setDeclPool(this.fDeclPool);
            this.fSchemaHandler.setDeclPool(this.fDeclPool);
        } else {
            this.fCMBuilder.setDeclPool(null);
            this.fSchemaHandler.setDeclPool(null);
        }
        this.fSubGroupHandler.reset();
        if (xMLComponentManager == null) {
            return;
        }
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fIsCheckedFully = false;
        this.fEntityResolver = (XMLEntityResolver)xMLComponentManager.getProperty("http://apache.org/xml/properties/internal/entity-manager");
        try {
            this.fExternalSchemas = (String)xMLComponentManager.getProperty(SCHEMA_LOCATION);
            this.fExternalNoNSSchema = (String)xMLComponentManager.getProperty(SCHEMA_NONS_LOCATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalSchemas = null;
            this.fExternalNoNSSchema = null;
        }
        try {
            this.fJAXPSource = xMLComponentManager.getProperty(JAXP_SCHEMA_SOURCE);
            this.fJAXPProcessed = false;
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fJAXPSource = null;
            this.fJAXPProcessed = false;
        }
        try {
            this.fGrammarPool = (XMLGrammarPool)xMLComponentManager.getProperty(XMLGRAMMAR_POOL);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fGrammarPool = null;
        }
        this.fUseDeclPool = this.fGrammarPool == null;
        try {
            this.fAllowJavaEncodings = xMLComponentManager.getFeature(ALLOW_JAVA_ENCODINGS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {}
        try {
            this.fStrictURI = xMLComponentManager.getFeature(STANDARD_URI_CONFORMANT_FEATURE);
        }
        catch (XMLConfigurationException xMLConfigurationException) {}
        try {
            boolean bl = xMLComponentManager.getFeature(CONTINUE_AFTER_FATAL_ERROR);
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {}
        this.initGrammarBucket();
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityResolver, this.fSymbolTable, this.fGrammarPool, this.fAllowJavaEncodings, this.fStrictURI);
    }

    private void initGrammarBucket() {
        if (this.fGrammarPool != null) {
            Grammar[] grammarArray = this.fGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
            int n = 0;
            while (n < grammarArray.length) {
                if (!this.fGrammarBucket.putGrammar((SchemaGrammar)grammarArray[n], true)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
                }
                ++n;
            }
        }
    }

    public DOMConfiguration getConfig() {
        return this;
    }

    public XSModel load(LSInput lSInput) {
        try {
            Grammar grammar = this.loadGrammar(this.dom2xmlInputSource(lSInput));
            return ((XSGrammar)grammar).toXSModel();
        }
        catch (Exception exception) {
            if (this.fErrorHandler != null) {
                DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                dOMErrorImpl.fException = exception;
                dOMErrorImpl.fMessage = exception.getMessage();
                dOMErrorImpl.fSeverity = (short)3;
                this.fErrorHandler.getErrorHandler().handleError(dOMErrorImpl);
            }
            return null;
        }
    }

    public XSModel loadInputList(LSInputList lSInputList) {
        int n = lSInputList.getLength();
        if (n == 0) {
            return null;
        }
        SchemaGrammar[] schemaGrammarArray = new SchemaGrammar[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                schemaGrammarArray[n2] = (SchemaGrammar)this.loadGrammar(this.dom2xmlInputSource(lSInputList.item(n2)));
            }
            catch (Exception exception) {
                if (this.fErrorHandler != null) {
                    DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                    dOMErrorImpl.fException = exception;
                    dOMErrorImpl.fMessage = exception.getMessage();
                    dOMErrorImpl.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(dOMErrorImpl);
                }
                return null;
            }
            ++n2;
        }
        return new XSModelImpl(schemaGrammarArray);
    }

    public XSModel loadURI(String string) {
        try {
            Grammar grammar = this.loadGrammar(new XMLInputSource(null, string, null));
            return ((XSGrammar)grammar).toXSModel();
        }
        catch (Exception exception) {
            if (this.fErrorHandler != null) {
                DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                dOMErrorImpl.fException = exception;
                dOMErrorImpl.fMessage = exception.getMessage();
                dOMErrorImpl.fSeverity = (short)3;
                this.fErrorHandler.getErrorHandler().handleError(dOMErrorImpl);
            }
            return null;
        }
    }

    public XSModel loadURIList(StringList stringList) {
        int n = stringList.getLength();
        if (n == 0) {
            return null;
        }
        SchemaGrammar[] schemaGrammarArray = new SchemaGrammar[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                schemaGrammarArray[n2] = (SchemaGrammar)this.loadGrammar(new XMLInputSource(null, stringList.item(n2), null));
            }
            catch (Exception exception) {
                if (this.fErrorHandler != null) {
                    DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                    dOMErrorImpl.fException = exception;
                    dOMErrorImpl.fMessage = exception.getMessage();
                    dOMErrorImpl.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(dOMErrorImpl);
                }
                return null;
            }
            ++n2;
        }
        return new XSModelImpl(schemaGrammarArray);
    }

    public boolean canSetParameter(String string, Object object) {
        if (object instanceof Boolean) {
            ((Boolean)object).booleanValue();
            return string.equals("validate") || string.equals(SCHEMA_FULL_CHECKING) || string.equals(CONTINUE_AFTER_FATAL_ERROR) || string.equals(ALLOW_JAVA_ENCODINGS) || string.equals(STANDARD_URI_CONFORMANT_FEATURE);
        }
        return string.equals("error-handler") || string.equals(SYMBOL_TABLE) || string.equals(ERROR_REPORTER) || string.equals(ERROR_HANDLER) || string.equals(ENTITY_RESOLVER) || string.equals(XMLGRAMMAR_POOL) || string.equals(SCHEMA_LOCATION) || string.equals(SCHEMA_NONS_LOCATION) || string.equals(JAXP_SCHEMA_SOURCE);
    }

    public Object getParameter(String string) throws DOMException {
        if (string.equals("error-handler") && this.fErrorHandler != null) {
            return this.fErrorHandler.getErrorHandler();
        }
        try {
            boolean bl = this.getFeature(string);
            return bl ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception exception) {
            try {
                Object object = this.getProperty(string);
                return object;
            }
            catch (Exception exception2) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string2);
            }
        }
    }

    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            Vector<String> vector = new Vector<String>();
            vector.add("validate");
            vector.add(SYMBOL_TABLE);
            vector.add(ERROR_REPORTER);
            vector.add(ERROR_HANDLER);
            vector.add(ENTITY_RESOLVER);
            vector.add(XMLGRAMMAR_POOL);
            vector.add(SCHEMA_LOCATION);
            vector.add(SCHEMA_NONS_LOCATION);
            vector.add(JAXP_SCHEMA_SOURCE);
            vector.add(SCHEMA_FULL_CHECKING);
            vector.add(CONTINUE_AFTER_FATAL_ERROR);
            vector.add(ALLOW_JAVA_ENCODINGS);
            vector.add(STANDARD_URI_CONFORMANT_FEATURE);
            this.fRecognizedParameters = new DOMStringListImpl(vector);
        }
        return this.fRecognizedParameters;
    }

    public void setParameter(String string, Object object) throws DOMException {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (string.equals("validate") && bl) {
                return;
            }
            try {
                this.setFeature(string, bl);
            }
            catch (Exception exception) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string2);
            }
            return;
        }
        if (string.equals("error-handler")) {
            if (object instanceof DOMErrorHandler) {
                try {
                    this.fErrorHandler = new DOMErrorHandlerWrapper((DOMErrorHandler)object);
                    this.setErrorHandler(this.fErrorHandler);
                }
                catch (XMLConfigurationException xMLConfigurationException) {}
            } else {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string3);
            }
            return;
        }
        try {
            this.setProperty(string, object);
        }
        catch (Exception exception) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string4);
        }
    }

    private XMLInputSource dom2xmlInputSource(LSInput lSInput) {
        XMLInputSource xMLInputSource = null;
        xMLInputSource = lSInput.getStringData() != null ? new XMLInputSource(lSInput.getPublicId(), lSInput.getSystemId(), lSInput.getBaseURI(), new StringReader(lSInput.getStringData()), "UTF-16") : (lSInput.getCharacterStream() != null ? new XMLInputSource(lSInput.getPublicId(), lSInput.getSystemId(), lSInput.getBaseURI(), lSInput.getCharacterStream(), "UTF-16") : (lSInput.getByteStream() != null ? new XMLInputSource(lSInput.getPublicId(), lSInput.getSystemId(), lSInput.getBaseURI(), lSInput.getByteStream(), lSInput.getEncoding()) : new XMLInputSource(lSInput.getPublicId(), lSInput.getSystemId(), lSInput.getBaseURI())));
        return xMLInputSource;
    }

    static class LocationArray {
        int length;
        String[] locations = new String[2];

        LocationArray() {
        }

        public void resize(int n, int n2) {
            String[] stringArray = new String[n2];
            System.arraycopy(this.locations, 0, stringArray, 0, Math.min(n, n2));
            this.locations = stringArray;
            this.length = Math.min(n, n2);
        }

        public void addLocation(String string) {
            if (this.length >= this.locations.length) {
                this.resize(this.length, Math.max(1, this.length * 2));
            }
            this.locations[this.length++] = string;
        }

        public String[] getLocationArray() {
            if (this.length < this.locations.length) {
                this.resize(this.locations.length, this.length);
            }
            return this.locations;
        }

        public String getFirstLocation() {
            return this.length > 0 ? this.locations[0] : null;
        }

        public int getLength() {
            return this.length;
        }
    }
}

