/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLGrammarPreparser {
    private static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final Hashtable KNOWN_LOADERS = new Hashtable();
    private static final String[] RECOGNIZED_PROPERTIES;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected XMLGrammarPool fGrammarPool;
    protected Locale fLocale;
    private Hashtable fLoaders;

    static {
        KNOWN_LOADERS.put("http://www.w3.org/2001/XMLSchema", "org.apache.xerces.impl.xs.XMLSchemaLoader");
        KNOWN_LOADERS.put("http://www.w3.org/TR/REC-xml", "org.apache.xerces.impl.dtd.XMLDTDLoader");
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER, ERROR_HANDLER, ENTITY_RESOLVER, GRAMMAR_POOL};
    }

    public XMLGrammarPreparser() {
        this(new SymbolTable());
    }

    public XMLGrammarPreparser(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fLoaders = new Hashtable();
        this.setLocale(Locale.getDefault());
        this.fErrorReporter = new XMLErrorReporter();
        this.fErrorReporter.setLocale(this.fLocale);
        this.fEntityResolver = new XMLEntityManager();
    }

    public boolean registerPreparser(String string, XMLGrammarLoader xMLGrammarLoader) {
        if (xMLGrammarLoader == null) {
            if (KNOWN_LOADERS.containsKey(string)) {
                String string2 = (String)KNOWN_LOADERS.get(string);
                try {
                    ClassLoader classLoader = ObjectFactory.findClassLoader();
                    XMLGrammarLoader xMLGrammarLoader2 = (XMLGrammarLoader)ObjectFactory.newInstance(string2, classLoader, true);
                    this.fLoaders.put(string, xMLGrammarLoader2);
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }
            return false;
        }
        this.fLoaders.put(string, xMLGrammarLoader);
        return true;
    }

    public Grammar preparseGrammar(String string, XMLInputSource xMLInputSource) throws XNIException, IOException {
        if (this.fLoaders.containsKey(string)) {
            XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)this.fLoaders.get(string);
            xMLGrammarLoader.setProperty(SYMBOL_TABLE, this.fSymbolTable);
            xMLGrammarLoader.setProperty(ENTITY_RESOLVER, this.fEntityResolver);
            xMLGrammarLoader.setProperty(ERROR_REPORTER, this.fErrorReporter);
            if (this.fGrammarPool != null) {
                try {
                    xMLGrammarLoader.setProperty(GRAMMAR_POOL, this.fGrammarPool);
                }
                catch (Exception exception) {}
            }
            return xMLGrammarLoader.loadGrammar(xMLInputSource);
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, xMLErrorHandler);
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fEntityResolver = xMLEntityResolver;
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public void setGrammarPool(XMLGrammarPool xMLGrammarPool) {
        this.fGrammarPool = xMLGrammarPool;
    }

    public XMLGrammarPool getGrammarPool() {
        return this.fGrammarPool;
    }

    public XMLGrammarLoader getLoader(String string) {
        return (XMLGrammarLoader)this.fLoaders.get(string);
    }

    public void setFeature(String string, boolean bl) {
        Enumeration enumeration = this.fLoaders.elements();
        while (enumeration.hasMoreElements()) {
            XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)enumeration.nextElement();
            try {
                xMLGrammarLoader.setFeature(string, bl);
            }
            catch (Exception exception) {}
        }
        if (string.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, bl);
        }
    }

    public void setProperty(String string, Object object) {
        Enumeration enumeration = this.fLoaders.elements();
        while (enumeration.hasMoreElements()) {
            XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)enumeration.nextElement();
            try {
                xMLGrammarLoader.setProperty(string, object);
            }
            catch (Exception exception) {}
        }
    }

    public boolean getFeature(String string, String string2) {
        XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)this.fLoaders.get(string);
        return xMLGrammarLoader.getFeature(string2);
    }

    public Object getProperty(String string, String string2) {
        XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)this.fLoaders.get(string);
        return xMLGrammarLoader.getProperty(string2);
    }
}

