/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;

public class FnAbs
extends Function {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.function.FnAbs");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public FnAbs() {
        super(new QName("abs"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        if (!($assertionsDisabled || args.size() >= this.min_arity() && args.size() <= this.max_arity())) {
            throw new AssertionError();
        }
        ResultSequence argument = (ResultSequence)args.iterator().next();
        return FnAbs.fn_abs(argument);
    }

    public static ResultSequence fn_abs(ResultSequence arg) throws DynamicError {
        NumericType dat;
        NumericType nt = FnAbs.get_single_numeric_arg(arg);
        if (nt == null) {
            return ResultBuffer.EMPTY;
        }
        if (nt instanceof XSDouble) {
            dat = (XSDouble)nt;
            if (((XSDouble)dat).zero() || ((XSDouble)dat).negativeZero()) {
                return new XSDouble("0");
            }
            if (((XSDouble)dat).infinite()) {
                return new XSDouble(Double.POSITIVE_INFINITY);
            }
        }
        if (nt instanceof XSFloat) {
            dat = (XSFloat)nt;
            if (((XSFloat)dat).zero() || ((XSFloat)dat).negativeZero()) {
                return new XSFloat(new Float(0.0f).floatValue());
            }
            if (((XSFloat)dat).infinite()) {
                return new XSFloat(Float.POSITIVE_INFINITY);
            }
        }
        return nt.abs();
    }

    public static NumericType get_single_numeric_arg(ResultSequence arg) throws DynamicError {
        int size = arg.size();
        if (size > 1) {
            DynamicError.throw_type_error();
        }
        if (size == 0) {
            return null;
        }
        AnyType at = (AnyType)arg.item(0);
        if (!(at instanceof NumericType)) {
            throw DynamicError.invalidType();
        }
        return (NumericType)at;
    }
}

