/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.mylyn.internal.commons.ui.NotificationPopupColors;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.provisional.commons.ui.GradientCanvas;
import org.eclipse.mylyn.internal.provisional.commons.ui.SearchHistoryPopUpDialog;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchUtil;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListFilteredTree;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class TaskListSearchHistoryPopupDialog
extends SearchHistoryPopUpDialog {
    private static NotificationPopupColors colors;
    private LocalResourceManager resourceManager;

    public TaskListSearchHistoryPopupDialog(Shell parent, int side) {
        super(parent, side);
    }

    protected void createAdditionalSearchRegion(Composite composite) {
        if (!SearchUtil.supportsTaskSearch()) {
            return;
        }
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        colors = new NotificationPopupColors(composite.getDisplay(), (ResourceManager)this.resourceManager);
        GradientCanvas gradient = new GradientCanvas(composite, 0);
        gradient.setBackgroundGradient(new Color[]{colors.getGradientBegin(), colors.getGradientEnd()}, new int[]{100}, true);
        GridLayout headLayout = new GridLayout();
        headLayout.marginHeight = 5;
        headLayout.marginWidth = 5;
        headLayout.horizontalSpacing = 0;
        headLayout.verticalSpacing = 0;
        gradient.setLayout((Layout)headLayout);
        gradient.setLayoutData((Object)new GridData(768));
        gradient.setSeparatorVisible(true);
        gradient.setSeparatorAlignment(128);
        Composite editContainer = new Composite((Composite)gradient, 0);
        GridLayout editLayout = new GridLayout();
        editLayout.marginHeight = 0;
        editLayout.marginWidth = 0;
        editContainer.setLayout((Layout)editLayout);
        editContainer.setLayoutData((Object)new GridData(2, 2, true, true));
        ImageHyperlink advancedSearchButton = new ImageHyperlink(editContainer, 0);
        advancedSearchButton.setUnderlined(true);
        advancedSearchButton.setForeground(CommonColors.HYPERLINK_WIDGET);
        advancedSearchButton.setText(TaskListFilteredTree.LABEL_SEARCH);
        advancedSearchButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SearchUtil.openSearchDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        });
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)advancedSearchButton);
    }
}

