/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class BaseFigureDecorator
extends Label
implements RotatableDecoration {
    protected static int DEFAULT_DECORATOR_POSITION = 12;
    private Point location = new Point();
    private Transform transform = new Transform();
    private int position;

    public BaseFigureDecorator(Image image) {
        this.position = DEFAULT_DECORATOR_POSITION;
        this.setIcon(image);
        this.setSize(this.getPreferredSize());
    }

    public BaseFigureDecorator(Image image, String tooltip) {
        this.position = DEFAULT_DECORATOR_POSITION;
        this.setIcon(image);
        this.setSize(this.getPreferredSize());
        this.setToolTip((IFigure)new Label(tooltip));
    }

    public BaseFigureDecorator(Image image, String tooltip, int position) {
        this.position = position;
        this.setIcon(image);
        this.setSize(this.getPreferredSize());
        this.setToolTip((IFigure)new Label(tooltip));
    }

    public Font getFont() {
        Font localFont = this.getLocalFont();
        if (localFont == null) {
            localFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
            this.setFont(localFont);
        }
        return localFont;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setToolTipText(String tooltip) {
        super.setToolTip((IFigure)new Label(tooltip));
    }

    public String getToolTipText() {
        Label label = (Label)super.getToolTip();
        return label.getText();
    }

    public void setLocation(Point p) {
        this.bounds = null;
        this.location.setLocation(p);
        this.transform.setTranslation((double)p.x, (double)p.y);
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            if (this.prefSize == null) {
                this.getPreferredSize();
            }
            int w = this.prefSize.width;
            int h = this.prefSize.height;
            Point p = this.location;
            this.bounds = new Rectangle(p.x - w / 2, p.y - h / 2, w, h).getExpanded(w, h);
        }
        return this.bounds;
    }

    protected boolean useLocalCoordinates() {
        return false;
    }

    public void setScale(double x, double y) {
        this.bounds = null;
        this.transform.setScale(x, y);
    }

    public void setReferencePoint(Point ref) {
        this.bounds = null;
        Point pt = Point.SINGLETON;
        pt.setLocation(ref);
        pt.negate().translate(this.location);
        this.setRotation(Math.atan2(pt.y, pt.x));
    }

    public void setRotation(double angle) {
        this.bounds = null;
    }
}

