/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.UnimplementedException;
import java.util.Iterator;

public class EntryOrderedHashMap {
    private Entry[] fHeaders;
    private Entry fFirst;
    private Entry fLast;
    private int fSize = 0;

    public Object get(Object object) {
        if (this.fHeaders == null) {
            return null;
        }
        int n = Math.abs(object.hashCode()) % this.fHeaders.length;
        Entry entry = this.fHeaders[n];
        while (entry != null) {
            if (entry.getKey().equals(object)) {
                return entry.getValue();
            }
            entry = entry.nextByHash;
        }
        return null;
    }

    public boolean put(Object object, Object object2) {
        if (this.fHeaders == null) {
            this.fHeaders = new Entry[1];
        }
        int n = object.hashCode();
        int n2 = Math.abs(n) % this.fHeaders.length;
        Entry entry = this.fHeaders[n2];
        while (entry != null) {
            if (entry.getKey().equals(object)) {
                entry.key = object;
                entry.value = object2;
                return false;
            }
            entry = entry.nextByHash;
        }
        return this.addEntry(object, object2, n, n2);
    }

    public boolean putNoReplace(Object object, Object object2) {
        if (this.fHeaders == null) {
            this.fHeaders = new Entry[1];
        }
        int n = object.hashCode();
        int n2 = Math.abs(object.hashCode()) % this.fHeaders.length;
        Entry entry = this.fHeaders[n2];
        while (entry != null) {
            if (entry.getKey().equals(object)) {
                return false;
            }
            entry = entry.nextByHash;
        }
        return this.addEntry(object, object2, n, n2);
    }

    private boolean addEntry(Object object, Object object2, int n, int n2) {
        this.grow();
        Entry entry = this.makeEntry(object, object2, n);
        entry.nextByHash = this.fHeaders[n2];
        this.fHeaders[n2] = entry;
        ++this.fSize;
        return true;
    }

    private Entry[] getHeaders() {
        if (this.fHeaders == null) {
            this.fHeaders = new Entry[1];
        }
        return this.fHeaders;
    }

    private void grow() {
        if (this.fHeaders == null) {
            this.fHeaders = new Entry[1];
        } else if (this.fSize == this.fHeaders.length) {
            this.fHeaders = new Entry[this.fHeaders.length * 2];
            this.remap();
        }
    }

    private Entry makeEntry(Object object, Object object2, int n) {
        Entry entry = new Entry(object, object2, n);
        if (this.fFirst == null) {
            this.fFirst = this.fLast = entry;
        } else {
            this.fLast.nextByOrder = entry;
            this.fLast = entry;
        }
        return entry;
    }

    public boolean contains(Object object) {
        if (this.fHeaders == null) {
            return false;
        }
        int n = Math.abs(object.hashCode()) % this.fHeaders.length;
        Entry entry = this.fHeaders[n];
        while (entry != null) {
            if (entry.key.equals(object)) {
                return true;
            }
            entry = entry.nextByHash;
        }
        return false;
    }

    public int size() {
        return this.fSize;
    }

    public Iterator keys() {
        return new KeyIterator(this.fFirst);
    }

    public Iterator values() {
        return new ValueIterator(this.fFirst);
    }

    private void remap() {
        Entry entry = this.fFirst;
        while (entry != null) {
            int n = Math.abs(entry.hashCode) % this.fHeaders.length;
            entry.nextByHash = this.fHeaders[n];
            this.fHeaders[n] = entry;
            entry = entry.nextByOrder;
        }
    }

    public static class Entry {
        private Object key;
        private Object value;
        private Entry nextByHash;
        private Entry nextByOrder;
        private int hashCode;

        private Entry(Object object, Object object2) {
            this(object, object2, object.hashCode());
        }

        private Entry(Object object, Object object2, int n) {
            this.key = object;
            this.value = object2;
            this.hashCode = n;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Entry getNext() {
            return this.nextByOrder;
        }
    }

    private static class EntryIterator
    implements Iterator {
        private Entry fEntry;

        public EntryIterator(Entry entry) {
            this.fEntry = entry;
        }

        public void remove() {
            throw new UnimplementedException();
        }

        public boolean hasNext() {
            while (this.fEntry != null && this.fEntry.key == null) {
                this.fEntry = this.fEntry.nextByOrder;
            }
            return this.fEntry != null;
        }

        public Object next() {
            Entry entry = this.fEntry;
            this.fEntry = this.fEntry.nextByOrder;
            return entry;
        }
    }

    private static class KeyIterator
    extends EntryIterator {
        public KeyIterator(Entry entry) {
            super(entry);
        }

        public Object next() {
            return ((Entry)super.next()).getKey();
        }
    }

    private static class ValueIterator
    extends EntryIterator {
        public ValueIterator(Entry entry) {
            super(entry);
        }

        public Object next() {
            return ((Entry)super.next()).getValue();
        }
    }
}

