/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.UnimplementedException;
import java.util.Collection;
import java.util.Iterator;

public class EntryOrderedMultiSet {
    private Entry[] fHeaders;
    private Entry fFirst;
    private Entry fLast;
    private int fSize;

    public void add(Object object) {
        if (this.fHeaders == null) {
            this.fHeaders = new Entry[1];
        } else if (this.fSize == this.fHeaders.length) {
            this.fHeaders = new Entry[this.fHeaders.length * 2];
            this.remap();
        }
        Entry entry = new Entry(object, object.hashCode());
        if (this.fFirst == null) {
            this.fFirst = this.fLast = entry;
        } else {
            this.fLast.nextByOrder = entry;
            this.fLast = entry;
        }
        this.addEntry(entry);
    }

    public void addAll(EntryOrderedMultiSet entryOrderedMultiSet) {
        Iterator iterator = entryOrderedMultiSet.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public boolean contains(Object object) {
        if (this.fHeaders == null) {
            return false;
        }
        int n = Math.abs(object.hashCode()) % this.fHeaders.length;
        Entry entry = this.fHeaders[n];
        while (entry != null) {
            if (entry.object.equals(object)) {
                return true;
            }
            entry = entry.nextByHash;
        }
        return false;
    }

    public int size() {
        return this.fSize;
    }

    public Iterator iterator() {
        return new EntryIterator(this.fFirst);
    }

    private void remap() {
        this.fSize = 0;
        Entry entry = this.fFirst;
        while (entry != null) {
            this.addEntry(entry);
            entry = entry.nextByOrder;
        }
    }

    private void addEntry(Entry entry) {
        int n = Math.abs(entry.hashCode) % this.fHeaders.length;
        entry.nextByHash = this.fHeaders[n];
        this.fHeaders[n] = entry;
        ++this.fSize;
    }

    public static class Entry {
        private Object object;
        private Entry nextByHash;
        private Entry nextByOrder;
        private int hashCode;

        private Entry(Object object, int n) {
            this.object = object;
            this.hashCode = n;
        }

        public Object getObject() {
            return this.object;
        }

        public Entry getNext() {
            return this.nextByOrder;
        }
    }

    private static class EntryIterator
    implements Iterator {
        private Entry fEntry;

        public EntryIterator(Entry entry) {
            this.fEntry = entry;
        }

        public void remove() {
            throw new UnimplementedException();
        }

        public boolean hasNext() {
            return this.fEntry != null;
        }

        public Object next() {
            Object object = this.fEntry.object;
            this.fEntry = this.fEntry.nextByOrder;
            return object;
        }
    }
}

