/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

public class IntArrayList {
    private static final int INITIAL_LENGTH = 10;
    private int modCount = 0;
    private int size = 0;
    private int[] array = new int[10];

    public IntArrayList() {
        this.array = new int[10];
    }

    public IntArrayList(int n) {
        if (n < 1) {
            n = 10;
        }
        this.array = new int[n];
    }

    public int size() {
        return this.size;
    }

    public void add(int n) {
        this.assureOne();
        this.array[this.size++] = n;
    }

    public void addLast(int n) {
        this.add(n);
    }

    public void addFirst(int n) {
        this.assureOne();
        System.arraycopy(this.array, 0, this.array, 1, this.size);
        this.array[0] = n;
        ++this.size;
    }

    public int removeLast() {
        this.checkIndex(this.size - 1);
        return this.array[--this.size];
    }

    public int get(int n) {
        this.checkIndex(n);
        return this.array[n];
    }

    public void set(int n, int n2) {
        this.checkIndex(n);
        this.array[n] = n2;
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds " + n);
        }
    }

    public int remove(int n) {
        this.checkIndex(n);
        int n2 = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.size - n);
        --this.size;
        return n2;
    }

    private void assureOne() {
        if (this.size == this.array.length) {
            int[] nArray = new int[this.size * 2];
            System.arraycopy(this.array, 0, nArray, 0, this.size);
            this.array = nArray;
        }
    }

    public void addAll(IntArrayList intArrayList) {
        if (this.array.length < this.size + intArrayList.size) {
            int[] nArray = new int[Math.max(this.size * 2, this.size + intArrayList.size)];
            System.arraycopy(this.array, 0, nArray, 0, this.size);
            this.array = nArray;
        }
        System.arraycopy(intArrayList.array, 0, this.array, this.size, intArrayList.size);
        this.size += intArrayList.size;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.array, 0, nArray, 0, this.size);
        return nArray;
    }
}

