/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.IRewindableInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RewindableInputStream
extends IRewindableInputStream {
    private static final int AHEAD_MAX = 512;
    private byte[] fAhead = new byte[512];
    private int fPos = 0;
    private int fRead = 0;
    private boolean fEof = false;
    private InputStream fStream;
    private boolean fCanRewind = true;

    public RewindableInputStream(InputStream inputStream) {
        this.fStream = inputStream;
    }

    public int read() throws IOException {
        int n;
        while (true) {
            if (this.fPos < this.fRead) {
                return this.fAhead[this.fPos++] & 0xFF;
            }
            if (this.fEof) {
                return -1;
            }
            if (this.fRead < 512) {
                n = this.fStream.read(this.fAhead, this.fPos, 512 - this.fPos);
                if (n < 0) {
                    this.fEof = true;
                    continue;
                }
                this.fRead += n;
                continue;
            }
            this.fCanRewind = false;
            n = this.fStream.read();
            if (n >= 0) break;
            this.fEof = true;
        }
        return n;
    }

    public boolean canRewind() {
        return this.fCanRewind;
    }

    public void rewind(int n) {
        if (!this.fCanRewind) {
            throw new IllegalStateException("Can't rewind when more than 512 bytes read");
        }
        if (n > this.fPos) {
            throw new IllegalArgumentException("Can't rewind forward");
        }
        this.fPos = n;
    }
}

