/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.UnimplementedException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SoftHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();
    private volatile int modCount;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    public SoftHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this.table = new Entry[n2];
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
    }

    public SoftHashMap(int n) {
        this(n, 0.75f);
    }

    public SoftHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    public SoftHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    private void expungeStaleEntries() {
        Reference reference;
        block0: while ((reference = this.queue.poll()) != null) {
            Entry entry;
            Entry entry2 = (Entry)reference;
            int n = entry2.hash;
            int n2 = SoftHashMap.indexFor(n, this.table.length);
            Entry entry3 = entry = this.table[n2];
            while (entry3 != null) {
                Entry entry4 = entry3.next;
                if (entry3 == entry2) {
                    if (entry == entry2) {
                        this.table[n2] = entry4;
                    } else {
                        entry.next = entry4;
                    }
                    entry2.next = null;
                    entry2.value = null;
                    --this.size;
                    continue block0;
                }
                entry = entry3;
                entry3 = entry4;
            }
        }
    }

    private Entry[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object get(Object object) {
        Object object2 = SoftHashMap.maskNull(object);
        int n = this.hash(object2);
        Entry[] entryArray = this.getTable();
        int n2 = SoftHashMap.indexFor(n, entryArray.length);
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && SoftHashMap.eq(object2, entry.get())) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private int hash(Object object) {
        int n = object.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    Entry getEntry(Object object) {
        Object object2 = SoftHashMap.maskNull(object);
        int n = this.hash(object2);
        Entry[] entryArray = this.getTable();
        int n2 = SoftHashMap.indexFor(n, entryArray.length);
        Entry entry = entryArray[n2];
        while (!(entry == null || entry.hash == n && SoftHashMap.eq(object2, entry.get()))) {
            entry = entry.next;
        }
        return entry;
    }

    public Object put(Object object, Object object2) {
        Object object3 = SoftHashMap.maskNull(object);
        int n = this.hash(object3);
        Entry[] entryArray = this.getTable();
        int n2 = SoftHashMap.indexFor(n, entryArray.length);
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.hash && SoftHashMap.eq(object3, entry.get())) {
                Object object4 = entry.value;
                if (object2 != object4) {
                    entry.value = object2;
                }
                return object4;
            }
            entry = entry.next;
        }
        ++this.modCount;
        entryArray[n2] = new Entry(object3, object2, this.queue, n, entryArray[n2]);
        if (++this.size >= this.threshold) {
            this.resize(entryArray.length * 2);
        }
        return null;
    }

    void resize(int n) {
        Entry[] entryArray = this.getTable();
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray, entryArray2);
        this.table = entryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray2, entryArray);
            this.table = entryArray;
        }
    }

    private void transfer(Entry[] entryArray, Entry[] entryArray2) {
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            entryArray[n] = null;
            while (entry != null) {
                Entry entry2 = entry.next;
                Object t = entry.get();
                if (t == null) {
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                } else {
                    int n2 = SoftHashMap.indexFor(entry.hash, entryArray2.length);
                    entry.next = entryArray2[n2];
                    entryArray2[n2] = entry;
                }
                entry = entry2;
            }
            ++n;
        }
    }

    public void putAll(Map map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2 = (int)((float)n / this.loadFactor + 1.0f);
            if (n2 > 0x40000000) {
                n2 = 0x40000000;
            }
            int n3 = this.table.length;
            while (n3 < n2) {
                n3 <<= 1;
            }
            if (n3 > this.table.length) {
                this.resize(n3);
            }
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Entry entry;
        Object object2 = SoftHashMap.maskNull(object);
        int n = this.hash(object2);
        Entry[] entryArray = this.getTable();
        int n2 = SoftHashMap.indexFor(n, entryArray.length);
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n == entry2.hash && SoftHashMap.eq(object2, entry2.get())) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    entryArray[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    Entry removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Entry[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = SoftHashMap.maskNull(entry2.getKey());
        int n = this.hash(object2);
        int n2 = SoftHashMap.indexFor(n, entryArray.length);
        Entry entry3 = entry = entryArray[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (n == entry3.hash && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    entryArray[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return null;
    }

    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Entry[] entryArray = this.table;
        int n = 0;
        while (n < entryArray.length) {
            entryArray[n] = null;
            ++n;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Set keySet() {
        throw new UnimplementedException();
    }

    public Collection values() {
        throw new UnimplementedException();
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    private static class Entry
    extends SoftReference
    implements Map.Entry {
        private Object value;
        private final int hash;
        private Entry next;

        Entry(Object object, Object object2, ReferenceQueue referenceQueue, int n, Entry entry) {
            super(object, referenceQueue);
            this.value = object2;
            this.hash = n;
            this.next = entry;
        }

        public Object getKey() {
            return SoftHashMap.unmaskNull(this.get());
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            Object v;
            Object object2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object3 = this.getKey();
            return (object3 == (k = entry.getKey()) || object3 != null && object3.equals(k)) && ((object2 = this.getValue()) == (v = entry.getValue()) || object2 != null && object2.equals(v));
        }

        public int hashCode() {
            Object object = this.getKey();
            Object object2 = this.getValue();
            return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private abstract class HashIterator
    implements Iterator {
        int index;
        Entry entry = null;
        Entry lastReturned = null;
        int expectedModCount;
        Object nextKey;
        Object currentKey;

        HashIterator() {
            this.expectedModCount = SoftHashMap.this.modCount;
            this.nextKey = null;
            this.currentKey = null;
            this.index = SoftHashMap.this.size() != 0 ? SoftHashMap.this.table.length : 0;
        }

        public boolean hasNext() {
            Entry[] entryArray = SoftHashMap.this.table;
            while (this.nextKey == null) {
                Entry entry = this.entry;
                int n = this.index;
                while (entry == null && n > 0) {
                    entry = entryArray[--n];
                }
                this.entry = entry;
                this.index = n;
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = entry.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry nextEntry() {
            if (SoftHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (SoftHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SoftHashMap.this.remove(this.currentKey);
            this.expectedModCount = SoftHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private class ValueIterator
    extends HashIterator {
        ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends HashIterator {
        KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends HashIterator {
        EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class KeySet
    extends AbstractSet {
        KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return SoftHashMap.this.size();
        }

        public boolean contains(Object object) {
            return SoftHashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            if (SoftHashMap.this.containsKey(object)) {
                SoftHashMap.this.remove(object);
                return true;
            }
            return false;
        }

        public void clear() {
            SoftHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }
    }

    private class Values
    extends AbstractCollection {
        Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return SoftHashMap.this.size();
        }

        public boolean contains(Object object) {
            return SoftHashMap.this.containsValue(object);
        }

        public void clear() {
            SoftHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }
    }

    private class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            entry.getKey();
            Entry entry2 = SoftHashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        public boolean remove(Object object) {
            return SoftHashMap.this.removeMapping(object) != null;
        }

        public int size() {
            return SoftHashMap.this.size();
        }

        public void clear() {
            SoftHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList<SimpleEntry> arrayList = new ArrayList<SimpleEntry>(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList<SimpleEntry> arrayList = new ArrayList<SimpleEntry>(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray(objectArray);
        }
    }

    static class SimpleEntry
    implements Map.Entry {
        Object key;
        Object value;

        public SimpleEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public SimpleEntry(Map.Entry entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }
}

