/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.FactoryObject;
import com.objfac.util.IMapHolder;
import com.objfac.util.SortedSet;
import java.util.Comparator;
import java.util.Iterator;

public class SortedMap
implements FactoryObject {
    private SortedSet fSet;
    private IMapHolder fHolder;
    private SortedMap fNext;

    public SortedMap(IMapHolder iMapHolder, Comparator comparator) {
        this.fHolder = iMapHolder;
        this.fSet = new SortedSet(iMapHolder, comparator);
    }

    public SortedMap(Comparator comparator) {
        this.fSet = new SortedSet(comparator);
    }

    public SortedMap(IMapHolder iMapHolder) {
        this.fHolder = iMapHolder;
        this.fSet = new SortedSet(iMapHolder);
    }

    public SortedMap() {
        this.fSet = new SortedSet();
    }

    public void setMapHolder(IMapHolder iMapHolder) {
        this.fHolder = iMapHolder;
        this.fSet.setKeyHolder(iMapHolder);
    }

    public void setComparator(Comparator comparator) {
        this.fSet.setComparator(comparator);
    }

    public boolean containsKey(Object object) {
        return this.fSet.contains(object);
    }

    public boolean containsKeyIdentity(Object object) {
        return this.fSet.containsIdentity(object);
    }

    public Object put(Object object, Object object2) {
        Object[] objectArray = this.fHolder.getValues();
        int n = this.fSet.indexOf(object);
        Object object3 = n >= 0 && objectArray != null ? objectArray[n] : null;
        int n2 = this.fSet.internalAdd(object, false);
        if (n2 >= 0) {
            this.internalPut(n2, object2);
        }
        return object3;
    }

    protected void internalPut(int n, Object object) {
        Object[] objectArray = this.fHolder.getValues();
        if (objectArray == null) {
            objectArray = new Object[]{object};
            return;
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[n] = object;
        System.arraycopy(objectArray, n, objectArray2, n + 1, objectArray.length - n);
        this.fHolder.setValues(objectArray2);
    }

    public int putAlways(Object object, Object object2) {
        int n = this.fSet.internalAdd(object, true);
        this.internalPut(n, object2);
        return n;
    }

    public void append(Object object, Object object2) {
        Object[] objectArray = this.fHolder.getValues();
        int n = objectArray != null ? objectArray.length : 0;
        this.fSet.internalAdd(n, object);
        this.internalPut(n, object2);
    }

    public Object get(Object object) {
        Object[] objectArray = this.fHolder.getValues();
        if (objectArray == null) {
            return null;
        }
        int n = this.fSet.indexOf(object);
        if (n >= 0) {
            return objectArray[n];
        }
        return null;
    }

    public Object getIdentity(Object object) {
        Object[] objectArray = this.fHolder.getValues();
        if (objectArray == null) {
            return null;
        }
        int n = this.fSet.indexOfIdentity(object);
        if (n >= 0) {
            return objectArray[n];
        }
        return null;
    }

    public Object[] keys() {
        return this.fSet.members();
    }

    public Object[] values() {
        Object[] objectArray = this.fHolder.getValues();
        if (objectArray == null) {
            return new Object[0];
        }
        return objectArray;
    }

    public Iterator keyIterator() {
        return new ArrayIterator();
    }

    public Iterator valueIterator() {
        return new ArrayIterator();
    }

    public void remove(int n) {
        Object[] objectArray = this.fHolder.getValues();
        if (objectArray == null) {
            throw new IllegalArgumentException("remove(" + n + ") in empty map");
        }
        this.fSet.remove(n);
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
        this.fHolder.setValues(objectArray2);
    }

    public Object remove(Object object) {
        Object[] objectArray = this.fHolder.getValues();
        if (objectArray == null) {
            return null;
        }
        int n = this.fSet.indexOf(object);
        if (n >= 0) {
            Object object2 = objectArray[n];
            this.fSet.remove(n);
            this.remove(n);
            return object2;
        }
        return null;
    }

    public Object removeIdentity(Object object) {
        Object[] objectArray = this.fHolder.getValues();
        if (objectArray == null) {
            return null;
        }
        int n = this.fSet.indexOfIdentity(object);
        if (n >= 0) {
            Object object2 = objectArray[n];
            this.fSet.remove(n);
            this.remove(n);
            return object2;
        }
        return null;
    }

    public int size() {
        return this.fSet.size();
    }

    public int keyIndex(Object object) {
        return this.fSet.indexOf(object);
    }

    public void merge(SortedMap sortedMap) {
        Object[] objectArray = this.fHolder.getValues();
        Object[] objectArray2 = this.fHolder.getKeys();
        Object[] objectArray3 = sortedMap.fHolder.getValues();
        Object[] objectArray4 = sortedMap.fHolder.getKeys();
        if (objectArray4 == null) {
            return;
        }
        if (objectArray2 == null) {
            this.fHolder.setKeys(objectArray4);
            this.fHolder.setValues(objectArray3);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = objectArray2.length;
        int n5 = objectArray4.length;
        Object[] objectArray5 = new Object[n4 + n5];
        Object[] objectArray6 = new Object[n4 + n5];
        while (n < n4 && n2 < n5) {
            int n6 = this.fSet.fComp.compare(objectArray2[n], objectArray4[n2]);
            if (n6 <= 0) {
                objectArray6[n3] = objectArray[n];
                objectArray5[n3++] = objectArray2[n++];
                continue;
            }
            objectArray6[n3] = objectArray3[n2];
            objectArray5[n3++] = objectArray4[n2++];
        }
        while (n < n4) {
            objectArray6[n3] = objectArray[n];
            objectArray5[n3++] = objectArray2[n++];
        }
        while (n2 < n5) {
            objectArray6[n3] = objectArray3[n2];
            objectArray5[n3++] = objectArray4[n2++];
        }
        this.fHolder.setKeys(objectArray5);
        this.fHolder.setValues(objectArray6);
    }

    public FactoryObject next() {
        return this.fNext;
    }

    public void next(FactoryObject factoryObject) {
        this.fNext = (SortedMap)factoryObject;
    }

    private class ArrayIterator
    implements Iterator {
        private int fIndex = -1;

        public boolean hasNext() {
            Object[] objectArray = SortedMap.this.fHolder.getKeys();
            if (objectArray == null) {
                return false;
            }
            return this.fIndex + 1 < objectArray.length;
        }

        public Object next() {
            Object[] objectArray = SortedMap.this.fHolder.getKeys();
            if (objectArray == null) {
                throw new IllegalStateException("next() called for empty array");
            }
            return objectArray[++this.fIndex];
        }

        public void remove() {
            SortedMap.this.remove(this.fIndex);
            --this.fIndex;
        }
    }
}

