/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.IKeyHolder;
import java.util.Comparator;

public class SortedSet {
    protected Comparator fComp;
    protected IKeyHolder fKeyHolder;
    protected SortedSet fNext;

    public SortedSet(IKeyHolder iKeyHolder, Comparator comparator) {
        this.fComp = comparator;
        this.fKeyHolder = iKeyHolder;
    }

    public SortedSet(Comparator comparator) {
        this.fComp = comparator;
    }

    public SortedSet(IKeyHolder iKeyHolder) {
        this.fKeyHolder = iKeyHolder;
    }

    public SortedSet() {
    }

    public void setKeyHolder(IKeyHolder iKeyHolder) {
        this.fKeyHolder = iKeyHolder;
    }

    public void setComparator(Comparator comparator) {
        this.fComp = comparator;
    }

    public boolean add(Object object) {
        return this.internalAdd(object, false) >= 0;
    }

    protected int internalAdd(Object object, boolean bl) {
        Object[] objectArray = this.fKeyHolder.getKeys();
        if (objectArray == null) {
            objectArray = new Object[1];
            this.fKeyHolder.setKeys(objectArray);
            objectArray[0] = object;
            return 0;
        }
        int n = 0;
        int n2 = -1;
        while (n < objectArray.length) {
            n2 = this.fComp.compare(object, objectArray[n]);
            if (n2 <= 0) break;
            ++n;
        }
        if (n2 == 0 && !bl) {
            return -1;
        }
        this.internalAdd(n, object);
        return n;
    }

    protected void internalAdd(int n, Object object) {
        Object[] objectArray = this.fKeyHolder.getKeys();
        if (objectArray == null) {
            objectArray = new Object[]{object};
            this.fKeyHolder.setKeys(objectArray);
        } else {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            objectArray2[n] = object;
            System.arraycopy(objectArray, n, objectArray2, n + 1, objectArray.length - n);
            this.fKeyHolder.setKeys(objectArray2);
        }
    }

    public int addAlways(Object object) {
        return this.internalAdd(object, true);
    }

    public void append(Object object) {
        Object[] objectArray = this.fKeyHolder.getKeys();
        int n = objectArray != null ? objectArray.length : 0;
        this.internalAdd(n, object);
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public int indexOf(Object object) {
        Object[] objectArray = this.fKeyHolder.getKeys();
        if (objectArray == null) {
            return -1;
        }
        int n = 0;
        while (n < objectArray.length) {
            int n2 = this.fComp.compare(object, objectArray[n]);
            if (n2 == 0) {
                return n;
            }
            if (n2 < 0) {
                return -1;
            }
            ++n;
        }
        return -1;
    }

    public boolean containsIdentity(Object object) {
        return this.indexOf(object) >= 0;
    }

    public int indexOfIdentity(Object object) {
        Object[] objectArray = this.fKeyHolder.getKeys();
        if (objectArray == null) {
            return -1;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (object == objectArray[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean equals(Object object) {
        Object[] objectArray;
        if (this == object) {
            return true;
        }
        if (!(object instanceof SortedSet)) {
            return false;
        }
        SortedSet sortedSet = (SortedSet)object;
        Object[] objectArray2 = this.fKeyHolder.getKeys();
        if (objectArray2 == null != ((objectArray = sortedSet.fKeyHolder.getKeys()) == null)) {
            return false;
        }
        if (objectArray2 == null) {
            return true;
        }
        if (objectArray2.length != objectArray.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray2.length) {
            if (objectArray2[n] != objectArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equalsIdentify(Object object) {
        Object[] objectArray;
        if (this == object) {
            return true;
        }
        if (!(object instanceof SortedSet)) {
            return false;
        }
        SortedSet sortedSet = (SortedSet)object;
        Object[] objectArray2 = this.fKeyHolder.getKeys();
        if (objectArray2 == null != ((objectArray = sortedSet.fKeyHolder.getKeys()) == null)) {
            return false;
        }
        if (objectArray2 == null) {
            return true;
        }
        if (objectArray2.length != objectArray.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray2.length) {
            if (this.fComp.compare(objectArray2[n], objectArray[n]) != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void merge(SortedSet sortedSet) {
        Object[] objectArray = this.fKeyHolder.getKeys();
        Object[] objectArray2 = sortedSet.fKeyHolder.getKeys();
        if (objectArray2 == null) {
            return;
        }
        if (objectArray == null) {
            objectArray = objectArray2;
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = objectArray.length;
        int n5 = objectArray2.length;
        Object[] objectArray3 = new Object[n4 + n5];
        while (n < n4 && n2 < n5) {
            int n6 = this.fComp.compare(objectArray[n], objectArray2[n2]);
            objectArray3[n3++] = n6 <= 0 ? objectArray[n++] : objectArray2[n2++];
        }
        while (n < n4) {
            objectArray3[n3++] = objectArray[n++];
        }
        while (n2 < n5) {
            objectArray3[n3++] = objectArray2[n2++];
        }
    }

    public Object[] members() {
        Object[] objectArray = this.fKeyHolder.getKeys();
        if (objectArray == null) {
            return new Object[0];
        }
        return objectArray;
    }

    public int size() {
        Object[] objectArray = this.fKeyHolder.getKeys();
        return objectArray == null ? 0 : objectArray.length;
    }

    public void remove(int n) {
        Object[] objectArray = this.fKeyHolder.getKeys();
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
        this.fKeyHolder.setKeys(objectArray2);
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public boolean removeIdentity(Object object) {
        int n = this.indexOfIdentity(object);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public SortedSet getNextSet() {
        return this.fNext;
    }

    public void setNextSet(SortedSet sortedSet) {
        this.fNext = sortedSet;
    }
}

