/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.ImmutableIterator;
import com.objfac.util.Location;
import com.objfac.util.SymbolPool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class SymbolPoolImpl
implements SymbolPool {
    private LinkedList fStack = new LinkedList();
    private HashMap fBufferedLocations = new HashMap();
    private char[] fStrings = new char[16];
    private int fStringSize = 0;
    private int fSize = 0;
    private byte[] fData = new byte[16];
    private int fDataSize = 0;
    private int[] fSegmentIndices = new int[16];
    private Location[] fSegmentLocations = new Location[16];
    private int fSegmentSize = 0;
    private BufferedLocation fCurrentSegment;

    private void store(int n) {
        this.growData();
        while (n > 127) {
            this.fData[this.fDataSize++] = (byte)(0x80 | n & 0x7F);
            n >>= 7;
        }
        this.fData[this.fDataSize++] = (byte)n;
    }

    private int load(int n, int[] nArray) {
        byte by;
        int n2 = 0;
        int n3 = 0;
        while ((by = this.fData[n]) < 0) {
            n3 |= (by & 0x7F) << n2;
            n2 += 7;
            ++n;
        }
        nArray[0] = n3 |= (by & 0x7F) << n2;
        return n + 1;
    }

    private void growData() {
        if (this.fDataSize + 4 >= this.fData.length) {
            byte[] byArray = new byte[this.fData.length * 2];
            System.arraycopy(this.fData, 0, byArray, 0, this.fData.length);
            this.fData = byArray;
        }
    }

    public void pushEntity(Location location, char[] cArray) {
        BufferedLocation bufferedLocation = new BufferedLocation(location, cArray);
        BufferedLocation bufferedLocation2 = (BufferedLocation)this.fBufferedLocations.get(bufferedLocation);
        if (bufferedLocation2 == null) {
            bufferedLocation2 = bufferedLocation;
            this.fBufferedLocations.put(bufferedLocation2, bufferedLocation2);
        }
        this.pushEntity(bufferedLocation2);
    }

    public void pushEntity(BufferedLocation bufferedLocation) {
        if (bufferedLocation == null) {
            throw new IllegalArgumentException("entity may not be null");
        }
        this.addSegment(bufferedLocation);
        this.fStack.addLast(bufferedLocation);
    }

    public void popEntity() {
        this.fStack.removeLast();
        if (this.fStack.size() > 0) {
            this.addSegment((BufferedLocation)this.fStack.getLast());
        }
    }

    public int addSymbol(int n, int n2) {
        if (this.fCurrentSegment == null) {
            throw new IllegalStateException("No current entity");
        }
        int n3 = this.fCurrentSegment.getLocation().getOffset();
        int n4 = this.fCurrentSegment.getLocation().getLength();
        int n5 = n3 + n4;
        if (n < n3) {
            throw new IllegalArgumentException("Offset (" + n + ") < " + n3);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Length (" + n2 + ") < 0");
        }
        if (n + n2 > n5) {
            throw new IllegalArgumentException("Offset + length (" + (n + n2) + ") > " + n5);
        }
        int n6 = this.append(new String(this.fCurrentSegment.getBuf(), n, n2));
        int n7 = this.fDataSize;
        this.store(n6);
        this.store(n2);
        this.store(n);
        ++this.fSize;
        return n7;
    }

    public int getSize() {
        return this.fSize;
    }

    private int append(String string) {
        int n = this.fStringSize;
        int n2 = string.length();
        if (this.fStringSize + n2 >= this.fStrings.length) {
            int n3 = Math.max(this.fStrings.length * 2, this.fStringSize + n2);
            char[] cArray = new char[n3];
            System.arraycopy(this.fStrings, 0, cArray, 0, this.fStringSize);
            this.fStrings = cArray;
        }
        string.getChars(0, n2, this.fStrings, this.fStringSize);
        this.fStringSize += n2;
        return n;
    }

    public String getSymbol(int n) {
        if (n < 0) {
            return null;
        }
        int[] nArray = new int[1];
        n = this.load(n, nArray);
        int n2 = nArray[0];
        this.load(n, nArray);
        int n3 = nArray[0];
        return new String(this.fStrings, n2, n3);
    }

    public Location getParentLocation(int n) {
        Location location = this.findSegmentLocation(n);
        if (location == null) {
            throw new IllegalArgumentException("No text segment corresponding to index " + n);
        }
        return location;
    }

    public Iterator getEntities() {
        return new ImmutableIterator(this.fBufferedLocations.values().iterator());
    }

    private void addSegment(BufferedLocation bufferedLocation) {
        if (this.fSegmentSize > 0 && this.fSegmentIndices[this.fSegmentSize - 1] == this.fDataSize) {
            --this.fSegmentSize;
        }
        if (this.fSegmentSize == this.fSegmentIndices.length) {
            int[] nArray = new int[this.fSegmentSize * 2];
            System.arraycopy(this.fSegmentIndices, 0, nArray, 0, this.fSegmentSize);
            this.fSegmentIndices = nArray;
            Location[] locationArray = new Location[this.fSegmentSize * 2];
            System.arraycopy(this.fSegmentLocations, 0, locationArray, 0, this.fSegmentSize);
            this.fSegmentLocations = locationArray;
        }
        this.fSegmentIndices[this.fSegmentSize] = this.fDataSize;
        this.fSegmentLocations[this.fSegmentSize++] = bufferedLocation.getLocation();
        this.fCurrentSegment = bufferedLocation;
    }

    private Location findSegmentLocation(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.fSegmentSize - 1;
        while (n3 < n4) {
            n2 = n3 + n4 >> 1;
            int n5 = this.fSegmentIndices[n2];
            if (n5 < n) {
                n3 = n2 + 1;
                continue;
            }
            if (n5 > n) {
                n4 = n2 - 1;
                continue;
            }
            n3 = n2;
            break;
        }
        n2 = Math.min(n3, this.fSegmentSize - 1);
        if (n2 >= 0) {
            return this.fSegmentLocations[n2];
        }
        return null;
    }

    public Location getLocation(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n;
        int[] nArray = new int[1];
        n2 = this.load(n2, nArray);
        int n3 = nArray[0];
        n2 = this.load(n2, nArray);
        int n4 = nArray[0];
        this.load(n2, nArray);
        return new Location(new String(this.fStrings, n3, n4), nArray[0], n4, this.getParentLocation(n));
    }

    public int getOffset(int n) {
        if (n < 0) {
            return 0;
        }
        int[] nArray = new int[1];
        n = this.load(n, nArray);
        n = this.load(n, nArray);
        this.load(n, nArray);
        return nArray[0];
    }

    public int getLength(int n) {
        if (n < 0) {
            return 0;
        }
        int[] nArray = new int[1];
        n = this.load(n, nArray);
        this.load(n, nArray);
        return nArray[0];
    }

    public void pack() {
        Object[] objectArray = new char[this.fStringSize];
        System.arraycopy(this.fStrings, 0, objectArray, 0, this.fStringSize);
        this.fStrings = objectArray;
        objectArray = new byte[this.fDataSize];
        System.arraycopy(this.fData, 0, objectArray, 0, this.fDataSize);
        this.fData = (byte[])objectArray;
        objectArray = new int[this.fSegmentSize];
        System.arraycopy(this.fSegmentIndices, 0, objectArray, 0, this.fSegmentSize);
        this.fSegmentIndices = objectArray;
        Location[] locationArray = new Location[this.fSegmentSize];
        System.arraycopy(this.fSegmentLocations, 0, locationArray, 0, this.fSegmentSize);
        this.fSegmentLocations = locationArray;
        this.fBufferedLocations = new HashMap(0);
    }

    private static class BufferedLocation {
        private Location location;
        private char[] buf;

        public BufferedLocation(Location location, char[] cArray) {
            this.location = location;
            this.buf = cArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BufferedLocation)) {
                return false;
            }
            BufferedLocation bufferedLocation = (BufferedLocation)object;
            return this.location.equals(bufferedLocation.location) && this.buf.equals(bufferedLocation.buf);
        }

        public int hashCode() {
            return this.location.hashCode() + this.buf.hashCode();
        }

        public char[] getBuf() {
            return this.buf;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

