/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.Misc;

public class TabCalculator {
    private int tabWidth;
    private String tab;
    private boolean spacesForTabs;

    public TabCalculator(int n, boolean bl) {
        this.tabWidth = n;
        this.spacesForTabs = bl;
        this.tab = bl ? Misc.newString(' ', n) : "\t";
    }

    public String[] calculateIndentPrefixes() {
        if (this.spacesForTabs) {
            return new String[]{this.tab, ""};
        }
        return new String[]{"\t", this.tab, ""};
    }

    public String tabIn(String string) {
        int n = this.countLeadingWhitespace(string);
        n = this.tabIn(n);
        String string2 = this.countToString(n);
        return string2;
    }

    public String insertTab(String string) {
        int[] nArray = new int[2];
        this.countLeadingWhitespace(string, nArray);
        int n = this.tabIn(nArray[0]);
        String string2 = String.valueOf(this.countToString(n)) + string.substring(nArray[1], string.length());
        return string2;
    }

    public String tabInWhole(String string) {
        int n = this.countWholeLine(string);
        n = this.tabIn(n);
        String string2 = this.countToString(n);
        return string2;
    }

    public String tabOut(String string) {
        int n = this.countLeadingWhitespace(string);
        n = this.tabOut(n);
        String string2 = this.countToString(n);
        return string2;
    }

    public String normalize(String string) {
        int[] nArray = new int[2];
        this.countLeadingWhitespace(string, nArray);
        String string2 = String.valueOf(this.countToString(nArray[0])) + string.substring(nArray[1], string.length());
        return string2;
    }

    public String normalizeLeadingWhitespace(String string) {
        int n = this.countLeadingWhitespace(string);
        return this.countToString(n);
    }

    public int countLeadingWhitespace(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == ' ') {
                ++n;
            } else {
                if (c != '\t') break;
                n += this.tabWidth;
            }
            ++n2;
        }
        return n;
    }

    public void countLeadingWhitespace(String string, int[] nArray) {
        this.countLeadingWhitespace(string, 0, nArray);
    }

    public void countLeadingWhitespace(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == ' ') {
                ++n2;
            } else {
                if (c != '\t') break;
                n2 += this.tabWidth;
            }
            ++n3;
        }
        nArray[0] = n2;
        nArray[1] = n3;
    }

    public int countWholeLine(String string) {
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == ' ') {
                ++n;
            } else if (c == '\t' && bl) {
                n += this.tabWidth;
            } else {
                if (c == '\r' || c == '\n') break;
                ++n;
                bl = false;
            }
            ++n2;
        }
        return n;
    }

    public int nextTabStop(int n) {
        return (n + this.tabWidth - 1) / this.tabWidth * this.tabWidth;
    }

    public int tabIn(int n) {
        return n + this.tabWidth;
    }

    public int tabOut(int n) {
        return Math.max(n - this.tabWidth, 0);
    }

    public String countToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n >= this.tabWidth) {
            stringBuffer.append(this.tab);
            n -= this.tabWidth;
        }
        while (n > 0) {
            stringBuffer.append(' ');
            --n;
        }
        return stringBuffer.toString();
    }

    public int countLeadingWhitespace(char[] cArray, int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (c == ' ') {
                ++n2;
            } else {
                if (c != '\t') break;
                n2 += this.tabWidth;
            }
            ++n3;
        }
        return n2;
    }

    public void countLeadingWhitespace(char[] cArray, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (c == ' ') {
                ++n2;
            } else {
                if (c != '\t') break;
                n2 += this.tabWidth;
            }
            ++n3;
        }
        nArray[0] = n2;
        nArray[1] = n3;
    }

    /*
     * Unable to fully structure code
     */
    public int computeMinShiftCount(char[] var1_1) {
        var2_2 = this.tabWidth;
        var3_3 = 0;
        var4_4 = var1_1.length;
        var5_5 = '\u0000';
        while (var3_3 < var4_4) {
            var6_6 = this.countLeadingWhitespace(var1_1, var3_3);
            if (var2_2 > var6_6) {
                var2_2 = var6_6;
            }
            if (var2_2 != 0) ** GOTO lbl12
            break;
lbl-1000:
            // 1 sources

            {
                ++var3_3;
lbl12:
                // 2 sources

                ** while (var3_3 < var4_4 && (var5_5 = var1_1[var3_3]) != '\r' && var5_5 != '\n')
            }
lbl13:
            // 1 sources

            if (var3_3 >= var4_4) continue;
            if (var5_5 == '\r' && var3_3 + 1 < var4_4 && var1_1[var3_3 + 1] == '\n') {
                ++var3_3;
            }
            ++var3_3;
        }
        return var2_2;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public String getTab() {
        return this.tab;
    }

    public boolean getSpacesForTabs() {
        return this.spacesForTabs;
    }

    public int roundUp(int n) {
        return (n + this.tabWidth - 1) / this.tabWidth * this.tabWidth;
    }
}

