/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util.config;

import com.objfac.util.config.Messages;
import com.objfac.util.config.event.ErrorHandler;
import com.objfac.util.config.event.EventCharSequence;
import com.objfac.util.config.event.EventHandler;
import com.objfac.util.config.event.EventHandlerWrapper;
import java.text.MessageFormat;
import java.util.LinkedList;

public class CheckParameterNesting
extends EventHandlerWrapper {
    private LinkedList stack = new LinkedList();
    private ErrorHandler errorHandler;

    public CheckParameterNesting(EventHandler eventHandler, ErrorHandler errorHandler) {
        super(eventHandler);
        this.errorHandler = errorHandler;
    }

    public void beginCompoundParameter(EventCharSequence eventCharSequence) {
        this.push(eventCharSequence.toString());
        super.beginCompoundParameter(eventCharSequence);
    }

    public void endCompoundParameter(EventCharSequence eventCharSequence) {
        String string = eventCharSequence.toString();
        if (!string.equals(this.top())) {
            this.errorHandler.error(3, 5, MessageFormat.format(Messages.endDoesntMatch, string, this.top()));
        } else {
            this.pop();
            super.endCompoundParameter(eventCharSequence);
        }
    }

    public void endDocument() {
        while (this.stack.size() > 0) {
            String string = this.pop();
            this.errorHandler.error(3, 4, MessageFormat.format(Messages.missingEndParameter, string));
        }
        super.endDocument();
    }

    private void push(String string) {
        this.stack.addLast(string);
    }

    private String pop() {
        if (this.stack.size() > 0) {
            return (String)this.stack.removeLast();
        }
        return null;
    }

    private String top() {
        if (this.stack.size() > 0) {
            return (String)this.stack.getLast();
        }
        return null;
    }
}

