/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util.config;

import com.objfac.util.config.AbstractLookaheadIterator;
import com.objfac.util.config.LookaheadIterator;
import com.objfac.util.config.Messages;
import com.objfac.util.config.Node;
import com.objfac.util.config.POMDocument;
import com.objfac.util.config.POMHandler;
import com.objfac.util.config.Typed;
import com.objfac.util.config.Virtual;
import com.objfac.util.config.VirtualText;
import java.util.NoSuchElementException;

public class VirtualNode
implements Typed,
Virtual,
Node {
    private int offset;
    private char[] buf;
    private int afterOffset;
    static final Children NO_CHILDREN = new Children(null);

    public boolean becomeFirstNode(POMDocument pOMDocument) {
        char[] cArray = (char[])pOMDocument.getContents();
        if (cArray != null) {
            this.become(0, cArray);
            return true;
        }
        return false;
    }

    public boolean becomeFirstParameter(POMDocument pOMDocument) {
        return this.becomeFirstNode(pOMDocument) && (this.isSimple() || this.isCompound() || this.becomeNextParameter());
    }

    public void become(VirtualNode virtualNode) {
        virtualNode.checkBuf();
        if (virtualNode != this) {
            this.become(virtualNode.offset, virtualNode.buf);
        }
    }

    public boolean hasBecome() {
        return this.buf != null;
    }

    public void become(int n, char[] cArray) {
        this.offset = n;
        this.buf = cArray;
        this.afterOffset = 0;
    }

    private int getType(int n) {
        return VirtualNode.getType(n, this.buf);
    }

    private static int getType(int n, char[] cArray) {
        int n2 = cArray[n] <= '\ufff8' ? 1 : POMHandler.decodedType(cArray[n]);
        return n2;
    }

    private void checkBuf() {
        if (this.buf == null) {
            throw new IllegalStateException(Messages.nodeNotBecome);
        }
    }

    public boolean getId(VirtualText virtualText) {
        int n = this.getType();
        if (n == 2 || n == 3 || n == 4) {
            virtualText.become(this.offset + 1, this.buf);
            return true;
        }
        return false;
    }

    public boolean equalsId(CharSequence charSequence) {
        int n;
        int n2 = this.getType();
        if ((n2 == 2 || n2 == 3 || n2 == 4) && (n = charSequence.length()) == VirtualText.getLength(this.buf, this.offset + 1)) {
            int n3 = 0;
            while (n3 < n) {
                if (charSequence.charAt(n3) != VirtualText.charAt(n3, this.buf, this.offset + 1)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public boolean getText(VirtualText virtualText) {
        int n = this.getType();
        if (n == 1) {
            virtualText.become(this.offset, this.buf);
        } else if (n == 2 || n == 5) {
            if (n == 5) {
                virtualText.become(this.offset + 1, this.buf);
            } else {
                this.getId(virtualText);
                virtualText.become(virtualText.getAfterOffset(), this.buf);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean becomeNextSibling() {
        return this.becomeNextSibling(this);
    }

    public boolean becomeNextSibling(VirtualNode virtualNode) {
        virtualNode.checkBuf();
        return this.maybeBecome(virtualNode, virtualNode.getAfterOffset());
    }

    public boolean becomeNextParameter() {
        this.checkBuf();
        int n = VirtualNode.findNextParameter(this);
        if (n > 0) {
            this.become(n, this.buf);
            return true;
        }
        return false;
    }

    public boolean becomeNextParameter(VirtualNode virtualNode) {
        virtualNode.checkBuf();
        int n = VirtualNode.findNextParameter(virtualNode);
        if (n > 0) {
            this.become(n, virtualNode.buf);
            return true;
        }
        return false;
    }

    private static int findNextParameter(VirtualNode virtualNode) {
        return VirtualNode.findNextParameter(virtualNode.offset, virtualNode.buf);
    }

    private static int findNextParameter(int n, char[] cArray) {
        int n2 = VirtualNode.getAfterOffset(n, cArray);
        if (n2 > 0) {
            n2 = VirtualNode.findFirstParameter(n2, cArray);
        }
        return n2;
    }

    private static int findFirstParameter(int n, char[] cArray) {
        int n2 = n;
        int n3 = 0;
        while (n2 > 0 && ((n3 = VirtualNode.getType(n2, cArray)) == 5 || n3 == 1)) {
            n2 = VirtualNode.getAfterOffset(n2, cArray);
        }
        return n3 == 2 || n3 == 3 || n3 == 4 ? n2 : 0;
    }

    private int getAfterOffset() {
        if (this.afterOffset == 0) {
            this.afterOffset = VirtualNode.getAfterOffset(this.offset, this.buf);
        }
        return this.afterOffset;
    }

    private static int getAfterOffset(int n, char[] cArray) {
        int n2 = 0;
        int n3 = VirtualNode.getType(n, cArray);
        if (n3 == 3 || n3 == 4) {
            char c = cArray[n + 1];
            int n4 = n + 2 + c;
            n2 = POMHandler.decodeInt(cArray, n4);
        } else if (n3 == 5) {
            n2 = VirtualText.getAfterOffset(cArray, n + 1);
        } else if (n3 == 2) {
            char c = cArray[n + 1];
            int n5 = n + 2 + c;
            n2 = VirtualText.getAfterOffset(cArray, n5);
        } else if (n3 == 1) {
            n2 = VirtualText.getAfterOffset(cArray, n);
        }
        return n2;
    }

    public boolean becomeFirstChild() {
        return this.becomeFirstChild(this);
    }

    public boolean becomeFirstChild(VirtualNode virtualNode) {
        virtualNode.checkBuf();
        int n = virtualNode.getType();
        if (n == 3 || n == 4) {
            char c = virtualNode.buf[virtualNode.offset + 1];
            int n2 = virtualNode.offset + 2 + c + 2;
            return this.maybeBecome(virtualNode, n2);
        }
        return false;
    }

    public boolean becomeFirstParameter() {
        return this.becomeFirstParameter(this);
    }

    public boolean becomeFirstParameter(VirtualNode virtualNode) {
        virtualNode.checkBuf();
        int n = VirtualNode.getChildOffset(virtualNode.offset, virtualNode.buf);
        if (n > 0 && (n = VirtualNode.findFirstParameter(n, virtualNode.buf)) > 0) {
            this.become(n, virtualNode.buf);
            return true;
        }
        return false;
    }

    private static int getChildOffset(int n, char[] cArray) {
        int n2 = VirtualNode.getType(n, cArray);
        if (n2 == 3 || n2 == 4) {
            char c = cArray[n + 1];
            return n + 2 + c + 2;
        }
        return 0;
    }

    private boolean maybeBecome(VirtualNode virtualNode, int n) {
        int n2;
        if (n != virtualNode.buf.length && (n2 = VirtualNode.getType(n, virtualNode.buf)) != 0 && n2 != 6) {
            this.become(n, virtualNode.buf);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        this.checkBuf();
        if (!(object instanceof VirtualNode)) {
            return false;
        }
        VirtualNode virtualNode = (VirtualNode)object;
        virtualNode.checkBuf();
        return this.buf == virtualNode.buf && this.offset == virtualNode.offset;
    }

    public int hashCode() {
        this.checkBuf();
        return this.buf.hashCode() + this.offset;
    }

    public boolean isText() {
        this.checkBuf();
        return this.getType() == 1;
    }

    public boolean isSimple() {
        this.checkBuf();
        return this.getType() == 2;
    }

    public boolean isCompound() {
        this.checkBuf();
        int n = this.getType();
        return n == 3 || n == 4;
    }

    public boolean isComment() {
        this.checkBuf();
        return this.getType() == 5;
    }

    public boolean isSection() {
        this.checkBuf();
        return this.getType() == 4;
    }

    public String getId() {
        VirtualText virtualText = new VirtualText();
        if (this.getId(virtualText)) {
            return virtualText.toString();
        }
        return null;
    }

    public String getText() {
        VirtualText virtualText = new VirtualText();
        if (this.getText(virtualText)) {
            return virtualText.toString();
        }
        return null;
    }

    public String getTrimText() {
        VirtualText virtualText = new VirtualText();
        if (this.getText(virtualText)) {
            virtualText.trim();
            return virtualText.toString();
        }
        return null;
    }

    public String getNormalizedText() {
        VirtualText virtualText = new VirtualText();
        if (this.getText(virtualText)) {
            virtualText.normalize();
            return virtualText.toString();
        }
        return null;
    }

    public LookaheadIterator getChildren() {
        VirtualNode virtualNode = new VirtualNode();
        if (virtualNode.becomeFirstParameter(this)) {
            return new Children(virtualNode);
        }
        return NO_CHILDREN;
    }

    public int getType() {
        this.checkBuf();
        return VirtualNode.getType(this.offset, this.buf);
    }

    static class Children
    extends AbstractLookaheadIterator {
        VirtualNode next;
        boolean seen;

        public Children(VirtualNode virtualNode) {
            this.next = virtualNode;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            VirtualNode virtualNode = this.next;
            this.next = new VirtualNode();
            if (!this.next.becomeNextSibling(virtualNode)) {
                this.next = null;
            }
            return virtualNode;
        }

        public Object peek() {
            return this.next;
        }
    }
}

