/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.GradientCanvas;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class ServiceMessageControl {
    private static final String NOTIFICATIONS_PREF_PAGE = "org.eclipse.mylyn.commons.notifications.preferencePages.Notifications";
    private static FormColors formColors;
    private ImageHyperlink closeLink;
    private ImageHyperlink configureLink;
    private Link descriptionLabel;
    private GradientCanvas head;
    private GridData headData;
    private Label imageLabel;
    private final Composite parent;
    private Label titleLabel;
    private String eventId;
    private String preferencesPageId;

    protected static Font setHeaderFontSizeAndStyle(Control text) {
        FontData[] fontData;
        float sizeFactor = 1.2f;
        Font initialFont = text.getFont();
        FontData[] fontDataArray = fontData = initialFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setHeight((int)((float)element.getHeight() * sizeFactor));
            element.setStyle(element.getStyle() | 1);
            ++n2;
        }
        final Font textFont = new Font((Device)text.getDisplay(), fontData);
        text.setFont(textFont);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                textFont.dispose();
            }
        });
        Color color = ServiceMessageControl.getFormColors(text.getDisplay()).getColor("org.eclipse.ui.forms.TITLE");
        text.setForeground(color);
        return textFont;
    }

    public static FormColors getFormColors(Display display) {
        if (formColors == null) {
            formColors = new FormColors(display);
            formColors.markShared();
        }
        return formColors;
    }

    public ServiceMessageControl(Composite parent) {
        this.parent = parent;
        this.setPreferencesPageId(NOTIFICATIONS_PREF_PAGE);
    }

    public String getPreferencesPageId() {
        return this.preferencesPageId;
    }

    public void setPreferencesPageId(String preferencesPageId) {
        this.preferencesPageId = preferencesPageId;
    }

    protected void close() {
        if (this.head != null && !this.head.isDisposed()) {
            this.head.dispose();
        }
        if (!this.parent.isDisposed()) {
            this.parent.layout(true);
        }
    }

    protected boolean isClosed() {
        return this.head == null || this.head.isDisposed();
    }

    protected abstract void closeMessage();

    protected Shell getShell() {
        return this.parent.getShell();
    }

    public Control createControl(Composite parent) {
        FormColors colors = ServiceMessageControl.getFormColors(parent.getDisplay());
        this.head = new GradientCanvas(parent, 0);
        GridLayout headLayout = new GridLayout();
        headLayout.marginHeight = 0;
        headLayout.marginWidth = 0;
        headLayout.horizontalSpacing = 0;
        headLayout.verticalSpacing = 0;
        headLayout.numColumns = 1;
        this.head.setLayout((Layout)headLayout);
        this.headData = new GridData(4, 128, true, false);
        this.head.setLayoutData(this.headData);
        Color top = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color bot = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        this.head.setBackgroundGradient(new Color[]{bot, top}, new int[]{100}, true);
        this.head.setSeparatorVisible(true);
        this.head.setSeparatorAlignment(128);
        this.head.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", colors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        this.head.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", colors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
        this.head.putColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT", colors.getColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT"));
        this.head.putColor("org.eclipse.ui.forms.H_H_HOVER_FULL", colors.getColor("org.eclipse.ui.forms.H_H_HOVER_FULL"));
        this.head.putColor("org.eclipse.ui.forms.TB_TOGGLE", colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.head.putColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER", colors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        this.head.setLayout((Layout)layout);
        this.imageLabel = new Label((Composite)this.head, 0);
        this.titleLabel = new Label((Composite)this.head, 0);
        ServiceMessageControl.setHeaderFontSizeAndStyle((Control)this.titleLabel);
        Composite buttonsComp = new Composite((Composite)this.head, 0);
        TableWrapData data = new TableWrapData();
        data.align = 8;
        buttonsComp.setLayoutData((Object)data);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.horizontalSpacing = 0;
        gLayout.verticalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.verticalSpacing = 0;
        buttonsComp.setLayout((Layout)gLayout);
        if (this.getPreferencesPageId() != null) {
            this.configureLink = new ImageHyperlink(buttonsComp, 0);
            this.configureLink.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CONFIGURE));
            this.configureLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkEntered(HyperlinkEvent e) {
                    ServiceMessageControl.this.configureLink.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CONFIGURE_HOVER));
                }

                public void linkExited(HyperlinkEvent e) {
                    ServiceMessageControl.this.configureLink.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CONFIGURE));
                }

                public void linkActivated(HyperlinkEvent e) {
                    PreferenceDialog pd = PreferencesUtil.createPreferenceDialogOn((Shell)ServiceMessageControl.this.getShell(), (String)ServiceMessageControl.this.getPreferencesPageId(), (String[])new String[0], (Object)ServiceMessageControl.this.eventId);
                    if (pd != null) {
                        pd.open();
                    }
                }
            });
            this.configureLink.setVisible(this.eventId != null);
        }
        this.closeLink = new ImageHyperlink(buttonsComp, 0);
        this.closeLink.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CLOSE));
        this.closeLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ServiceMessageControl.this.closeMessage();
            }

            public void linkEntered(HyperlinkEvent e) {
                ServiceMessageControl.this.closeLink.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CLOSE_HOVER));
            }

            public void linkExited(HyperlinkEvent e) {
                ServiceMessageControl.this.closeLink.setImage(CommonImages.getImage(CommonImages.NOTIFICATION_CLOSE));
            }
        });
        new Label((Composite)this.head, 0).setText(" ");
        this.descriptionLabel = new Link((Composite)this.head, 64);
        this.descriptionLabel.addSelectionListener(this.getLinkListener());
        data = new TableWrapData();
        data.colspan = 2;
        data.grabHorizontal = true;
        this.descriptionLabel.setLayoutData((Object)data);
        return this.head;
    }

    protected abstract SelectionListener getLinkListener();

    protected void setDescription(String description) {
        this.descriptionLabel.setText(description);
        this.parent.layout(true, true);
    }

    protected void setTitle(String title) {
        this.titleLabel.setText(title);
        this.head.layout(true);
    }

    protected void setEventId(String eventId) {
        this.eventId = eventId;
        if (this.configureLink != null) {
            this.configureLink.setVisible(eventId != null);
        }
    }

    protected void setTitleImage(Image image) {
        this.imageLabel.setImage(image);
        this.head.layout(true);
    }

    protected boolean ensureControl() {
        if (this.parent.isDisposed()) {
            return false;
        }
        if (this.head == null || this.head.isDisposed()) {
            this.createControl(this.parent);
        }
        return true;
    }
}

