/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.iso_relax.ant.ErrorHandlerImpl;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.SAXException;

public class JARVTask
extends Task {
    private File schemaFile;
    private String schemaLanguage;
    private File xmlFile;
    private List xmlFiles = new ArrayList();

    public void setSchema(String string) {
        this.schemaFile = this.project.resolveFile(string);
    }

    public void setSchemaLanguage(String string) {
        this.schemaLanguage = string;
    }

    public void setFile(File file) {
        this.xmlFile = file;
    }

    public void addFileset(FileSet fileSet) {
        this.xmlFiles.add(fileSet);
    }

    public void execute() throws BuildException {
        try {
            Verifier verifier;
            VerifierFactory verifierFactory;
            if (this.schemaLanguage == null) {
                throw new BuildException("schema language needs to be specified through the schemaLanguage attribute", this.location);
            }
            if (this.schemaFile == null) {
                throw new BuildException("schema file needs to be specified through the schema attribute", this.location);
            }
            try {
                verifierFactory = VerifierFactory.newInstance(this.schemaLanguage, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (VerifierConfigurationException verifierConfigurationException) {
                throw new BuildException("unable to load a validator for the schema language: " + this.schemaLanguage, (Throwable)verifierConfigurationException, this.location);
            }
            ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl(this);
            try {
                verifier = verifierFactory.newVerifier(this.schemaFile);
                verifier.setErrorHandler(errorHandlerImpl);
            }
            catch (VerifierConfigurationException verifierConfigurationException) {
                throw new BuildException("failed to compile the schema:" + verifierConfigurationException.getMessage(), (Throwable)verifierConfigurationException, this.location);
            }
            boolean bl = true;
            if (this.xmlFile != null) {
                this.log("validating " + this.xmlFile, 2);
                bl |= verifier.verify(this.xmlFile);
            }
            int n = 0;
            while (n < this.xmlFiles.size()) {
                FileSet fileSet = (FileSet)this.xmlFiles.get(n);
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
                File file = fileSet.getDir(this.project);
                String[] stringArray = directoryScanner.getIncludedFiles();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    File file2 = new File(file, stringArray[n2]);
                    this.log("validating " + file2, 2);
                    bl |= verifier.verify(file2);
                    ++n2;
                }
                ++n;
            }
            if (errorHandlerImpl.hadError) {
                bl = false;
            }
            if (!bl) {
                throw new BuildException("validation error. the error message should have been provided");
            }
        }
        catch (SAXException sAXException) {
            throw new BuildException((Throwable)sAXException, this.location);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException, this.location);
        }
    }
}

