/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.ant_task;

import java.io.File;
import java.util.Map;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.graphics.Image;
import org.insightech.er.Activator;
import org.insightech.er.ant_task.ERMasterAntTaskBase;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.html.ExportToHtmlManager;
import org.insightech.er.editor.model.dbexport.image.ExportToImageManager;
import org.insightech.er.editor.view.action.dbexport.ExportToHtmlAction;
import org.insightech.er.editor.view.action.dbexport.ExportToImageAction;
import org.insightech.er.util.io.FileUtils;

public class HtmlReportAntTask
extends ERMasterAntTaskBase {
    private String outputDir;

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void doTask(ERDiagram diagram) throws Exception {
        this.outputDir = this.getAbsolutePath(this.outputDir);
        this.outputDir = String.valueOf(this.outputDir) + "/dbdocs/";
        this.log("Output to : " + this.outputDir);
        File dir = new File(this.outputDir);
        FileUtils.deleteDirectory((File)dir);
        dir = new File(String.valueOf(this.outputDir) + "image");
        dir.mkdirs();
        String outputImageFilePath = String.valueOf(this.outputDir) + "image/er.png";
        this.log("Output image to : " + outputImageFilePath);
        Image img = null;
        GraphicalViewer viewer = null;
        try {
            viewer = Activator.createGraphicalViewer((ERDiagram)diagram);
            int format = ExportToImageAction.getFormatType((String)outputImageFilePath);
            img = Activator.createImage((GraphicalViewer)viewer);
            ExportToImageManager exportToImageManager = new ExportToImageManager(img, format, outputImageFilePath);
            exportToImageManager.doProcess();
            Map tableLocationMap = ExportToHtmlAction.getTableLocationMap((GraphicalViewer)viewer, (ERDiagram)diagram);
            ExportToHtmlManager reportManager = new ExportToHtmlManager(this.outputDir, diagram, tableLocationMap);
            this.log("Output html beginning...");
            reportManager.doProcess();
        }
        finally {
            if (viewer != null) {
                viewer.getContents().deactivate();
            }
            if (img != null) {
                img.dispose();
            }
        }
    }

    @Override
    protected void logUsage() {
        this.log("<ermaster.htmlReport> have these attributes. (the attribute with '*' must be set.) ");
        this.log("    * diagramFile - The path of the input .erm file.");
        this.log("      outputDir   - The path of the output directory.");
        this.log("                    The directory named 'dbdocs' is made under this directory.");
        this.log("                    When not specified, the project base directory is used.");
    }
}

