/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.Messages;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;

public class ApiModelFactory {
    private static final String CVS_FOLDER_NAME = "CVS";
    public static final IApiComponent[] NO_COMPONENTS = new IApiComponent[0];
    private static CVSNameFilter fgCvsFilter = new CVSNameFilter();
    private static long fNextId = 0L;
    static /* synthetic */ Class class$0;

    private static long getBundleID() {
        return fNextId++;
    }

    public static IApiComponent newApiComponent(IApiBaseline baseline, String location) throws CoreException {
        BundleComponent component = new BundleComponent(baseline, location, ApiModelFactory.getBundleID());
        if (component.isValidBundle()) {
            return component;
        }
        return null;
    }

    public static IApiComponent newApiComponent(IApiBaseline baseline, IPluginModelBase model) throws CoreException {
        BundleDescription bundleDescription = model.getBundleDescription();
        if (bundleDescription == null) {
            return null;
        }
        String location = bundleDescription.getLocation();
        if (location == null) {
            return null;
        }
        BundleComponent component = null;
        component = ApiModelFactory.isBinaryProject(location) ? new BundleComponent(baseline, location, ApiModelFactory.getBundleID()) : new ProjectComponent(baseline, location, model, ApiModelFactory.getBundleID());
        if (component.isValidBundle()) {
            return component;
        }
        return null;
    }

    private static boolean isBinaryProject(String location) throws CoreException {
        Path path = new Path(location);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        return project != null && (!project.exists() || Util.isBinaryProject(project));
    }

    public static IApiBaseline newApiBaseline(String name) {
        return new ApiBaseline(name);
    }

    public static IApiBaseline newApiBaseline(String name, File eeDescription) throws CoreException {
        return new ApiBaseline(name, eeDescription);
    }

    public static IApiBaseline newApiBaseline(String name, String location) throws CoreException {
        return new ApiBaseline(name, null, location);
    }

    public static IApiBaseline newApiBaseline(String name, File eeDescription, String location) throws CoreException {
        return new ApiBaseline(name, eeDescription, location);
    }

    public static IApiComponent[] addComponents(IApiBaseline baseline, String installLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.configuring_baseline, (int)50);
        IApiComponent[] result = null;
        try {
            ITargetPlatformService service = null;
            ApiPlugin plugin = ApiPlugin.getDefault();
            if (plugin != null) {
                ApiPlugin apiPlugin = ApiPlugin.getDefault();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                service = (ITargetPlatformService)apiPlugin.acquireService(clazz.getName());
                Util.updateMonitor((IProgressMonitor)subMonitor, 1);
                IBundleContainer container = service.newProfileContainer(installLocation, null);
                ITargetDefinition definition = service.newTarget();
                subMonitor.subTask(Messages.resolving_target_definition);
                container.resolve(definition, (IProgressMonitor)subMonitor.newChild(30));
                Util.updateMonitor((IProgressMonitor)subMonitor, 1);
                IResolvedBundle[] bundles = container.getBundles();
                ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
                if (bundles.length > 0) {
                    subMonitor.setWorkRemaining(bundles.length);
                    int i = 0;
                    while (i < bundles.length) {
                        IApiComponent component;
                        Util.updateMonitor((IProgressMonitor)subMonitor, 1);
                        if (!bundles[i].isSourceBundle() && (component = ApiModelFactory.newApiComponent(baseline, URIUtil.toFile((URI)bundles[i].getBundleInfo().getLocation()).getAbsolutePath())) != null) {
                            subMonitor.subTask(NLS.bind((String)Messages.adding_component__0, (Object)component.getSymbolicName()));
                            components.add(component);
                        }
                        ++i;
                    }
                }
                result = components.toArray(new IApiComponent[components.size()]);
            } else {
                File dir = new File(installLocation);
                if (dir.exists()) {
                    File[] files = dir.listFiles(fgCvsFilter);
                    if (files == null) {
                        IApiComponent[] iApiComponentArray = NO_COMPONENTS;
                        return iApiComponentArray;
                    }
                    ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
                    int i = 0;
                    while (i < files.length) {
                        File bundle = files[i];
                        IApiComponent component = ApiModelFactory.newApiComponent(baseline, bundle.getAbsolutePath());
                        if (component != null) {
                            components.add(component);
                        }
                        ++i;
                    }
                    result = components.toArray(new IApiComponent[components.size()]);
                }
            }
            if (result != null) {
                baseline.addApiComponents(result);
                IApiComponent[] iApiComponentArray = result;
                return iApiComponentArray;
            }
            IApiComponent[] iApiComponentArray = NO_COMPONENTS;
            return iApiComponentArray;
        }
        finally {
            subMonitor.done();
        }
    }

    static class CVSNameFilter
    implements FilenameFilter {
        CVSNameFilter() {
        }

        public boolean accept(File dir, String name) {
            return !name.equalsIgnoreCase(ApiModelFactory.CVS_FOLDER_NAME);
        }
    }
}

