/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.editors.ProjectListElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;

public class VMLauncherUtility {
    public static ILaunch ILAUNCH = null;

    public static IVMInstall getVMInstall() {
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            IVMInstall[] vms = vmTypes[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                if (vms[j].getId().equals(TomcatLauncherPlugin.getDefault().getTomcatJRE())) {
                    return vms[j];
                }
                ++j;
            }
            ++i;
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static void runVM(String label, String classToLaunch, String[] classpath, String[] bootClasspath, String vmArgs, String prgArgs, boolean debug, boolean showInDebugger, boolean saveConfig) throws CoreException {
        String mode = "";
        mode = debug ? "debug" : "run";
        ILaunchConfigurationWorkingCopy config = VMLauncherUtility.createConfig(label, classToLaunch, classpath, bootClasspath, vmArgs, prgArgs, debug, showInDebugger, saveConfig);
        ILAUNCH = config.launch(mode, null);
    }

    public static void log(String label, String classToLaunch, String[] classpath, String[] bootClasspath, String vmArgs, String prgArgs, boolean debug, boolean showInDebugger) {
        StringBuffer trace = new StringBuffer("\n-------- Sysdeo Tomcat Launcher settings --------");
        trace.append("\n-> Label : " + label);
        trace.append("\n-> ClassToLaunch : " + classToLaunch);
        trace.append("\n-> Classpath : ");
        int i = 0;
        while (i < classpath.length) {
            trace.append(" | " + classpath[i] + " | ");
            ++i;
        }
        trace.append("\n-> BootClasspath : ");
        i = 0;
        while (i < bootClasspath.length) {
            trace.append(" | " + bootClasspath[i] + " | ");
            ++i;
        }
        trace.append("\n-> Vmargs : " + vmArgs);
        trace.append("\n-> PrgArgs : " + prgArgs);
        trace.append("\n-> Debug : " + debug);
        trace.append("\n-> Source lookup : \n");
        TomcatLauncherPlugin.log(trace.toString());
        try {
            ILaunchConfigurationWorkingCopy config = VMLauncherUtility.createConfig(label, classToLaunch, classpath, bootClasspath, vmArgs, prgArgs, debug, showInDebugger, false);
            VMLauncherUtility.getSourceLocator((ILaunchConfiguration)config, true);
        }
        catch (CoreException e) {
            TomcatLauncherPlugin.log("getSourceLocator failed");
        }
        TomcatLauncherPlugin.log("\n-------- Sysdeo Tomcat Launcher settings--------");
    }

    public static ILaunchConfigurationWorkingCopy createConfig(String label, String classToLaunch, String[] classpath, String[] bootClasspath, String vmArgs, String prgArgs, boolean debug, boolean showInDebugger, boolean saveConfig) throws CoreException {
        IRuntimeClasspathEntry cpEntry;
        IVMInstall vmInstall = VMLauncherUtility.getVMInstall();
        ILaunchConfigurationType launchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.jdt.launching.localJavaApplication");
        ILaunchConfigurationWorkingCopy config = launchType.newInstance(null, label);
        config.setAttribute("org.eclipse.debug.ui.private", !saveConfig);
        config.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.eclipse.jdt.launching.sourceLocator.JavaSourceLookupDirector");
        ISourceLookupDirector locator = (ISourceLookupDirector)VMLauncherUtility.getSourceLocator((ILaunchConfiguration)config, false);
        config.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
        ArrayList<String> classpathMementos = new ArrayList<String>();
        int i = 0;
        while (i < classpath.length) {
            cpEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(classpath[i]));
            cpEntry.setClasspathProperty(3);
            classpathMementos.add(cpEntry.getMemento());
            ++i;
        }
        if (bootClasspath.length == 0) {
            Path path = new Path(JavaRuntime.JRE_CONTAINER);
            try {
                cpEntry = JavaCore.newContainerEntry((IPath)path);
                IRuntimeClasspathEntry rcpEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)cpEntry.getPath(), (int)1);
                classpathMementos.add(rcpEntry.getMemento());
            }
            catch (CoreException ex) {
                TomcatLauncherPlugin.log((Exception)((Object)ex));
            }
        } else {
            i = 0;
            while (i < bootClasspath.length) {
                cpEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(bootClasspath[i]));
                cpEntry.setClasspathProperty(2);
                classpathMementos.add(cpEntry.getMemento());
                ++i;
            }
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmInstall.getVMInstallType().getId());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmInstall.getName());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpathMementos);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, prgArgs);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, classToLaunch);
        String catalinaBase = TomcatLauncherPlugin.getDefault().getTomcatBase();
        if (catalinaBase.length() == 0) {
            catalinaBase = TomcatLauncherPlugin.getDefault().getTomcatDir();
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, catalinaBase);
        if (saveConfig) {
            VMLauncherUtility.getSourceLocator((ILaunchConfiguration)config, false);
            config.doSave();
        }
        return config;
    }

    private static ISourceLocator getSourceLocator(ILaunchConfiguration configuration, boolean trace) throws CoreException {
        ArrayList<Object> sourceContainers;
        JavaSourceLookupDirector sourceLocator;
        StringBuffer traceBuffer;
        block8: {
            ArrayList<IProjectNature> tempList = new ArrayList<IProjectNature>();
            traceBuffer = new StringBuffer();
            traceBuffer.append("Projects in source path :\n");
            List projects = TomcatLauncherPlugin.getDefault().getProjectsInSourcePath();
            Iterator iter = projects.iterator();
            while (iter.hasNext()) {
                IProject project = ((ProjectListElement)iter.next()).getProject();
                traceBuffer.append("Project " + project.getName());
                if (!project.isOpen() || !project.hasNature("org.eclipse.jdt.core.javanature")) continue;
                tempList.add(project.getNature("org.eclipse.jdt.core.javanature"));
                traceBuffer.append(" added to tempList\n");
            }
            sourceLocator = null;
            sourceLocator = new JavaSourceLookupDirector();
            ISourcePathComputer computer = DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer("org.eclipse.jdt.launching.sourceLookup.javaSourcePathComputer");
            sourceLocator.setSourcePathComputer(computer);
            sourceContainers = new ArrayList<Object>();
            if (tempList.isEmpty()) break block8;
            IJavaProject[] javaProjects = tempList.toArray(new IJavaProject[1]);
            int i = 0;
            while (i < javaProjects.length) {
                IJavaProject project = javaProjects[i];
                traceBuffer.append("  -> Add JavaProjectSourceContainer for " + project.getProject().getName() + "\n");
                sourceContainers.add(new JavaProjectSourceContainer(project));
                ++i;
            }
            HashSet<IPath> external = new HashSet<IPath>();
            int i2 = 0;
            while (i2 < javaProjects.length) {
                IJavaProject project = javaProjects[i2];
                traceBuffer.append("  -> Compute SourceContainers for " + project.getProject().getName() + " :\n");
                IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                int ri = 0;
                while (ri < roots.length) {
                    block10: {
                        IPackageFragmentRoot root;
                        block9: {
                            root = roots[ri];
                            if (!root.isExternal()) break block9;
                            IPath location = root.getPath();
                            if (external.contains(location)) break block10;
                            external.add(location);
                        }
                        sourceContainers.add(new PackageFragmentRootSourceContainer(root));
                        traceBuffer.append("     RootSourceContainer created for : " + root.getPath().toPortableString() + "\n");
                    }
                    ++ri;
                }
                ++i2;
            }
        }
        sourceContainers.add(new DefaultSourceContainer());
        sourceLocator.setSourceContainers(sourceContainers.toArray(new ISourceContainer[sourceContainers.size()]));
        sourceLocator.initializeParticipants();
        if (trace) {
            TomcatLauncherPlugin.log(traceBuffer.toString());
        }
        return sourceLocator;
    }
}

