/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat.editors;

import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ListFieldEditor
extends ListEditor
implements TomcatPluginResources {
    protected List list;
    protected Composite buttonBox;
    protected Button addButton;
    protected Button removeButton;
    protected Button updateButton;
    protected Button upButton;
    protected Button downButton;
    protected SelectionListener selectionListener;

    public ListFieldEditor() {
    }

    public ListFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
        }
    }

    protected void updatePressed() {
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.setItem(index, input);
            }
            this.selectionChanged();
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void createButtons(Composite buttonBox) {
        this.addButton = this.createPushButton(buttonBox, PREF_PAGE_ADDBUTTON_LABEL);
        this.removeButton = this.createPushButton(buttonBox, PREF_PAGE_REMOVEBUTTON_LABEL);
        this.updateButton = this.createPushButton(buttonBox, PREF_PAGE_UPDATEBUTTON_LABEL);
        this.upButton = this.createPushButton(buttonBox, PREF_PAGE_UPBUTTON_LABEL);
        this.downButton = this.createPushButton(buttonBox, PREF_PAGE_DOWNBUTTON_LABEL);
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData(768);
        data.heightHint = this.convertVerticalDLUsToPixels((Control)button, 14);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == ListFieldEditor.this.addButton) {
                    ListFieldEditor.this.addPressed();
                } else if (widget == ListFieldEditor.this.removeButton) {
                    ListFieldEditor.this.removePressed();
                } else if (widget == ListFieldEditor.this.updateButton) {
                    ListFieldEditor.this.updatePressed();
                } else if (widget == ListFieldEditor.this.upButton) {
                    ListFieldEditor.this.upPressed();
                } else if (widget == ListFieldEditor.this.downButton) {
                    ListFieldEditor.this.downPressed();
                } else if (widget == ListFieldEditor.this.list) {
                    ListFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        gd = new GridData(768);
        gd.heightHint = 80;
        gd.widthHint = 300;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.list != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            String[] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                this.list.add(array[i]);
                ++i;
            }
        }
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                this.list.add(array[i]);
                ++i;
            }
        }
    }

    protected void doStore() {
        String s = this.createList(this.list.getItems());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    protected void downPressed() {
        this.swap(false);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListFieldEditor.this.addButton = null;
                    ListFieldEditor.this.removeButton = null;
                    ListFieldEditor.this.upButton = null;
                    ListFieldEditor.this.downButton = null;
                    ListFieldEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2818);
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListFieldEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        int[] indices = this.list.getSelectionIndices();
        if (indices.length > 0) {
            this.list.remove(indices);
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    protected void swap(boolean up) {
        String[] selection;
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0 && (selection = this.list.getSelection()).length == 1) {
            this.list.remove(index);
            this.list.add(selection[0], target);
            this.list.setSelection(target);
        }
        this.selectionChanged();
    }

    protected void upPressed() {
        this.swap(true);
    }

    protected String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(URLEncoder.encode(items[i]));
            path.append(TomcatPluginResources.PREF_PAGE_LIST_SEPARATOR);
            ++i;
        }
        return path.toString();
    }

    protected String getNewInputObject() {
        String defaultValue = "";
        if (this.list.getSelection().length != 0) {
            defaultValue = this.list.getSelection()[0];
        }
        InputDialog dialog = new InputDialog(this.getShell(), "New Tomcat JVM paramater", "Enter a JVM parameter", defaultValue, null);
        String param = null;
        int dialogCode = dialog.open();
        if (dialogCode == 0 && (param = dialog.getValue()) != null && (param = param.trim()).length() == 0) {
            return null;
        }
        return param;
    }

    protected String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, TomcatPluginResources.PREF_PAGE_LIST_SEPARATOR);
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(URLDecoder.decode(st.nextToken()));
        }
        return v.toArray(new String[v.size()]);
    }
}

