/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.rnceditor;

import com.objfac.util.TabCalculator;
import com.objfac.xmleditor.BaseEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class RNCAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    private static RNCAutoIndentStrategy fStrategy = new RNCAutoIndentStrategy();

    public static RNCAutoIndentStrategy getStrategy() {
        return fStrategy;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.length == 0 && documentCommand.text != null && TextUtilities.endsWith((String[])iDocument.getLegalLineDelimiters(), (String)documentCommand.text) != -1) {
            this.autoIndent(iDocument, documentCommand);
        }
    }

    private void autoIndent(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset == -1 || iDocument.getLength() == 0) {
            return;
        }
        try {
            int n = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            int n3 = this.findEndOfWhiteSpace(iDocument, n2, documentCommand.offset);
            BaseEditor baseEditor = BaseEditor.findEditor(iDocument);
            TabCalculator tabCalculator = new TabCalculator(baseEditor.getTabWidth(), baseEditor.getSpacesForTabs());
            String string = "";
            if (n3 > n2) {
                string = iDocument.get(n2, n3 - n2);
            }
            string = tabCalculator.normalizeLeadingWhitespace(string);
            StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
            stringBuffer.append(string);
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {}
    }
}

