/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.rnceditor;

import com.objfac.rnceditor.RNCContentOutlinePage;
import com.objfac.rnceditor.RNCDocumentProvider;
import com.objfac.rnceditor.RNCNode;
import com.objfac.rnceditor.RNCSourceViewerConfiguration;
import com.objfac.rnceditor.RNCTree;
import com.objfac.rnceditor.partition.RuleUtils;
import com.objfac.rnceditor.partition.StringScanner;
import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.util.TabCalculator;
import com.objfac.xml.Util;
import com.objfac.xmleditor.BaseContentOutlinePage;
import com.objfac.xmleditor.BaseEditor;
import com.objfac.xmleditor.BaseSourceViewerConfiguration;
import com.objfac.xmleditor.DTDParams;
import com.objfac.xmleditor.IEditorEnvironment;
import com.objfac.xmleditor.IOutlineTree;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.DependencyManager;
import com.objfac.xmleditor.actions.RNCDefinitionFinder;
import com.objfac.xmleditor.extensions.RNCDocumentSetupParticipant;
import com.objfac.xmleditor.partition.PartitionUtils;
import com.objfac.xmleditor.partition.XMLPartitioner;
import com.objfac.xmleditor.preferences.XMLGeneralSettings;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLNodeTree;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class RNCEditor
extends BaseEditor {
    protected static HashSet fEditors = new HashSet();
    private RNCTree fTree = new RNCTree();
    private XMLGeneralSettings fXMLPrimary;

    public RNCEditor() {
        super(true);
        fEditors.add(this);
        this.fXMLPrimary = new XMLGeneralSettings();
    }

    public int getEditorKind() {
        return 3;
    }

    public String getEditorId() {
        return "com.objfac.rnceditor.RNCEditor";
    }

    protected void setEditorEnvironment() {
        this.fEnv = XMLPlugin.getDefault().getRNCEditorEnvironment();
    }

    protected FileDocumentProvider createDocumentProvider() {
        return new RNCDocumentProvider();
    }

    protected BaseSourceViewerConfiguration createSourceViewerConfiguration(IEditorEnvironment iEditorEnvironment, TabCalculator tabCalculator) {
        return new RNCSourceViewerConfiguration(iEditorEnvironment, tabCalculator);
    }

    public void dispose() {
        fEditors.remove(this);
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction textOperationAction = new TextOperationAction(Local.getBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
        textOperationAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)textOperationAction);
        textOperationAction = new TextOperationAction(Local.getBundle(), "ContentAssistTip.", (ITextEditor)this, 14);
        textOperationAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)textOperationAction);
    }

    protected BaseContentOutlinePage createContentOutlinePage() {
        return new RNCContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
    }

    public IOutlineTree getOutlineTree() {
        return this.fTree;
    }

    public RNCTree getRNCTree() {
        return this.fTree;
    }

    public DTDParams getDTDParams() {
        DTDParams dTDParams = new DTDParams();
        IFile iFile = this.getFile();
        dTDParams.prim = iFile == null ? false : this.fXMLPrimary.isSchemaPrimary(iFile);
        return dTDParams;
    }

    protected void checkValidate(boolean bl) {
    }

    protected void documentChanged(Position[] positionArray, IDocument iDocument, int n, int n2, int n3, boolean bl) {
    }

    protected void resetParseParams() {
    }

    protected void updateContentAssist() {
    }

    protected int posRight(IDocument iDocument, int n) {
        this.whereAreWe(n);
        return n;
    }

    private int whereAreWe(int n) {
        return 0;
    }

    protected int posLeft(IDocument iDocument, int n) {
        return n;
    }

    protected void verifyKey(VerifyEvent verifyEvent) {
    }

    protected void backgroundHandleDependencies(long l) {
        DependencyManager dependencyManager = DependencyManager.getSingletonManager();
        String string = this.getUrl();
        RNCTree rNCTree = this.getRNCTree();
        RNCEditor.setDependencies(dependencyManager, string, rNCTree, l);
    }

    private static void recordDependency(String string, XMLNode xMLNode, DependencyManager dependencyManager, String string2) {
        String string3;
        String string4 = xMLNode.getContents();
        int n = string.length();
        int n2 = string4.length();
        char c = '\u0000';
        while (n < n2 && (c = string4.charAt(n)) != '\'' && c != '\"') {
            ++n;
        }
        if (n < n2 && (string3 = RuleUtils.scanLiteral(c, new StringScanner(string4, n + 1))) != null && string3.length() > 0) {
            String string5 = Misc.getAbsUrl((String)string2, (String)string3);
            dependencyManager.addDependency(string2, string5);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setDependencies(final DependencyManager dependencyManager, final String string, RNCTree rNCTree, long l) {
        dependencyManager.forget(string);
        try {
            if (rNCTree != null) {
                rNCTree.visit(new XMLNodeTree.Visitor(){

                    public void visit(XMLNode xMLNode) {
                        String string2 = xMLNode.getType();
                        if (string2 == "com.objfac.rncinclude") {
                            RNCEditor.recordDependency("include", xMLNode, dependencyManager, string);
                        } else if (string2 == "com.objfac.rncexternal") {
                            RNCEditor.recordDependency("external", xMLNode, dependencyManager, string);
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dependencyManager.remember(string);
            throw throwable;
        }
        {
            Object var5_6 = null;
            dependencyManager.remember(string);
            return;
        }
    }

    public boolean canOpenDefinition() {
        ISourceViewer iSourceViewer = this.getViewer();
        Point point = iSourceViewer.getSelectedRange();
        RNCTree rNCTree = this.getRNCTree();
        XMLNode xMLNode = rNCTree.findNode(point.x);
        return xMLNode != null && xMLNode.getType() == "com.objfac.rncref";
    }

    public void openDefinition() {
        new RNCDefinitionFinder(this).openDefinition();
    }

    public static void invalidatePresentations() {
        Iterator iterator = fEditors.iterator();
        while (iterator.hasNext()) {
            RNCEditor rNCEditor = (RNCEditor)iterator.next();
            ISourceViewer iSourceViewer = rNCEditor.getSourceViewer();
            iSourceViewer.invalidateTextPresentation();
        }
    }

    public boolean canOpenUri() {
        String string = this.getUri();
        return string != null && string.length() > 0;
    }

    private String getUri() {
        String string;
        int n;
        String string2 = null;
        ISourceViewer iSourceViewer = this.getViewer();
        Point point = iSourceViewer.getSelectedRange();
        RNCTree rNCTree = this.getRNCTree();
        XMLNode xMLNode = rNCTree.findNode(point.x);
        if (xMLNode != null && point.x > (n = xMLNode.getOffset()) && point.x + point.y < n + xMLNode.getLength() && ((string = xMLNode.getType()) == "com.objfac.rncinclude" || string == "com.objfac.rncexternal")) {
            char c;
            int n2 = string == "com.objfac.rncinclude" ? "include".length() : "external".length();
            String string3 = xMLNode.getContents();
            int n3 = string3.length();
            int n4 = Util.skipWhitespace((String)string3, (int)n2, (int)n3);
            char c2 = c = n4 < n3 ? string3.charAt(n4) : (char)'\u0000';
            if (c == '\'' || c == '\"') {
                StringScanner stringScanner = new StringScanner(string3, n4 + 1);
                string2 = RuleUtils.scanLiteral(c, stringScanner);
            }
        }
        return string2;
    }

    public void openUri() {
        String string = this.getUri();
        if (string != null && string.length() > 0) {
            this.openUri(string);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
    }

    protected XMLNode findNode(int n) {
        RNCNode rNCNode = this.getRNCTree().fastFindNode(n);
        return rNCNode;
    }

    protected void checkPartitioner(IDocument iDocument) {
        IDocumentPartitioner iDocumentPartitioner = PartitionUtils.getPartitioner(iDocument, "com.objfac.rncpartitioner");
        if (!(iDocumentPartitioner instanceof XMLPartitioner)) {
            RNCDocumentSetupParticipant.setupPartitioner(iDocument);
        }
    }

    protected boolean isMyProvider(IDocumentProvider iDocumentProvider) {
        return iDocumentProvider instanceof RNCDocumentProvider;
    }

    public char[] getContents() {
        return null;
    }

    public XMLTree getXMLTree() {
        return null;
    }
}

