/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.trang.moved;

import com.objfac.trang.moved.CharRepertoire;
import com.objfac.trang.moved.Utf16;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Writer;

public class XmlWriter {
    private static final String indentString = "  ";
    private final Writer writer;
    private final CharRepertoire cr;
    private static final int OTHER = 0;
    private static final int IN_START_TAG = 1;
    private static final int AFTER_DATA = 2;
    private int state = 0;
    private String[] stack = new String[20];
    private int level = 0;
    private String newline = "\n";

    public XmlWriter(Writer writer, CharRepertoire charRepertoire) {
        this.writer = writer;
        this.cr = charRepertoire;
    }

    public void setNewline(String string) {
        this.newline = string;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void writeXmlDecl(String string) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"");
        this.writer.write(string);
        this.writer.write("\"?>");
        this.writer.write(this.newline);
    }

    public void startElement(String string) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
                this.writer.write(this.newline);
                this.indent();
                break;
            }
            case 0: {
                this.indent();
            }
            case 2: {
                this.state = 1;
            }
        }
        this.writer.write(60);
        this.outputMarkup(string);
        this.push(string);
    }

    public void endElement() throws IOException {
        String string = this.pop();
        switch (this.state) {
            case 1: {
                this.writer.write("/>");
                break;
            }
            case 0: {
                this.indent();
            }
            case 2: {
                this.writer.write("</");
                this.outputMarkup(string);
                this.writer.write(62);
            }
        }
        this.writer.write(this.newline);
        this.state = 0;
    }

    public void attribute(String string, String string2) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.writer.write(32);
        this.outputMarkup(string);
        this.writer.write(61);
        this.writer.write(34);
        this.outputData(string2, true, false);
        this.writer.write(34);
    }

    public void characters(String string) throws IOException {
        this.characters(string, false);
    }

    public void characters(String string, boolean bl) throws IOException {
        if (this.state == 1) {
            this.writer.write(62);
        }
        this.state = 2;
        this.outputData(string, false, bl);
    }

    public void comment(String string) throws IOException {
        if (this.state == 1) {
            this.writer.write(62);
            this.state = 0;
            this.writer.write(this.newline);
        }
        this.writer.write("<!--");
        this.outputMarkup(string);
        this.writer.write("-->");
        if (this.state != 2) {
            this.writer.write(this.newline);
        }
    }

    public void processingInstruction(String string, String string2) throws IOException {
        if (this.state == 1) {
            this.writer.write(62);
            this.state = 0;
            this.writer.write(this.newline);
        }
        this.writer.write("<?");
        this.outputMarkup(string);
        if (string2.length() != 0) {
            this.writer.write(32);
            this.outputMarkup(string2);
        }
        this.writer.write("?>");
        if (this.state != 2) {
            this.writer.write(this.newline);
        }
    }

    private void outputMarkup(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Utf16.isSurrogate1(c)) {
                if (n2 == n || !Utf16.isSurrogate2(string.charAt(n2))) {
                    throw new CharConversionException("surrogate pair integrity failure");
                }
                if (!this.cr.contains(c, string.charAt(n2))) {
                    throw new CharConversionException();
                }
            } else if (!this.cr.contains(c)) {
                throw new CharConversionException();
            }
            ++n2;
        }
        this.outputLines(string);
    }

    private void outputLines(String string) throws IOException {
        while (string.length() > 0) {
            int n = string.indexOf(10);
            if (n < 0) {
                this.writer.write(string);
                break;
            }
            if (n > 0) {
                this.writer.write(string.substring(0, n));
            }
            this.writer.write(this.newline);
            string = string.substring(n + 1);
        }
    }

    private void outputData(String string, boolean bl, boolean bl2) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    this.writer.write("&lt;");
                    break;
                }
                case '>': {
                    this.writer.write("&gt;");
                    break;
                }
                case '&': {
                    this.writer.write("&amp;");
                    break;
                }
                case '\"': {
                    this.writer.write("&quot;");
                    break;
                }
                case '\r': {
                    this.writer.write("&#xD;");
                    break;
                }
                case '\t': {
                    if (bl) {
                        this.writer.write("&#x9;");
                        break;
                    }
                    this.writer.write(9);
                    break;
                }
                case '\n': {
                    if (bl) {
                        this.writer.write("&#xA;");
                        break;
                    }
                    this.writer.write(this.newline);
                    break;
                }
                default: {
                    if (Utf16.isSurrogate1(c)) {
                        if (++n2 < n) {
                            char c2 = string.charAt(n2);
                            if (Utf16.isSurrogate2(c)) {
                                this.charRef(Utf16.scalarValue(c, c2));
                                break;
                            }
                        }
                        throw new CharConversionException("surrogate pair integrity failure");
                    }
                    if (this.cr.contains(c) && !bl2) {
                        this.writer.write(c);
                        break;
                    }
                    this.charRef(c);
                }
            }
            ++n2;
        }
    }

    private void charRef(int n) throws IOException {
        this.writer.write("&#x");
        int n2 = n > 65535 ? 6 : 4;
        int n3 = 0;
        while (n3 < n2) {
            this.writer.write("0123456789ABCDEF".charAt(n >> 4 * (n2 - 1 - n3) & 0xF));
            ++n3;
        }
        this.writer.write(";");
    }

    private void indent() throws IOException {
        int n = 0;
        while (n < this.level) {
            this.writer.write(indentString);
            ++n;
        }
    }

    private final void push(String string) {
        if (this.level == this.stack.length) {
            String[] stringArray = this.stack;
            this.stack = new String[this.stack.length * 2];
            System.arraycopy(stringArray, 0, this.stack, 0, stringArray.length);
        }
        this.stack[this.level++] = string;
    }

    private final String pop() {
        return this.stack[--this.level];
    }
}

