/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.xmleditor.BaseEditor;
import com.objfac.xmleditor.IOutlineTree;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.partition.FilterIterator;
import com.objfac.xmleditor.xmltree.XMLNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public abstract class BaseContentOutlinePage
extends ContentOutlinePage {
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected BaseEditor fEditor;
    protected IOutlineTree fTree;
    protected TreeViewer fTreeViewer;
    protected HashMap fTagNames;
    protected FilterIterator fFilter = new FilterIterator(this.getFilterSet());
    protected EndFilterIterator fEndFilter = new EndFilterIterator(this.getEndFilterSet(), this.fFilter);
    boolean fMoveCursor = true;

    protected abstract HashSet getFilterSet();

    protected abstract HashSet getEndFilterSet();

    protected abstract String[] getIconUrls();

    public BaseContentOutlinePage(IDocumentProvider iDocumentProvider, ITextEditor iTextEditor) {
        this.fDocumentProvider = iDocumentProvider;
        this.fEditor = (BaseEditor)iTextEditor;
        this.fTagNames = new HashMap();
    }

    public void dispose() {
        this.fEditor.contentOutlinePageDisposed();
        super.dispose();
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.fTreeViewer = this.getTreeViewer();
        this.fTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TagLabelProvider());
        if (this.fInput != null) {
            this.fTreeViewer.setInput(this.fInput);
        }
    }

    public boolean isVisible() {
        Control control;
        if (this.fTreeViewer != null && (control = this.fTreeViewer.getControl()) != null && !control.isDisposed()) {
            return control.isVisible();
        }
        return false;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection.isEmpty()) {
            this.fEditor.resetHighlightRange();
        } else {
            XMLNode xMLNode = (XMLNode)((IStructuredSelection)iSelection).getFirstElement();
            try {
                this.fEditor.setOutlineSelection(xMLNode, this.fMoveCursor);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fEditor.resetHighlightRange();
                XMLPlugin.log(illegalArgumentException);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInput(Object object, IOutlineTree iOutlineTree) {
        this.fMoveCursor = false;
        try {
            this.fInput = object;
            this.fTree = iOutlineTree;
            this.update(iOutlineTree, 0, true);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fMoveCursor = true;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.fMoveCursor = true;
            return;
        }
    }

    public void refresh() {
        Control control;
        if (this.fTreeViewer != null && (control = this.fTreeViewer.getControl()) != null && !control.isDisposed()) {
            this.fTreeViewer.refresh();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changeSelection() {
        if (this.fTreeViewer == null) return;
        Control control = this.fTreeViewer.getControl();
        if (control == null) return;
        if (control.isDisposed()) return;
        this.fMoveCursor = false;
        try {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
            XMLNode xMLNode = (XMLNode)iStructuredSelection.getFirstElement();
            ContentProvider cfr_ignored_0 = (ContentProvider)this.fTreeViewer.getContentProvider();
            ITextSelection iTextSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            XMLNode xMLNode2 = this.fTree.findNode(iTextSelection.getOffset());
            if (!this.fFilter.pass(xMLNode2)) {
                xMLNode2 = xMLNode2.parent;
            }
            if (xMLNode != xMLNode2) {
                StructuredSelection structuredSelection = xMLNode2 == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)xMLNode2);
                control.setRedraw(false);
                this.fTreeViewer.setSelection((ISelection)structuredSelection, true);
                control.setRedraw(true);
            }
            if (xMLNode2 != null) {
                this.fTreeViewer.reveal((Object)xMLNode2);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.fMoveCursor = true;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.fMoveCursor = true;
            return;
        }
    }

    public void update(IOutlineTree iOutlineTree, int n) {
        this.update(iOutlineTree, n, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(IOutlineTree iOutlineTree, int n, boolean bl) {
        if (this.fTreeViewer == null) return;
        Control control = this.fTreeViewer.getControl();
        if (control == null) return;
        if (control.isDisposed()) return;
        this.fMoveCursor = false;
        try {
            XMLNode xMLNode;
            Object object;
            List list;
            this.fTree = iOutlineTree;
            boolean bl2 = false;
            if (bl || !this.fTree.isIncremental()) {
                this.fTagNames = new HashMap();
                this.fTreeViewer.setInput(this.fInput);
            } else {
                list = this.fTree.getIncrementalChanges(this.fEndFilter);
                object = list.iterator();
                while (object.hasNext()) {
                    boolean bl3 = false;
                    xMLNode = (XMLNode)object.next();
                    if (xMLNode.isDeleted()) {
                        this.fTagNames.remove(xMLNode);
                    } else {
                        String string = (String)this.fTagNames.get(xMLNode);
                        String string2 = xMLNode.toString();
                        boolean bl4 = string2.equals(string);
                        if (string == null || !bl4) {
                            this.fTagNames.put(xMLNode, string2);
                        } else {
                            bl3 = true;
                        }
                    }
                    if (!bl2) {
                        control.setRedraw(false);
                        bl2 = true;
                    }
                    if (bl3) continue;
                    if (xMLNode.isDeleted() && this.fFilter.pass(xMLNode)) {
                        this.fTreeViewer.remove((Object)xMLNode);
                        continue;
                    }
                    this.fTreeViewer.refresh();
                }
            }
            list = (IStructuredSelection)this.fTreeViewer.getSelection();
            object = (XMLNode)list.getFirstElement();
            XMLNode xMLNode2 = this.fTree.findNode(n);
            if (!this.fFilter.pass(xMLNode2)) {
                xMLNode2 = xMLNode2.parent;
            }
            if (xMLNode2 != object) {
                if (!bl2) {
                    control.setRedraw(false);
                    bl2 = true;
                }
                xMLNode = xMLNode2 == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)xMLNode2);
                this.fTreeViewer.setSelection((ISelection)xMLNode, true);
                if (xMLNode2 != null) {
                    this.fTreeViewer.reveal((Object)xMLNode2);
                }
            }
            if (bl2) {
                control.setRedraw(true);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.fMoveCursor = true;
            throw throwable;
        }
        {
            Object var13_16 = null;
            this.fMoveCursor = true;
            return;
        }
    }

    private void resetAll(TreeViewer treeViewer) {
        treeViewer.setInput(this.fInput);
        treeViewer.refresh();
        Control control = treeViewer.getControl();
        control.redraw();
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected ContentProvider() {
        }

        public Object[] getChildren(Object object) {
            LinkedList<XMLNode> linkedList = new LinkedList<XMLNode>();
            BaseContentOutlinePage.this.fFilter.setParent((XMLNode)object);
            while (BaseContentOutlinePage.this.fFilter.hasNext()) {
                linkedList.add(BaseContentOutlinePage.this.fFilter.next());
            }
            return linkedList.toArray(new Object[linkedList.size()]);
        }

        public Object getParent(Object object) {
            XMLNode xMLNode = ((XMLNode)object).parent;
            return xMLNode;
        }

        public boolean hasChildren(Object object) {
            BaseContentOutlinePage.this.fFilter.setParent((XMLNode)object);
            return BaseContentOutlinePage.this.fFilter.hasNext();
        }

        public void dispose() {
            BaseContentOutlinePage.this.fInput = null;
            BaseContentOutlinePage.this.fTree = null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            LinkedList<XMLNode> linkedList = new LinkedList<XMLNode>();
            BaseContentOutlinePage.this.fFilter.setFirstChild(BaseContentOutlinePage.this.fTree.getHead());
            while (BaseContentOutlinePage.this.fFilter.hasNext()) {
                linkedList.add(BaseContentOutlinePage.this.fFilter.next());
            }
            return linkedList.toArray(new Object[linkedList.size()]);
        }
    }

    private static class EndFilterIterator
    extends FilterIterator {
        private FilterIterator fFit;

        public EndFilterIterator(HashSet hashSet, FilterIterator filterIterator) {
            super(hashSet);
            this.fFit = filterIterator;
        }

        public boolean pass(XMLNode xMLNode) {
            boolean bl = this.fFit.pass(xMLNode);
            if (!bl) {
                bl = super.pass(xMLNode);
            }
            return bl;
        }
    }

    private class TagLabelProvider
    extends LabelProvider {
        HashMap fImageMap = new HashMap();
        URL fInstallUrl = XMLPlugin.getDefault().getDescriptor().getInstallURL();

        TagLabelProvider() {
        }

        public void dispose() {
            Iterator iterator = this.fImageMap.values().iterator();
            while (iterator.hasNext()) {
                ((Image)iterator.next()).dispose();
            }
            this.fImageMap.clear();
            super.dispose();
        }

        public Image getImage(Object object) {
            XMLNode xMLNode = (XMLNode)object;
            String string = xMLNode.getType();
            Image image = (Image)this.fImageMap.get(string);
            if (image == null) {
                String[] stringArray = BaseContentOutlinePage.this.getIconUrls();
                int n = 0;
                while (n < stringArray.length) {
                    String string2 = stringArray[n];
                    if (string2.equals(string)) {
                        String string3 = stringArray[n + 1];
                        try {
                            URL uRL = new URL(this.fInstallUrl, string3);
                            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
                            image = imageDescriptor.createImage();
                            this.fImageMap.put(string, image);
                        }
                        catch (MalformedURLException malformedURLException) {
                            XMLPlugin.log(malformedURLException);
                        }
                        break;
                    }
                    n += 2;
                }
            }
            return image;
        }

        public String getText(Object object) {
            XMLNode xMLNode = (XMLNode)object;
            String string = xMLNode.toString();
            BaseContentOutlinePage.this.fTagNames.put(xMLNode, string);
            return string;
        }
    }
}

