/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.util.TabCalculator;
import com.objfac.walker.EmptyWalker;
import com.objfac.walker.IWalker;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.io.DefaultDocumentReaderFactory;
import com.objfac.xml.io.Encoding;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.IExternalEntity;
import com.objfac.xml.schema.UnknownPublicIdentifierException;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xmleditor.BaseContentOutlinePage;
import com.objfac.xmleditor.BaseDocumentProvider;
import com.objfac.xmleditor.BaseSourceViewerConfiguration;
import com.objfac.xmleditor.BaseUtils;
import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.DTDParams;
import com.objfac.xmleditor.IEditorEnvironment;
import com.objfac.xmleditor.IEncodingProvider;
import com.objfac.xmleditor.IOutlineTree;
import com.objfac.xmleditor.IUndoManagerListener;
import com.objfac.xmleditor.NotifyingUndoManager;
import com.objfac.xmleditor.SelectListener;
import com.objfac.xmleditor.XMLActionContributor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.ActionUtils;
import com.objfac.xmleditor.actions.DefinitionTarget;
import com.objfac.xmleditor.actions.DependencyManager;
import com.objfac.xmleditor.actions.EditorActionDelegate;
import com.objfac.xmleditor.actions.GenerateXMLAction;
import com.objfac.xmleditor.actions.OkDialog;
import com.objfac.xmleditor.actions.Storage;
import com.objfac.xmleditor.actions.VersionAction;
import com.objfac.xmleditor.preferences.XMLEncodingHandler;
import com.objfac.xmleditor.properties.IFilePropertyChangeListener;
import com.objfac.xmleditor.properties.PropertyChangeManager;
import com.objfac.xmleditor.resources.AbstractEditor;
import com.objfac.xmleditor.resources.ResourceWatcher;
import com.objfac.xmleditor.resources.ResourceWatcherCallback;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.resources.XMLResourceManager;
import com.objfac.xmleditor.validate.XMLValidationShell;
import com.objfac.xmleditor.wizards.WizardUtils;
import com.objfac.xmleditor.xmltree.XMLNode;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class BaseEditor
extends TextEditor
implements IPropertyChangeListener,
ResourceWatcher,
IFilePropertyChangeListener,
IUndoManagerListener,
IAdaptable,
AbstractEditor {
    private boolean fPro;
    private static LinkedList fSelectListeners;
    private boolean fNotifyingSelectListeners;
    private OpenUriAction fOpenUriAction;
    private boolean fInitializingDocument;
    private GenerateXMLAction fGenerateXMLAction;
    private boolean fInUndoRedo;
    private OpenSchemaAction fOpenSchemaAction;
    private GotoDefinitionAction fGotoDefinitionAction;
    private static boolean fTextOutline;
    private boolean fFlowShort;
    private boolean fFlowLong;
    private boolean fFormatPaste;
    protected int fWrapMax;
    private Object fPropertyListener;
    private int fDeferredUpdate = 0;
    private int fValidateDelay;
    private long fValidateTime;
    private long fValidateModStamp;
    private Object fValidateObject = new Object();
    private int fValidatingChange;
    private volatile boolean fValidateInProgress;
    private int fChange;
    private boolean fValidateOnChange;
    private int fWatchPos;
    protected IEditorEnvironment fEnv;
    protected BaseContentOutlinePage fOutlinePage;
    protected static boolean fAttrOutline;
    protected final ResourceWatcherCallback fResourceCallback = new ResourceWatcherCallback(this);
    protected TabCalculator fTabber;
    private static final LinkedList fEditors;
    protected IWalker fWalker = new EmptyWalker();
    private volatile boolean fCancelValidate;
    private DTDParams fValidateDTDParams;
    private int fValidateEditorKind;
    private String fValidateUrl;
    private String fValidateText;
    private String fValidateEncoding;
    private IOutlineTree fValidateTree;
    private String fDoctypeContents;
    protected PartListener fPartListener = new PartListener();
    protected static final int MOUSE_UP = 0;
    protected static final int KEY_UP = 1;
    protected PositionListener fPositionListener = new PositionListener();
    protected static Key fMatchKey;
    protected HashSet fCursorKeys = new HashSet();
    protected boolean fUpdating;
    protected ContentOutlineDelay fUpdateDelay;
    protected long fUpdateWakeup;
    protected Display fDisplay;
    protected static final long UPDATE_DELAY = 500L;
    protected int fTreeOffset;
    protected long begUpdate;
    protected long endUpdate;
    protected long cntUpdate;
    protected long aveUpdate;
    protected long cumUpdate;
    protected ContentOutlineUpdater fUpdater;
    protected boolean fReset;
    protected DPL fPartitionListener;
    protected DL fDocListener;
    protected long cntChange;
    protected IEditorInput fInput;
    protected static HashMap fDocumentEditors;
    public static final int PARSE_NONE = 0;
    public static final int PARSING_DTD = 1;
    public static final int PARSING_SCHEMA = 2;
    public static final int PARSING_RNG_SCHEMA = 3;
    public static final int PARSED_DTD = 4;
    public static final int PARSED_SCHEMA = 5;
    public static final int PARSED_RNG_SCHEMA = 6;
    public static final int PARSE_DTD_FAILED = 7;
    public static final int PARSE_XSD_FAILED = 8;
    public static final int PARSE_RNG_FAILED = 9;
    public static final int PARSING_AUTO = 10;
    public static final int PARSED_AUTO = 11;
    public static final int PARSE_AUTO_FAILED = 12;
    private int fParseState;
    private XMLVerifyListener fVerifyListener;
    BaseUtils.EditorInfo info;
    private SelectNotify fSelectNotify;
    private TextSelectionListener fSelectionListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        fEditors = new LinkedList();
        fMatchKey = new Key(0, 0, 0);
        fDocumentEditors = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseEditor(boolean bl) {
        this.fCursorKeys.add(new Key(0, 0x1000002, 0));
        this.fCursorKeys.add(new Key(0, 0x1000001, 0));
        this.fCursorKeys.add(new Key(0, 0x1000003, 0));
        this.fCursorKeys.add(new Key(0, 0x1000004, 0));
        this.fCursorKeys.add(new Key(0, 0x1000006, 0));
        this.fCursorKeys.add(new Key(0, 0x1000005, 0));
        this.fUpdating = false;
        this.fUpdateDelay = new ContentOutlineDelay();
        this.begUpdate = 0L;
        this.endUpdate = 0L;
        this.cntUpdate = 0L;
        this.aveUpdate = 0L;
        this.cumUpdate = 0L;
        this.fUpdater = new ContentOutlineUpdater();
        this.fPartitionListener = new DPL();
        this.fDocListener = new DL();
        this.cntChange = 0L;
        this.fParseState = 0;
        this.fVerifyListener = new XMLVerifyListener();
        this.info = new BaseUtils.EditorInfo(){

            public Shell getShell() {
                return BaseEditor.this.getSite().getShell();
            }

            public IEditorInput getInput() {
                return BaseEditor.this.getEditorInput();
            }

            public IPreferenceStore getPreferenceStore() {
                return BaseEditor.this.getPreferenceStore();
            }

            public IDocumentProvider getDocumentProvider() {
                return BaseEditor.this.getDocumentProvider();
            }

            public void setInput(IEditorInput iEditorInput) {
                BaseEditor.this.setInput(iEditorInput);
            }
        };
        this.fSelectNotify = new SelectNotify();
        this.fSelectionListener = new TextSelectionListener();
        this.fPro = bl;
        this.setEditorEnvironment();
        this.fEnv.connect(this);
        LinkedList linkedList = fEditors;
        synchronized (linkedList) {
            fEditors.add(this);
        }
        linkedList = this.getPreferenceStore();
        linkedList.addPropertyChangeListener(this);
        linkedList = XMLPlugin.getDefault().getPreferenceStore();
        if (linkedList != this.getPreferenceStore()) {
            linkedList.addPropertyChangeListener(this);
        }
        this.fTabber = new TabCalculator(linkedList.getInt("com.objfac.xmleditor.tabwidth"), linkedList.getBoolean("com.objfac.xmleditor.spaces"));
        this.initializePreferenceVariables((IPreferenceStore)linkedList);
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration(this.fEnv, this.fTabber));
        this.setAttrOutline((IPreferenceStore)linkedList);
        this.setTextOutline((IPreferenceStore)linkedList);
        PropertyChangeManager.getSingletonManager().addPropertyChangeListener(this, this);
    }

    public Object getAdaptable(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.objfac.xmleditor.BaseEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this;
        }
        return null;
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        StyledText styledText;
        ISourceViewer iSourceViewer = super.createSourceViewer(composite, iVerticalRuler, n);
        IUndoManager iUndoManager = this.getUndoManager(iSourceViewer);
        if (iUndoManager instanceof NotifyingUndoManager) {
            ((NotifyingUndoManager)iUndoManager).addUndoManagerListener(this);
        }
        if ((styledText = iSourceViewer.getTextWidget()) != null) {
            styledText.addSelectionListener((SelectionListener)this.fSelectionListener);
        }
        return iSourceViewer;
    }

    public void undoManagerChanged(int n) {
        if (n == 1 || n == 0) {
            this.fInUndoRedo = true;
        } else if (n == 3 || n == 2) {
            this.fInUndoRedo = false;
        }
    }

    protected boolean isInUndoRedo() {
        return this.fInUndoRedo;
    }

    protected void initializeKeyBindingScopes() {
        super.initializeKeyBindingScopes();
        this.setKeyBindingScopes(new String[]{"com.objfac.xmleditor.scope", "org.eclipse.ui.textEditorScope"});
    }

    private IUndoManager getUndoManager() {
        ISourceViewer iSourceViewer = this.getViewer();
        return this.getUndoManager(iSourceViewer);
    }

    private IUndoManager getUndoManager(ISourceViewer iSourceViewer) {
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (iSourceViewer != null && sourceViewerConfiguration instanceof BaseSourceViewerConfiguration) {
            BaseSourceViewerConfiguration baseSourceViewerConfiguration = (BaseSourceViewerConfiguration)sourceViewerConfiguration;
            return baseSourceViewerConfiguration.getUndoManager(iSourceViewer);
        }
        return null;
    }

    public void beginCompoundChange() {
        IUndoManager iUndoManager = this.getUndoManager();
        if (iUndoManager != null) {
            iUndoManager.beginCompoundChange();
        }
    }

    public void convertToCompoundChange() {
        IUndoManager iUndoManager = this.getUndoManager();
        iUndoManager.beginCompoundChange();
    }

    public void endCompoundChange() {
        IUndoManager iUndoManager = this.getUndoManager();
        if (iUndoManager != null) {
            iUndoManager.endCompoundChange();
        }
    }

    private void setTabPreferences(IPreferenceStore iPreferenceStore) {
        this.fTabber = new TabCalculator(iPreferenceStore.getInt("com.objfac.xmleditor.tabwidth"), iPreferenceStore.getBoolean("com.objfac.xmleditor.spaces"));
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer != null) {
            iSourceViewer.getTextWidget().setTabs(this.fTabber.getTabWidth());
            BaseSourceViewerConfiguration baseSourceViewerConfiguration = (BaseSourceViewerConfiguration)this.getSourceViewerConfiguration();
            baseSourceViewerConfiguration.setTabCalculator(this.fTabber);
            String[] stringArray = baseSourceViewerConfiguration.getConfiguredContentTypes(iSourceViewer);
            String[] stringArray2 = this.fTabber.calculateIndentPrefixes();
            int n = 0;
            while (n < stringArray.length) {
                iSourceViewer.setIndentPrefixes(stringArray2, stringArray[n]);
                ++n;
            }
        }
    }

    public int getTabWidth() {
        return this.fTabber.getTabWidth();
    }

    public boolean getSpacesForTabs() {
        return this.fTabber.getSpacesForTabs();
    }

    protected TabCalculator getTabber() {
        return this.fTabber;
    }

    protected void initializePreferenceVariables(IPreferenceStore iPreferenceStore) {
        this.fValidateOnChange = iPreferenceStore.getBoolean("com.objfac.xmleditor.validateonchange");
        this.fValidateDelay = iPreferenceStore.getInt(XMLConstants.ID_VALIDATE_DELAY);
        this.fWrapMax = iPreferenceStore.getInt("com.objfac.xmleditor.wrapmax");
        this.setTabPreferences(iPreferenceStore);
        this.fFlowLong = iPreferenceStore.getBoolean("com.objfac.xmleditor.flowlong");
        this.fFlowShort = iPreferenceStore.getBoolean("com.objfac.xmleditor.flowshort");
        this.fFormatPaste = iPreferenceStore.getBoolean("com.objfac.xmleditor.formatpaste");
    }

    protected abstract void setEditorEnvironment();

    protected abstract FileDocumentProvider createDocumentProvider();

    protected abstract BaseSourceViewerConfiguration createSourceViewerConfiguration(IEditorEnvironment var1, TabCalculator var2);

    protected abstract BaseContentOutlinePage createContentOutlinePage();

    public abstract IOutlineTree getOutlineTree();

    protected void checkValidate(boolean bl) {
        IPreferenceStore iPreferenceStore = this.fEnv.getStore();
        if (iPreferenceStore.getBoolean("com.objfac.xmleditor.validateonsave")) {
            XMLValidationShell xMLValidationShell = new XMLValidationShell(this);
            if (bl) {
                xMLValidationShell.clear(false);
            } else {
                xMLValidationShell.validate();
                this.backgroundHandleDependencies(this.getModStamp());
            }
        }
    }

    protected abstract void backgroundHandleDependencies(long var1);

    protected abstract void updateContentAssist();

    protected abstract int posRight(IDocument var1, int var2);

    protected abstract int posLeft(IDocument var1, int var2);

    public abstract int getEditorKind();

    public abstract String getEditorId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        StyledText styledText;
        ISourceViewer iSourceViewer;
        IWorkbenchPartSite iWorkbenchPartSite;
        this.fEnv.disconnect(this);
        LinkedList linkedList = fEditors;
        synchronized (linkedList) {
            fEditors.remove(this);
        }
        linkedList = this.getPreferenceStore();
        linkedList.removePropertyChangeListener(this);
        linkedList = XMLPlugin.getDefault().getPreferenceStore();
        if (linkedList != this.getPreferenceStore()) {
            linkedList.removePropertyChangeListener(this);
        }
        if (this.fOutlinePage != null) {
            this.setOutlineInput(null);
        }
        if ((iWorkbenchPartSite = this.getSite()) != null) {
            iWorkbenchPartSite.getPage().removePartListener((IPartListener2)this.fPartListener);
        }
        if ((iSourceViewer = this.getSourceViewer()) != null && (styledText = iSourceViewer.getTextWidget()) != null) {
            styledText.removeMouseListener((MouseListener)this.fPositionListener);
            styledText.removeKeyListener((KeyListener)this.fPositionListener);
            styledText.removeVerifyKeyListener((VerifyKeyListener)this.fVerifyListener);
            styledText.removeSelectionListener((SelectionListener)this.fSelectionListener);
        }
        this.getSite().getPage().removePartListener((IPartListener2)this.fPartListener);
        XMLResourceManager.getInstance().stopWatchingResources(this);
        if (this.fValidateInProgress) {
            if (this.fResourceCallback != null) {
                this.fResourceCallback.cancel();
            }
            this.fCancelValidate = true;
        }
        this.setAction("com.objfac.xmleditor.open.editor", null);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        if (string.equals("com.objfac.xmleditor.tabwidth")) {
            this.setTabPreferences(iPreferenceStore);
        } else if (string.equals("com.objfac.xmleditor.showattr")) {
            this.setAttrOutline(iPreferenceStore);
        } else if (string.equals("com.objfac.xmleditor.showtext")) {
            this.setTextOutline(iPreferenceStore);
        } else if (string.equals("com.objfac.xmleditor.validateonchange")) {
            this.fValidateOnChange = iPreferenceStore.getBoolean("com.objfac.xmleditor.validateonchange");
        } else if (string.equals(XMLConstants.ID_VALIDATE_DELAY)) {
            this.fValidateDelay = iPreferenceStore.getInt(XMLConstants.ID_VALIDATE_DELAY);
        } else if (string.equals("com.objfac.xmleditor.spaces")) {
            this.setTabPreferences(iPreferenceStore);
        } else if (string.equals("com.objfac.xmleditor.wrapmax")) {
            this.fWrapMax = iPreferenceStore.getInt("com.objfac.xmleditor.wrapmax");
        } else if (string.equals("com.objfac.xmleditor.flowlong")) {
            this.fFlowLong = iPreferenceStore.getBoolean("com.objfac.xmleditor.flowlong");
        } else if (string.equals("com.objfac.xmleditor.flowshort")) {
            this.fFlowShort = iPreferenceStore.getBoolean("com.objfac.xmleditor.flowshort");
        } else if (string.equals("com.objfac.xmleditor.formatpaste")) {
            this.fFormatPaste = iPreferenceStore.getBoolean("com.objfac.xmleditor.formatpaste");
        } else if (string.equals("com.objfac.xmleditor.autoassist") || string.equals("com.objfac.xmleditor.assistdelay") || string.equals("com.objfac.xmleditor.autoinsert")) {
            BaseSourceViewerConfiguration baseSourceViewerConfiguration = (BaseSourceViewerConfiguration)this.getSourceViewerConfiguration();
            baseSourceViewerConfiguration.resetAssistant();
        }
    }

    public boolean getAutoFlowLong() {
        return this.fFlowLong;
    }

    public boolean getAutoFlowShort() {
        return this.fFlowShort;
    }

    public boolean getFormatPaste() {
        return this.fFormatPaste;
    }

    public int getWrapMargin() {
        return this.fWrapMax;
    }

    protected boolean autoValidate() {
        return this.fValidateOnChange;
    }

    protected boolean validateOnChange() {
        return this.autoValidate() || this.needValidate();
    }

    protected boolean needValidate() {
        return false;
    }

    public IWalker getWalker() {
        return this.fWalker;
    }

    protected void setWalker(IWalker iWalker) {
        this.fWalker = iWalker;
    }

    protected int validateDelay() {
        return this.fValidateDelay;
    }

    protected void checkValidate() {
        if (this.getEditorInput() instanceof IFileEditorInput && (Config.pro() || this.getEditorKind() == 0 || this.getEditorKind() == 1)) {
            this.doDelayedValidate();
        }
    }

    public abstract DTDParams getDTDParams();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelayedValidate() {
        Object object = this.fValidateObject;
        synchronized (object) {
            ++this.fChange;
            this.fValidateTime = System.currentTimeMillis() + (long)this.validateDelay();
            this.fValidateEditorKind = this.getEditorKind();
            this.fValidateUrl = this.getUrl();
            this.fValidateModStamp = this.getModStamp();
            this.fValidateText = this.getText();
            this.fValidateEncoding = this.getEncoding();
            this.fValidateTree = this.getOutlineTree();
            this.fValidateDTDParams = this.getDTDParams();
            this.fDoctypeContents = this.fValidateTree.getDoctypeContents(true);
            this.updateStatus("Validating");
            if (this.validateOnChange() && !this.fValidateInProgress) {
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            while (!BaseEditor.this.fCancelValidate) {
                                String string;
                                DTDParams dTDParams;
                                IOutlineTree iOutlineTree;
                                String string2;
                                String string3;
                                String string4;
                                int n;
                                Object object = BaseEditor.this.fValidateObject;
                                synchronized (object) {
                                    long l;
                                    while ((l = System.currentTimeMillis()) < BaseEditor.this.fValidateTime) {
                                        BaseEditor.this.fValidateObject.wait(BaseEditor.this.fValidateTime - l);
                                    }
                                    BaseEditor.this.fValidatingChange = BaseEditor.this.fChange;
                                    n = BaseEditor.this.fValidateEditorKind;
                                    string4 = BaseEditor.this.fValidateUrl;
                                    string3 = BaseEditor.this.fValidateText;
                                    string2 = BaseEditor.this.fValidateEncoding;
                                    iOutlineTree = BaseEditor.this.fValidateTree;
                                    dTDParams = BaseEditor.this.fValidateDTDParams;
                                    string = BaseEditor.this.fDoctypeContents;
                                }
                                object = new XMLValidationShell();
                                ((XMLValidationShell)object).backgroundValidate(n, dTDParams, string4, string3, string2, iOutlineTree, string, BaseEditor.this.fResourceCallback);
                                BaseEditor.this.backgroundHandleDependencies(BaseEditor.this.fValidateModStamp);
                                Object object2 = BaseEditor.this.fValidateObject;
                                synchronized (object2) {
                                    Display display;
                                    if (BaseEditor.this.fValidatingChange != BaseEditor.this.fChange) {
                                        continue;
                                    }
                                    if (!BaseEditor.this.fCancelValidate && (display = BaseEditor.this.getDisplay()) != null) {
                                        display.asyncExec((Runnable)new EndValidate((XMLValidationShell)object));
                                    }
                                    BaseEditor.this.fValidateInProgress = false;
                                    break;
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                });
                thread.setName("XML_validate_" + this.fValidatingChange);
                thread.start();
                this.fValidateInProgress = true;
            }
        }
    }

    public long getModStamp() {
        IPath iPath;
        File file;
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            return iFile.getModificationStamp();
        }
        if (iEditorInput instanceof IPathEditorInput && (file = new File((iPath = ((IPathEditorInput)iEditorInput).getPath()).toOSString())).exists()) {
            return file.lastModified();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isValidateInProgress() {
        Object object = this.fValidateObject;
        synchronized (object) {
            return this.fValidateInProgress;
        }
    }

    protected void updateStatus(final String string) {
        this.asyncExec(new Runnable(){

            public void run() {
                BaseEditor.this.updateStatusField(string);
            }
        });
    }

    public long getCurrentChange() {
        return this.fChange;
    }

    public String getUrl() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IPathEditorInput) {
            IPath iPath = ((IPathEditorInput)iEditorInput).getPath();
            String string = iPath.toOSString();
            return Misc.absPathToUrl((String)string);
        }
        return null;
    }

    public String getText() {
        IDocument iDocument;
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer != null && (iDocument = iSourceViewer.getDocument()) != null) {
            return iDocument.get();
        }
        return "";
    }

    public String getEncoding() {
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        if (iDocumentProvider instanceof IEncodingProvider) {
            IEncodingProvider iEncodingProvider = (IEncodingProvider)iDocumentProvider;
            return iEncodingProvider.getEncoding(this.getInput(), this.getDocument());
        }
        return "UTF-8";
    }

    private void setTextOutline(IPreferenceStore iPreferenceStore) {
        fTextOutline = iPreferenceStore.getBoolean("com.objfac.xmleditor.showtext");
        if (this.fOutlinePage != null) {
            this.fOutlinePage.refresh();
        }
    }

    public static boolean getTextOutline() {
        return fTextOutline;
    }

    protected void setAttrOutline(IPreferenceStore iPreferenceStore) {
        fAttrOutline = iPreferenceStore.getBoolean("com.objfac.xmleditor.showattr");
        if (this.fOutlinePage != null) {
            this.fOutlinePage.refresh();
        }
    }

    public static boolean getAttrOutline() {
        return fAttrOutline;
    }

    protected void installEncodingSupport() {
    }

    public void doSaveAs() {
        this.fixEncoding();
        super.doSaveAs();
        if (!XMLPlugin.getDefault().getSyncOutline() && this.fOutlinePage != null) {
            this.setOutlineInput(this.getEditorInput());
        }
    }

    protected void fixEncoding() {
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        IDocument iDocument = this.getDocument();
        this.fixEncoding(iDocumentProvider, iDocument);
    }

    protected void fixEncoding(IDocumentProvider iDocumentProvider, IDocument iDocument) {
        if (iDocumentProvider != null && iDocumentProvider instanceof TextFileDocumentProvider) {
            TextFileDocumentProvider textFileDocumentProvider = (TextFileDocumentProvider)iDocumentProvider;
            IEditorInput iEditorInput = this.getEditorInput();
            XMLEncodingHandler xMLEncodingHandler = XMLPlugin.getEncodingHandler();
            String string = xMLEncodingHandler.getEncoding(iEditorInput, iDocument);
            String string2 = textFileDocumentProvider.getEncoding((Object)iEditorInput);
            String string3 = Encoding.getStandardEquivalent((String)string);
            if (string3 == null) {
                string3 = string;
            }
            textFileDocumentProvider.setEncoding((Object)iEditorInput, string3);
            if (iDocument == null) {
                String string4 = Encoding.getStandardEquivalent((String)string2);
                if (string4 == null) {
                    string4 = string2;
                }
                if (!string3.equals(string4)) {
                    try {
                        textFileDocumentProvider.resetDocument((Object)iEditorInput);
                    }
                    catch (CoreException coreException) {
                        XMLPlugin.log(coreException);
                    }
                }
            }
        }
    }

    protected void setDocumentProvider(IEditorInput iEditorInput) {
        super.setDocumentProvider(iEditorInput);
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        if (iDocumentProvider != null && iDocumentProvider instanceof TextFileDocumentProvider) {
            try {
                iDocumentProvider.connect((Object)iEditorInput);
                this.fixEncoding(iDocumentProvider, null);
            }
            catch (CoreException coreException) {
                XMLPlugin.log(coreException);
            }
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.fixEncoding();
        super.doSave(iProgressMonitor);
        if (!XMLPlugin.getDefault().getSyncOutline() && this.fOutlinePage != null) {
            this.setOutlineInput(this.getEditorInput());
        }
        this.checkValidate(false);
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (!XMLPlugin.getDefault().getSyncOutline() && this.fOutlinePage != null) {
            this.setOutlineInput(this.getEditorInput());
        }
        this.checkValidate(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createPartControl(Composite composite) {
        IKeyBindingService iKeyBindingService;
        super.createPartControl(composite);
        StyledText styledText = this.getSourceViewer().getTextWidget();
        styledText.addMouseListener((MouseListener)this.fPositionListener);
        styledText.addKeyListener((KeyListener)this.fPositionListener);
        styledText.addVerifyKeyListener((VerifyKeyListener)this.fVerifyListener);
        styledText.setTabs(XMLPlugin.getDefault().getPreferenceStore().getInt("com.objfac.xmleditor.tabwidth"));
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        IDocument iDocument = this.getSourceViewer().getDocument();
        if (iDocument != null && (iDocumentProvider == null || !this.isMyProvider(iDocumentProvider) && !(iDocumentProvider instanceof TextFileDocumentProvider))) {
            iDocumentProvider = this.createDocumentProvider();
            try {
                iDocumentProvider.connect((Object)this.getEditorInput());
                this.setDocumentProvider((IDocumentProvider)this.createDocumentProvider());
            }
            catch (CoreException coreException) {
                XMLPlugin.log(coreException);
            }
        }
        if (iDocument != null) {
            try {
                this.fInitializingDocument = true;
                this.checkPartitioner(iDocument);
                this.documentChanged(iDocument, 0, iDocument.getLength(), 0, true);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.fInitializingDocument = false;
                throw throwable;
            }
            {
                iKeyBindingService = null;
                this.fInitializingDocument = false;
            }
        }
        this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
        iKeyBindingService = this.getEditorSite().getKeyBindingService();
        IEditorActionBarContributor iEditorActionBarContributor = this.getEditorSite().getActionBarContributor();
        if (iEditorActionBarContributor instanceof XMLActionContributor) {
            iKeyBindingService.registerAction(((XMLActionContributor)iEditorActionBarContributor).getOpenDeclarationAction());
        }
        if (this.fPro && !Config.pro()) {
            final Display display = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
            final BaseEditor baseEditor = this;
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    4 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    display.asyncExec(new Runnable(this, baseEditor){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ BaseEditor val$editor;
                        {
                            this.this$1 = var1_1;
                            this.val$editor = baseEditor;
                        }

                        public void run() {
                            OkDialog okDialog = new OkDialog("License Reminder", "Sorry, this feature requires a PRO license.");
                            okDialog.open();
                            VersionAction.promptForLicense();
                            IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            iWorkbenchPage.closeEditor((IEditorPart)this.val$editor, false);
                        }
                    });
                }
            });
            thread.start();
        }
    }

    protected abstract boolean isMyProvider(IDocumentProvider var1);

    protected abstract void checkPartitioner(IDocument var1);

    protected void outlineStateChanged() {
        if (this.fOutlinePage != null && this.fOutlinePage.isVisible()) {
            this.fOutlinePage.setInput(this.getEditorInput(), this.getOutlineTree());
        }
    }

    protected void updateOutlineSelection() {
        if (!XMLPlugin.getDefault().getSyncOutline() || this.fOutlinePage != null && !this.fOutlinePage.isVisible()) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                BaseEditor.this.fUpdating = true;
                try {
                    if (BaseEditor.this.fOutlinePage != null) {
                        BaseEditor.this.fOutlinePage.changeSelection();
                    }
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    BaseEditor.this.fUpdating = false;
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    BaseEditor.this.fUpdating = false;
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContentOutline(int n) {
        if (!XMLPlugin.getDefault().getSyncOutline() || this.fOutlinePage != null && !this.fOutlinePage.isVisible()) {
            return;
        }
        ContentOutlineUpdater contentOutlineUpdater = this.fUpdater;
        synchronized (contentOutlineUpdater) {
            this.fUpdateWakeup = System.currentTimeMillis() + 500L;
            if (this.fUpdating || this.fOutlinePage == null) {
                return;
            }
            this.fUpdating = true;
            this.fTreeOffset = n;
            if (this.fDisplay == null) {
                this.fDisplay = this.getSourceViewer().getTextWidget().getDisplay();
            }
            Thread thread = new Thread(this.fUpdateDelay);
            thread.setPriority((Thread.currentThread().getPriority() + 1) / 2);
            thread.setName("ContentOutlineDelay");
            thread.start();
        }
    }

    private void updateActionSelections() {
        EditorActionDelegate.selectionChanged(this);
    }

    protected Display getDisplay() {
        StyledText styledText;
        Display display = null;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer != null && (styledText = iSourceViewer.getTextWidget()) != null && !styledText.isDisposed()) {
            display = styledText.getDisplay();
        }
        if (display == null && (styledText = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()) != null) {
            display = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
        }
        if (display != null && !display.isDisposed()) {
            return display;
        }
        return null;
    }

    protected void asyncExec(Runnable runnable) {
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOutlineSelection(XMLNode xMLNode, boolean bl) {
        this.fReset = true;
        try {
            StyledText styledText;
            int n = xMLNode.getOffset();
            int n2 = xMLNode.getRange();
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer != null && (styledText = iSourceViewer.getTextWidget()) != null) {
                String string;
                int n3;
                boolean bl2 = styledText.isFocusControl();
                boolean bl3 = bl = bl && !bl2;
                if (bl && (n3 = (string = xMLNode.getQName()).length()) > 0) {
                    try {
                        String string2 = this.getDocument().get(n, Math.min(string.length() + 50, xMLNode.getLength()));
                        int n4 = string2.indexOf(string);
                        if (n4 >= 0) {
                            this.selectAndReveal(n + n4, string.length());
                            bl = false;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        XMLPlugin.log(badLocationException);
                    }
                }
                super.setHighlightRange(n, n2, bl);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.fReset = false;
            throw throwable;
        }
        {
            Object var12_15 = null;
            this.fReset = false;
            return;
        }
    }

    public IDocument getDocument() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer != null) {
            return iSourceViewer.getDocument();
        }
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        if (iDocumentProvider != null) {
            return iDocumentProvider.getDocument((Object)this.getEditorInput());
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetHighlightRange() {
        this.fReset = true;
        try {
            super.resetHighlightRange();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fReset = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fReset = false;
            return;
        }
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = this.createContentOutlinePage();
                if (this.getEditorInput() != null) {
                    this.setOutlineInput(this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(clazz);
    }

    protected void setOutlineInput(Object object) {
        this.fOutlinePage.setInput(object, object == null ? null : this.getOutlineTree());
    }

    protected abstract void documentChanged(Position[] var1, IDocument var2, int var3, int var4, int var5, boolean var6);

    protected void documentChanged(IDocument iDocument, int n, int n2, int n3, boolean bl) {
        Position[] positionArray;
        try {
            positionArray = iDocument.getPositions("com.objfac.partition_category");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            return;
        }
        this.getOutlineTree().updateTree(iDocument, positionArray, n);
        this.updateContentOutline(n);
        this.updateWatchPos(n, n3, n2);
        this.updateResourceListeners();
        if (!this.fInitializingDocument) {
            this.updateDependencyManager();
        }
        this.documentChanged(positionArray, iDocument, n, n2, n3, bl);
        this.checkValidate();
    }

    private void updateDependencyManager() {
        IFile iFile;
        if (this.trackDependencies() && (iFile = this.getFile()) != null) {
            DependencyManager.getSingletonManager().resourceChanged(iFile);
        }
    }

    protected boolean trackDependencies() {
        return true;
    }

    private void updateResourceListeners() {
        XMLResourceManager.getInstance().resourceChanged(this.getUrl());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        IDocument iDocument = this.getDocumentProvider() == null ? null : this.getDocument();
        super.doSetInput(iEditorInput);
        if (this.fOutlinePage != null) {
            this.setOutlineInput(iEditorInput);
        }
        this.fInput = iEditorInput;
        IDocument iDocument2 = this.getDocument();
        if (iDocument == iDocument2) return;
        this.resetParseParams();
        if (iDocument != null) {
            fDocumentEditors.remove(iDocument);
            iDocument.removeDocumentListener((IDocumentListener)this.fDocListener);
        }
        if (iDocument2 == null) return;
        fDocumentEditors.put(iDocument2, this);
        iDocument2.addDocumentListener((IDocumentListener)this.fDocListener);
        if (this.getSourceViewer() == null) return;
        try {
            this.fInitializingDocument = true;
            this.documentChanged(iDocument2, 0, iDocument2.getLength(), 0, true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fInitializingDocument = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.fInitializingDocument = false;
            return;
        }
    }

    protected abstract void resetParseParams();

    public IEditorInput getInput() {
        return this.fInput;
    }

    public static Object getEditorForDocument(IDocument iDocument) {
        return fDocumentEditors.get(iDocument);
    }

    public void setWatchPos(int n) {
        this.fWatchPos = n;
    }

    public int getWatchPos(int n) {
        int n2 = this.fWatchPos;
        this.fWatchPos = n;
        return n2;
    }

    protected void updateWatchPos(int n, int n2, int n3) {
        if (this.fWatchPos > n && (n != 0 || n3 != this.getDocument().getLength() || n2 != 0)) {
            this.fWatchPos = this.fWatchPos < n + n2 ? n : (this.fWatchPos += n3 - n2);
        }
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void contentOutlinePageDisposed() {
        this.fOutlinePage = null;
    }

    protected void setStatusLineErrorMessage(String string) {
        IEditorStatusLine iEditorStatusLine;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iEditorStatusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            iEditorStatusLine.setMessage(true, string, null);
        }
    }

    protected int getParseState() {
        return this.fParseState;
    }

    protected void setParseState(int n) {
        this.fParseState = n;
        this.updateStatus("Parsing");
    }

    protected void updateStatusField(String string) {
        if (string == null) {
            return;
        }
        boolean bl = "Parsing".equals(string);
        boolean bl2 = "Validating".equals(string);
        if (!bl && !bl2) {
            super.updateStatusField(string);
            return;
        }
        IStatusField iStatusField = this.getStatusField(string);
        if (iStatusField != null) {
            String string2 = null;
            Image image = null;
            if (bl) {
                int n = this.getParseState();
                image = null;
                switch (n) {
                    case 0: {
                        string2 = Local.getString((String)"Unparsed");
                        break;
                    }
                    case 1: {
                        string2 = Local.getString((String)"DTD...");
                        break;
                    }
                    case 2: {
                        string2 = Local.getString((String)"XMLSchema...");
                        break;
                    }
                    case 3: {
                        string2 = Local.getString((String)"RelaxNG...");
                        break;
                    }
                    case 4: {
                        string2 = Local.getString((String)"DTD");
                        break;
                    }
                    case 5: {
                        string2 = Local.getString((String)"XMLSchema");
                        break;
                    }
                    case 6: {
                        string2 = Local.getString((String)"RelaxNG");
                        break;
                    }
                    case 7: {
                        string2 = Local.getString((String)"?DTD");
                        break;
                    }
                    case 8: {
                        string2 = Local.getString((String)"?Schema");
                        break;
                    }
                    case 9: {
                        string2 = Local.getString((String)"?RelaxNG");
                        break;
                    }
                    case 10: {
                        string2 = Local.getString((String)"Auto...");
                        break;
                    }
                    case 11: {
                        string2 = Local.getString((String)"Auto");
                        break;
                    }
                    case 12: {
                        string2 = Local.getString((String)"?Auto");
                    }
                }
            } else if (bl2) {
                if (this.isValidateInProgress()) {
                    string2 = Local.getString((String)"Checking...");
                    image = null;
                } else {
                    string2 = Local.getString((String)"Checked");
                    image = null;
                }
            }
            iStatusField.setText(string2 == null ? this.fErrorLabel : string2);
            iStatusField.setImage(image);
        }
    }

    protected abstract void verifyKey(VerifyEvent var1);

    void setSelection(ISourceViewer iSourceViewer, int n, int n2) {
        iSourceViewer.setSelectedRange(n, n2 - n);
    }

    void setSelection(ISourceViewer iSourceViewer, int n, int n2, boolean bl) {
        iSourceViewer.setSelectedRange(n, n2 - n);
        if (bl) {
            iSourceViewer.getTextWidget().setSelectionRange(n2, n - n2);
        }
    }

    protected Point getSelection() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return null;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        iSourceViewer.getDocument();
        Point point = styledText.getSelection();
        return point;
    }

    protected Point getSelectionRange() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return null;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        iSourceViewer.getDocument();
        Point point = styledText.getSelectionRange();
        return point;
    }

    protected void selectLeft() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        StyledText styledText = iSourceViewer.getTextWidget();
        IDocument iDocument = iSourceViewer.getDocument();
        Point point = styledText.getSelection();
        int n = styledText.getCaretOffset();
        if (n == point.x) {
            point.x = this.posLeft(iDocument, point.x);
            this.setSelection(iSourceViewer, point.x, point.y, true);
        } else if (n == point.y) {
            point.y = this.posLeft(iDocument, point.y);
            if (point.y < point.x) {
                this.setSelection(iSourceViewer, point.y, point.x, true);
            } else {
                this.setSelection(iSourceViewer, point.x, point.y, false);
            }
        }
    }

    protected void selectRight() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        StyledText styledText = iSourceViewer.getTextWidget();
        Point point = styledText.getSelection();
        IDocument iDocument = iSourceViewer.getDocument();
        int n = styledText.getCaretOffset();
        if (n == point.x) {
            point.x = this.posRight(iDocument, point.x);
            if (point.x < point.y) {
                this.setSelection(iSourceViewer, point.x, point.y, true);
            } else {
                this.setSelection(iSourceViewer, point.y, point.x, false);
            }
        } else if (n == point.y) {
            point.y = this.posRight(iDocument, point.y);
            this.setSelection(iSourceViewer, point.x, point.y, false);
        }
    }

    protected void moveLeft() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        StyledText styledText = iSourceViewer.getTextWidget();
        Point point = styledText.getSelection();
        IDocument iDocument = iSourceViewer.getDocument();
        int n = this.posLeft(iDocument, point.x);
        if (n < point.x) {
            this.setSelection(iSourceViewer, n, n);
        }
    }

    protected void moveRight() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        StyledText styledText = iSourceViewer.getTextWidget();
        Point point = styledText.getSelection();
        IDocument iDocument = iSourceViewer.getDocument();
        int n = this.posRight(iDocument, point.y);
        if (n > point.y) {
            this.setSelection(iSourceViewer, n, n);
        }
    }

    protected void selectRight(IDocument iDocument, Point point) {
        if (point.x != point.y) {
            point.y = this.posRight(iDocument, point.y);
            if (point.y < point.x) {
                this.swap(point);
            }
        } else {
            point.x = this.posLeft(iDocument, point.x);
        }
    }

    protected void selectLeft(IDocument iDocument, Point point) {
        if (point.x != point.y) {
            point.y = this.posLeft(iDocument, point.y);
            if (point.y < point.x) {
                this.swap(point);
            }
        } else {
            point.x = this.posLeft(iDocument, point.x);
        }
    }

    protected void swap(Point point) {
        int n = point.x;
        point.x = point.y;
        point.y = n;
    }

    public void shiftLeft() {
        ISourceViewer iSourceViewer = this.getViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        Point point = iSourceViewer.getSelectedRange();
        try {
            char[] cArray = iDocument.get(point.x, point.y).toCharArray();
            int n = this.getSourceViewerConfiguration().getTabWidth(iSourceViewer);
            int n2 = this.fTabber.computeMinShiftCount(cArray);
            if (n2 > 0) {
                StringBuffer stringBuffer = this.doShift(iDocument, point, n, cArray, -n2);
                iDocument.replace(point.x, point.y, stringBuffer.toString());
                iSourceViewer.setSelectedRange(point.x, stringBuffer.length());
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
    }

    protected StringBuffer doShift(IDocument iDocument, Point point, int n, char[] cArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = cArray.length;
        char c = '\u0000';
        int[] nArray = new int[2];
        while (n3 < n4) {
            this.fTabber.countLeadingWhitespace(cArray, n3, nArray);
            stringBuffer.append(this.fTabber.countToString(nArray[0] + n2));
            n3 = nArray[1];
            while (n3 < n4 && (c = cArray[n3]) != '\r' && c != '\n') {
                stringBuffer.append(c);
                ++n3;
            }
            if (n3 >= n4) continue;
            stringBuffer.append(c);
            if (c == '\r' && n3 + 1 < n4 && cArray[n3 + 1] == '\n') {
                stringBuffer.append('\n');
                ++n3;
            }
            ++n3;
        }
        return stringBuffer;
    }

    public void shiftRight() {
        ISourceViewer iSourceViewer = this.getViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        Point point = iSourceViewer.getSelectedRange();
        try {
            char[] cArray = iDocument.get(point.x, point.y).toCharArray();
            int n = this.fTabber.getTabWidth();
            StringBuffer stringBuffer = this.doShift(iDocument, point, n, cArray, n);
            iDocument.replace(point.x, point.y, stringBuffer.toString());
            iSourceViewer.setSelectedRange(point.x, stringBuffer.length());
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
    }

    public void insertTab() {
        ISourceViewer iSourceViewer = this.getViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        Point point = iSourceViewer.getSelectedRange();
        try {
            iDocument.replace(point.x, point.y, this.fTabber.getTab());
            iSourceViewer.setSelectedRange(point.x + 1, 0);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
    }

    public void tabRight() {
        ISourceViewer iSourceViewer = this.getViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        Point point = iSourceViewer.getSelectedRange();
        try {
            String string = this.getLineStart(iDocument, point.x);
            if (string != null) {
                String string2 = this.fTabber.tabIn(string);
                IRegion iRegion = iDocument.getLineInformationOfOffset(point.x);
                iDocument.replace(iRegion.getOffset(), point.x + point.y - iRegion.getOffset(), string2);
                iSourceViewer.setSelectedRange(iRegion.getOffset() + string2.length(), 0);
            } else {
                int n = this.posRight(iDocument, point.x + point.y);
                iSourceViewer.setSelectedRange(n, 0);
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
    }

    protected String getLineStart(IDocument iDocument, int n) {
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            if (iRegion.getOffset() == n) {
                return "";
            }
            String string = iDocument.get(iRegion.getOffset(), n - iRegion.getOffset());
            if (XMLCharacter.isWhitespace((String)string)) {
                return string;
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        return null;
    }

    public void tabLeft() {
        ISourceViewer iSourceViewer = this.getViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        Point point = iSourceViewer.getSelectedRange();
        int n = this.posLeft(iDocument, point.x);
        iSourceViewer.setSelectedRange(n, 0);
    }

    public void resourceChanged(String string) {
        ++this.fDeferredUpdate;
    }

    public void startedWatching(String string) {
        if (this.trackDependencies()) {
            DependencyManager.getSingletonManager().startedWatching(string);
        }
    }

    public ResourceWatcherCallback getResourceWatcherCallback() {
        return this.fResourceCallback;
    }

    public void setFocus() {
        super.setFocus();
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer != null && iSourceViewer.getTextWidget() != null) {
            this.checkDeferredUpdate();
        }
    }

    private void checkDeferredUpdate() {
        if (this.fDeferredUpdate > 0) {
            this.fDeferredUpdate = 0;
            this.checkValidate();
            this.updateContentAssist();
        }
    }

    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        BaseUtils.performSaveAs(iProgressMonitor, this.info);
    }

    public IFile getFile() {
        IEditorInput iEditorInput = this.getEditorInput();
        IFile iFile = null;
        if (iEditorInput != null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iFile = (IFile)iEditorInput.getAdapter((Class)clazz);
        }
        return iFile;
    }

    public void propertiesChanged(IFile iFile) {
        this.resourceChanged(iFile.getName());
    }

    protected IAnnotationAccess createAnnotationAccess() {
        IAnnotationAccess iAnnotationAccess = super.createAnnotationAccess();
        return iAnnotationAccess;
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        Action action;
        super.editorContextMenuAboutToShow(iMenuManager);
        iMenuManager.insertAfter("group.undo", (IContributionItem)new Separator("group.open"));
        iMenuManager.insertAfter("group.open", (IContributionItem)new Separator("group.show"));
        iMenuManager.insertAfter("group.show", (IContributionItem)new Separator("group.navigate"));
        iMenuManager.insertAfter("group.navigate", (IContributionItem)new Separator("group.generate"));
        if (Config.pro() && this.getEditorKind() != 0 && this.getEditorKind() != 6) {
            action = this.getGenerateXMLAction();
            iMenuManager.appendToGroup("group.generate", (IAction)action);
        }
        if (Config.pro() && this.canOpenDefinition()) {
            iMenuManager.appendToGroup("group.open", this.getGotoDefinitionAction());
        }
        if (this.canOpenSchema()) {
            action = this.getOpenSchemaAction();
            action.setText(this.hasDtd() ? Local.getString((String)"Open DTD") : Local.getString((String)"Open Schema"));
            iMenuManager.appendToGroup("group.open", (IAction)action);
        }
        if (this.canOpenUri()) {
            iMenuManager.appendToGroup("group.open", this.getOpenUriAction());
        }
    }

    protected abstract XMLNode findNode(int var1);

    public IAction getOpenUriAction() {
        if (this.fOpenUriAction == null) {
            this.fOpenUriAction = new OpenUriAction();
        }
        return this.fOpenUriAction;
    }

    public abstract boolean canOpenUri();

    public abstract void openUri();

    public void openUri(String string) {
        String string2 = WizardUtils.getEditorId(string);
        if (string2 != null) {
            this.openEditor(string, string2);
        }
    }

    private GenerateXMLAction getGenerateXMLAction() {
        if (this.fGenerateXMLAction == null) {
            this.fGenerateXMLAction = new GenerateXMLAction(this);
        }
        return this.fGenerateXMLAction;
    }

    protected boolean canOpenSchema() {
        return false;
    }

    protected void openSchema() {
    }

    public boolean canOpenDefinition() {
        return false;
    }

    public void openDefinition() {
    }

    protected boolean hasDtd() {
        return false;
    }

    private boolean findDefinition(String string, DefinitionTarget definitionTarget) {
        return false;
    }

    private OpenSchemaAction getOpenSchemaAction() {
        if (this.fOpenSchemaAction == null) {
            this.fOpenSchemaAction = new OpenSchemaAction();
        }
        return this.fOpenSchemaAction;
    }

    public IAction getGotoDefinitionAction() {
        if (this.fGotoDefinitionAction == null) {
            this.fGotoDefinitionAction = new GotoDefinitionAction();
        }
        return this.fGotoDefinitionAction;
    }

    public IEditorPart showEditor(String string, String string2, int n, int n2) {
        IEditorPart iEditorPart = this.openEditor(string, string2);
        if (iEditorPart != null && iEditorPart instanceof ITextEditor) {
            ((ITextEditor)iEditorPart).selectAndReveal(n, n2);
        }
        return iEditorPart;
    }

    public IEditorPart openEditor(String string, String string2) {
        IEditorPart iEditorPart = null;
        try {
            ExternalEntity externalEntity = new ExternalEntity(null, null, this.getUrl(), (IDocumentReaderFactory)DefaultDocumentReaderFactory.getFactory());
            IExternalEntity iExternalEntity = externalEntity.getEntity(null, string);
            String string3 = iExternalEntity.getAbsUrl();
            IFile iFile = BaseEditor.uriToIFile(string3);
            if (iFile != null) {
                iEditorPart = this.openEditor(iFile, string2);
            } else if (!string3.startsWith("file:")) {
                char[] cArray = iExternalEntity.getContents();
                iEditorPart = this.getStorageEditor(string3, string2, cArray);
            } else {
                iEditorPart = this.getNonWorkspaceEditor(string3, string2);
            }
        }
        catch (UnknownPublicIdentifierException unknownPublicIdentifierException) {
            XMLPlugin.log(unknownPublicIdentifierException);
        }
        catch (IOException iOException) {
            this.showErrorDialog(Local.getString((String)"Error"), Local.format((String)"IO exception opening editor at {0}", (Object)string), iOException);
        }
        return iEditorPart;
    }

    protected int showErrorDialog(String string, String string2, Exception exception) {
        StyledText styledText;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer != null && (styledText = iSourceViewer.getTextWidget()) != null) {
            Shell shell = styledText.getShell();
            String string3 = exception.getLocalizedMessage();
            if (string3 == null) {
                string3 = string2;
            }
            Status status = new Status(4, "com.objfac.xmleditor", 0, string3, (Throwable)exception);
            return ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)status);
        }
        return -1;
    }

    public IEditorPart findEditor(String string, String string2) {
        IEditorPart iEditorPart = null;
        try {
            ExternalEntity externalEntity = new ExternalEntity(null, null, this.getUrl(), (IDocumentReaderFactory)DefaultDocumentReaderFactory.getFactory());
            IExternalEntity iExternalEntity = externalEntity.getEntity(null, string);
            String string3 = iExternalEntity.getAbsUrl();
            IFile iFile = BaseEditor.uriToIFile(string3);
            if (iFile != null) {
                iEditorPart = BaseEditor.findEditor(iFile);
            }
        }
        catch (UnknownPublicIdentifierException unknownPublicIdentifierException) {
            XMLPlugin.log(unknownPublicIdentifierException);
        }
        return iEditorPart;
    }

    public IEditorPart findEditor(String string) {
        IEditorPart iEditorPart = null;
        try {
            ExternalEntity externalEntity = new ExternalEntity(null, null, this.getUrl(), (IDocumentReaderFactory)DefaultDocumentReaderFactory.getFactory());
            IExternalEntity iExternalEntity = externalEntity.getEntity(null, string);
            String string2 = iExternalEntity.getAbsUrl();
            IFile iFile = BaseEditor.uriToIFile(string2);
            if (iFile != null) {
                iEditorPart = BaseEditor.findEditor(iFile);
            }
        }
        catch (UnknownPublicIdentifierException unknownPublicIdentifierException) {
            XMLPlugin.log(unknownPublicIdentifierException);
        }
        return iEditorPart;
    }

    public static IEditorPart findExistingEditor(String string) {
        IEditorPart iEditorPart = null;
        IFile iFile = BaseEditor.uriToIFile(string);
        if (iFile != null) {
            iEditorPart = BaseEditor.findEditor(iFile);
        }
        return iEditorPart;
    }

    public static long getMod(String string) {
        long l = 0L;
        IFile iFile = BaseEditor.uriToIFile(string);
        if (iFile != null) {
            BaseEditor baseEditor = BaseEditor.findBaseEditor(iFile);
            l = baseEditor != null ? baseEditor.fValidateTime : iFile.getModificationStamp();
        } else if (string.startsWith("file:")) {
            String string2 = Misc.fileUrlToPath((String)string);
            File file = new File(string2);
            l = file.lastModified();
        }
        return l;
    }

    public XMLNode findHead(String string) {
        BaseEditor baseEditor;
        IOutlineTree iOutlineTree;
        IEditorPart iEditorPart = this.findEditor(string);
        if (iEditorPart instanceof BaseEditor && (iOutlineTree = (baseEditor = (BaseEditor)iEditorPart).getOutlineTree()) != null) {
            return iOutlineTree.getHead();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BaseEditor findBaseEditor(IFile iFile) {
        LinkedList linkedList = fEditors;
        synchronized (linkedList) {
            IPath iPath = iFile.getLocation();
            Iterator iterator = fEditors.iterator();
            while (iterator.hasNext()) {
                BaseEditor baseEditor = (BaseEditor)iterator.next();
                IEditorInput iEditorInput = baseEditor.getEditorInput();
                if (iEditorInput == null || !(iEditorInput instanceof IPathEditorInput) || !((IPathEditorInput)iEditorInput).getPath().equals((Object)iPath)) continue;
                return baseEditor;
            }
        }
        return null;
    }

    public static BaseEditor findEditor(IDocument iDocument) {
        Iterator iterator = fEditors.iterator();
        while (iterator.hasNext()) {
            BaseEditor baseEditor = (BaseEditor)iterator.next();
            ISourceViewer iSourceViewer = baseEditor.getSourceViewer();
            if (iSourceViewer == null || iSourceViewer.getDocument() != iDocument) continue;
            return baseEditor;
        }
        return null;
    }

    public boolean showEditor(String string, String string2, char[] cArray, int n, int n2) {
        IEditorPart iEditorPart = null;
        IFile iFile = BaseEditor.uriToIFile(string);
        iEditorPart = iFile != null ? this.openEditor(iFile, string2) : (!string.startsWith("file:") ? this.getStorageEditor(string, string2, cArray) : this.getNonWorkspaceEditor(string, string2));
        if (iEditorPart != null && iEditorPart instanceof ITextEditor) {
            ((ITextEditor)iEditorPart).selectAndReveal(n, n2);
            return true;
        }
        return false;
    }

    protected IEditorPart getNonWorkspaceEditor(String string, String string2) {
        IEditorPart iEditorPart = null;
        String string3 = Misc.fileUrlToPath((String)string);
        try {
            iEditorPart = ActionUtils.openFile(string3, string2);
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
        }
        return iEditorPart;
    }

    protected IEditorPart getStorageEditor(String string, String string2, char[] cArray) {
        IEditorPart iEditorPart = null;
        String string3 = Misc.getName((String)string);
        IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorInput iEditorInput;
            IEditorPart iEditorPart2;
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            if (string3.equals(iEditorReference.getName()) && (iEditorPart2 = iEditorReference.getEditor(true)) != null && (iEditorInput = iEditorPart2.getEditorInput()) instanceof Storage && string.equals(((Storage)iEditorInput).getOldName())) {
                iEditorPart = iEditorPart2;
                iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
                break;
            }
            ++n;
        }
        if (iEditorPart == null) {
            Storage storage = new Storage(cArray, string3, string, "UTF-8");
            try {
                iEditorPart = iWorkbenchPage.openEditor((IEditorInput)storage, string2);
            }
            catch (PartInitException partInitException) {
                XMLPlugin.log(partInitException);
            }
        }
        return iEditorPart;
    }

    protected IEditorPart openEditor(IFile iFile, String string) {
        IEditorPart iEditorPart = null;
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            iEditorPart = iWorkbenchPage.findEditor((IEditorInput)fileEditorInput);
            if (iEditorPart != null) {
                iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            } else {
                try {
                    iEditorPart = iWorkbenchPage.openEditor((IEditorInput)fileEditorInput, string);
                }
                catch (PartInitException partInitException) {
                    XMLPlugin.log(partInitException);
                }
            }
        }
        return iEditorPart;
    }

    public static IEditorPart findEditor(IFile iFile) {
        IWorkbenchPage iWorkbenchPage;
        IEditorPart iEditorPart = null;
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        IWorkbenchWindow iWorkbenchWindow = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            iEditorPart = iWorkbenchPage.findEditor((IEditorInput)fileEditorInput);
        }
        return iEditorPart;
    }

    public static IFile uriToIFile(String string) {
        IWorkspace iWorkspace;
        IFile iFile = null;
        if (string.startsWith("file:") && (iWorkspace = XMLPlugin.getWorkspace()) != null) {
            IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
            String string2 = Misc.fileUrlToPath((String)string);
            Path path = new Path(string2);
            iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
        }
        return iFile;
    }

    protected void createActions() {
        super.createActions();
    }

    private synchronized void updateSelectListeners() {
        if (this.fNotifyingSelectListeners) {
            return;
        }
        Display display = this.getDisplay();
        if (display != null) {
            this.fNotifyingSelectListeners = true;
            display.asyncExec((Runnable)this.fSelectNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySelectListeners() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.objfac.xmleditor.BaseEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (fSelectListeners == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            SelectListener[] selectListenerArray = fSelectListeners.toArray(new SelectListener[fSelectListeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int n = 0;
            int n2 = selectListenerArray.length;
            while (n < n2) {
                block11: {
                    try {
                        selectListenerArray[n].selectionChanged(this);
                    }
                    catch (Throwable throwable) {
                        XMLPlugin.log(throwable);
                        if (!(throwable instanceof Error)) break block11;
                        throw (Error)throwable;
                    }
                }
                ++n;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSelectListener(SelectListener selectListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.objfac.xmleditor.BaseEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (fSelectListeners == null) {
                fSelectListeners = new LinkedList();
            }
            fSelectListeners.add(selectListener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSelectListener(SelectListener selectListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.objfac.xmleditor.BaseEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (fSelectListeners != null) {
                fSelectListeners.remove(selectListener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class EndValidate
    implements Runnable {
        private XMLValidationShell shell;

        public EndValidate(XMLValidationShell xMLValidationShell) {
            this.shell = xMLValidationShell;
        }

        public void run() {
            if (!BaseEditor.this.fCancelValidate) {
                IWalker iWalker = this.shell.getWalker();
                if (iWalker != null) {
                    BaseEditor.this.setWalker(iWalker);
                }
                if (BaseEditor.this.getDisplay() != null && BaseEditor.this.autoValidate()) {
                    this.shell.showValidateErrors(BaseEditor.this);
                    BaseEditor.this.updateStatus("Validating");
                }
            }
        }
    }

    protected class PartListener
    implements IPartListener2 {
        protected PartListener() {
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference.getId().equals("org.eclipse.ui.views.ContentOutline")) {
                BaseEditor.this.outlineStateChanged();
            }
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }
    }

    protected class PositionListener
    extends KeyAdapter
    implements MouseListener {
        protected PositionListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (!BaseEditor.this.fReset) {
                BaseEditor.this.updateOutlineSelection();
            }
            BaseEditor.this.updateSelectListeners();
        }

        public void keyReleased(KeyEvent keyEvent) {
            BaseEditor.fMatchKey.chr = keyEvent.character;
            BaseEditor.fMatchKey.keycode = keyEvent.keyCode;
            BaseEditor.fMatchKey.mask = keyEvent.stateMask;
            if (BaseEditor.this.fCursorKeys.contains(fMatchKey)) {
                if (!BaseEditor.this.fReset) {
                    BaseEditor.this.updateOutlineSelection();
                }
                BaseEditor.this.updateSelectListeners();
            }
        }
    }

    protected static class Key {
        public char chr;
        public int keycode;
        public int mask;

        public Key(int n, int n2, int n3) {
            this.chr = (char)n;
            this.keycode = n2;
            this.mask = n3;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            return key.chr == this.chr && key.keycode == this.keycode && key.mask == this.mask;
        }

        public int hashCode() {
            return this.chr + this.keycode + this.mask;
        }
    }

    protected class ContentOutlineDelay
    implements Runnable {
        protected ContentOutlineDelay() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ContentOutlineUpdater contentOutlineUpdater = BaseEditor.this.fUpdater;
                synchronized (contentOutlineUpdater) {
                    long l;
                    while ((l = System.currentTimeMillis()) < BaseEditor.this.fUpdateWakeup) {
                        BaseEditor.this.fUpdater.wait(BaseEditor.this.fUpdateWakeup - l);
                    }
                }
                BaseEditor.this.asyncExec(BaseEditor.this.fUpdater);
            }
            catch (InterruptedException interruptedException) {
                XMLPlugin.log(interruptedException);
            }
        }
    }

    protected class ContentOutlineUpdater
    implements Runnable {
        protected ContentOutlineUpdater() {
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 166->170)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class DPL
    implements IDocumentPartitioningListener,
    IDocumentPartitioningListenerExtension {
        DPL() {
        }

        public void documentPartitioningChanged(IDocument iDocument) {
        }

        public void documentPartitioningChanged(IDocument iDocument, IRegion iRegion) {
        }
    }

    class DL
    implements IDocumentListener {
        DL() {
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            ++BaseEditor.this.cntChange;
        }

        public void documentChanged(DocumentEvent documentEvent) {
            BaseEditor.this.documentChanged(documentEvent.getDocument(), documentEvent.getOffset(), documentEvent.getText() == null ? 0 : documentEvent.getText().length(), documentEvent.getLength(), false);
        }
    }

    protected class XMLVerifyListener
    implements VerifyKeyListener {
        protected XMLVerifyListener() {
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            BaseEditor.this.verifyKey(verifyEvent);
            if (!verifyEvent.doit) {
                return;
            }
            if (verifyEvent.stateMask == 262144 && verifyEvent.keyCode == 0x1000003) {
                BaseEditor.this.moveLeft();
                verifyEvent.doit = false;
            } else if (verifyEvent.stateMask == 262144 && verifyEvent.keyCode == 0x1000004) {
                BaseEditor.this.moveRight();
                verifyEvent.doit = false;
            } else if (verifyEvent.stateMask == 393216 && verifyEvent.keyCode == 0x1000003) {
                BaseEditor.this.selectLeft();
                verifyEvent.doit = false;
            } else if (verifyEvent.stateMask == 393216 && verifyEvent.keyCode == 0x1000004) {
                BaseEditor.this.selectRight();
                verifyEvent.doit = false;
            }
        }
    }

    private static class AnnotationAccessWrapper
    implements IAnnotationAccess {
        IAnnotationAccess base;

        public AnnotationAccessWrapper(IAnnotationAccess iAnnotationAccess) {
            this.base = iAnnotationAccess;
        }

        public Object getType(Annotation annotation) {
            if (BaseDocumentProvider.isCheckMarker(annotation)) {
                return "org.eclipse.ui.workbench.texteditor.warning";
            }
            return this.base.getType(annotation);
        }

        public boolean isMultiLine(Annotation annotation) {
            return this.base.isMultiLine(annotation);
        }

        public boolean isTemporary(Annotation annotation) {
            return this.base.isTemporary(annotation);
        }
    }

    private class OpenUriAction
    extends Action {
        public OpenUriAction() {
            this.setText(Local.getString((String)"OpenURI.label"));
            this.setId("com.objfac.xmleditor.open.uri");
            this.setAccelerator(393301);
        }

        public void run() {
            BaseEditor.this.openUri();
        }
    }

    private class OpenSchemaAction
    extends Action {
        public OpenSchemaAction() {
            this.setText(Local.getString((String)"Open Schema"));
        }

        public void run() {
            BaseEditor.this.openSchema();
        }
    }

    private class GotoDefinitionAction
    extends Action {
        public GotoDefinitionAction() {
            this.setText(Local.getString((String)"Open Definition"));
            this.setId("com.objfac.xmleditor.open.editor");
            this.setAccelerator(65604);
        }

        public void run() {
            BaseEditor.this.openDefinition();
        }
    }

    private class SelectNotify
    implements Runnable {
        SelectNotify() {
        }

        public void run() {
            BaseEditor.this.notifySelectListeners();
            BaseEditor.this.updateActionSelections();
            BaseEditor.this.fNotifyingSelectListeners = false;
        }
    }

    private class TextSelectionListener
    implements SelectionListener {
        TextSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            BaseEditor.this.updateSelectListeners();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }
}

