/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.xmleditor.IEditorEnvironment;
import com.objfac.xmleditor.XMLPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public abstract class BaseEditorEnvironment
implements IEditorEnvironment {
    private HashMap fImageMap;
    private URL fInstallUrl = XMLPlugin.getDefault().getDescriptor().getInstallURL();
    protected int fgRefCount = 0;

    public void connect(Object object) {
        if (++this.fgRefCount == 1) {
            this.fImageMap = new HashMap();
            this.initialize();
        }
    }

    public void disconnect(Object object) {
        if (--this.fgRefCount == 0) {
            this.disposeImages();
            this.clear();
        }
    }

    protected abstract void initialize();

    protected abstract void clear();

    public Image getImage(String string) {
        Image image = (Image)this.fImageMap.get(string);
        if (image == null) {
            try {
                URL uRL = new URL(this.fInstallUrl, string);
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
                image = imageDescriptor.createImage();
                this.fImageMap.put(string, image);
            }
            catch (MalformedURLException malformedURLException) {
                XMLPlugin.log(malformedURLException);
            }
        }
        return image;
    }

    private void disposeImages() {
        if (this.fImageMap != null) {
            Iterator iterator = this.fImageMap.values().iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.dispose();
            }
            this.fImageMap = null;
        }
    }
}

