/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.util.TabCalculator;
import com.objfac.xmleditor.IEditorEnvironment;
import com.objfac.xmleditor.NotifyingUndoManager;
import com.objfac.xmleditor.XMLPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class BaseSourceViewerConfiguration
extends SourceViewerConfiguration {
    private NotifyingUndoManager fUndoManager;
    protected IEditorEnvironment fEnv;
    protected ContentAssistant assistant;
    private TabCalculator fTabCalculator;

    public BaseSourceViewerConfiguration(IEditorEnvironment iEditorEnvironment, TabCalculator tabCalculator) {
        this.fEnv = iEditorEnvironment;
        this.fTabCalculator = tabCalculator;
    }

    public void resetAssistant() {
        IPreferenceStore iPreferenceStore = this.fEnv.getStore();
        this.assistant.enableAutoActivation(iPreferenceStore.getBoolean("com.objfac.xmleditor.autoassist"));
        this.assistant.setAutoActivationDelay(iPreferenceStore.getInt("com.objfac.xmleditor.assistdelay"));
        this.assistant.enableAutoInsert(iPreferenceStore.getBoolean("com.objfac.xmleditor.autoinsert"));
    }

    public void setTabCalculator(TabCalculator tabCalculator) {
        this.fTabCalculator = tabCalculator;
    }

    public int getTabWidth(ISourceViewer iSourceViewer) {
        return this.fTabCalculator.getTabWidth();
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        return this.fTabCalculator.calculateIndentPrefixes();
    }

    public IUndoManager getUndoManager(ISourceViewer iSourceViewer) {
        if (this.fUndoManager == null) {
            this.fUndoManager = new NotifyingUndoManager(XMLPlugin.getDefault().getPreferenceStore().getInt("com.objfac.xmleditor.undolevels"));
        }
        return this.fUndoManager;
    }
}

