/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.rnceditor.RNCConstants;
import com.objfac.rnceditor.RNCEditorEnvironment;
import com.objfac.util.Bits;
import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.xml.io.DefaultDocumentReaderFactory;
import com.objfac.xml.io.DocumentCache;
import com.objfac.xml.io.FileDocumentStore;
import com.objfac.xml.io.IDocumentStore;
import com.objfac.xml.io.ILogger;
import com.objfac.xml.io.ResolverConfiguration;
import com.objfac.xml.io.ResolverExtension;
import com.objfac.xml.io.URLDocumentStore;
import com.objfac.xmleditor.XMLEditorEnvironment;
import com.objfac.xmleditor.XMLTextTools;
import com.objfac.xmleditor.actions.DependencyManager;
import com.objfac.xmleditor.preferences.XMLEncodingHandler;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.util.XMLColorProvider;
import com.objfac.xmleditor.validate.Validator;
import com.objfac.xmleditor.validate.ValidatorLoader;
import com.objfac.xmleditor.validate.XercesValidator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class XMLPlugin
extends AbstractUIPlugin {
    public static final int LITEMASK = 1;
    public static final int PROMASK = 2;
    public static final long PRO = 0x200000000L;
    public static long cap = 0L;
    private RNCEditorEnvironment fRNCEnv;
    public static final String PLUGIN_ID = "com.objfac.xmleditor";
    public static final String RESOLVER_EXTENSION = "resolver";
    public static final int CONVERT_FAILED_CODE = 1;
    public static final int TRANSFORM_OUTPUT_CODE = 2;
    private static XMLPlugin fPlugin;
    private static XMLEditorEnvironment fEnv;
    public static final String XERCES_VALIDATOR_CLASS = "com.objfac.xmleditor.xerces.XercesValidator";
    private static ResourceBundle fResourceBundle;
    private static final String CACHE_DIR = ".cache/";
    private String fCacheUrl;
    public static int log;
    static String ANY_ORDER;
    static String[] ORDERS;
    static int ORDER_ANY;
    private ResolverConfiguration[] configs;
    private static Logger fLogger;
    private static XMLEncodingHandler fEncodingHandler;

    static {
        Local.pushListener((Local.LocalListener)new Local.LocalListener(){

            public ResourceBundle getBundle() {
                return fResourceBundle;
            }
        });
        ANY_ORDER = "any";
        ORDERS = new String[]{"first", ANY_ORDER, "last"};
        ORDER_ANY = 1;
        fLogger = new Logger();
        fEncodingHandler = new XMLEncodingHandler();
    }

    public XMLPlugin() {
        fPlugin = this;
    }

    public XMLPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        fResourceBundle = iPluginDescriptor.getResourceBundle();
        fPlugin = this;
        fEnv = new XMLEditorEnvironment(new XMLTextTools(this.getPreferenceStore()));
        this.initializeDefaultPreferences(this.getPreferenceStore());
        this.initializeCache();
        this.initializeExtensionPoints();
        this.initializeSchemaCache();
        this.initializeDelta();
        this.initializeDependencies();
        this.fRNCEnv = new RNCEditorEnvironment(this.getPreferenceStore());
        this.initializeConfig();
        this.initializeMappings();
    }

    private void initializeCache() {
        boolean bl = this.getPreferenceStore().getBoolean("com.objfac.xmleditor.cacheon");
        DocumentCache.getCache().enableCache(bl);
    }

    private void initializeExtensionPoints() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, RESOLVER_EXTENSION);
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            iConfigurationElement.getName();
            ++n;
        }
        DefaultDocumentReaderFactory defaultDocumentReaderFactory = DefaultDocumentReaderFactory.getFactory();
        defaultDocumentReaderFactory.setLogger((ILogger)new Logger());
        defaultDocumentReaderFactory.setResolverConfiguration(this.configs);
        this.configs = null;
    }

    private void addResolver(ResolverExtension resolverExtension, int n, String string) {
        if (this.configs == null) {
            this.configs = new ResolverConfiguration[1];
            this.configs[0] = new ResolverConfiguration(resolverExtension, n, string);
            return;
        }
        int n2 = this.configs.length;
        int n3 = 0;
        while (n3 < this.configs.length) {
            if (this.configs[n3].getIorder() > n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n != ORDER_ANY && n2 > 0 && this.configs[n2 - 1].getIorder() == n) {
            XMLPlugin.log("Duplicate " + ORDERS[n] + " resolvers " + this.configs[n2 - 1].getId() + " and " + string);
        }
        ResolverConfiguration[] resolverConfigurationArray = new ResolverConfiguration[this.configs.length + 1];
        System.arraycopy(this.configs, 0, resolverConfigurationArray, 0, n2);
        resolverConfigurationArray[n2] = new ResolverConfiguration(resolverExtension, n, string);
        System.arraycopy(this.configs, n2, resolverConfigurationArray, n2 + 1, this.configs.length - n2);
        this.configs = resolverConfigurationArray;
    }

    private void initializeMappings() {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            iWorkbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Preferences preferences = XMLPlugin.this.getPluginPreferences();
                    boolean bl = preferences.getBoolean("com.objfac.editors_mapped");
                    if (!bl) {
                        preferences.setValue("com.objfac.editors_mapped", true);
                        IEditorRegistry iEditorRegistry = XMLPlugin.this.getWorkbench().getEditorRegistry();
                        IFileEditorMapping[] iFileEditorMappingArray = iEditorRegistry.getFileEditorMappings();
                        int n = 0;
                        int n2 = iFileEditorMappingArray.length;
                        while (n < n2) {
                            IEditorDescriptor iEditorDescriptor;
                            IFileEditorMapping iFileEditorMapping = iFileEditorMappingArray[n];
                            String string = iFileEditorMapping.getExtension();
                            int n3 = XMLConstants.extensionToKind(string);
                            if (n3 > 0 && ((iEditorDescriptor = iFileEditorMapping.getDefaultEditor()) == null || "com.objfac.xmleditor.XMLEditor".equals(iEditorDescriptor.getId()))) {
                                iEditorRegistry.setDefaultEditor("*." + string, XMLConstants.kindToId(n3));
                            }
                            ++n;
                        }
                    }
                }
            });
        }
    }

    private void initializeConfig() {
    }

    private void in() {
        block5: {
            String string = "4150862358339019129777390252052779343003038941466964679371079054060934387406275427450403669767288197141263677206558923064977569554508980021994681385267247869389528026718255835494349640529570272334329140204940879818332754888784472951891867507";
            String string2 = "11";
            new BigInteger(string);
            new BigInteger(string2);
            cap = 0L;
            string = Misc.relPathToAbsUrl((String)string2, (String)string);
            try {
                byte[] byArray = this.a();
                if (byArray != null && byArray[0] != 35) {
                    String string3;
                    char[] cArray = new char[byArray.length];
                    int n = 0;
                    while (n < byArray.length) {
                        cArray[n] = (char)(byArray[n] & 0xFF);
                        ++n;
                    }
                    String string4 = new String(cArray);
                    if (this.wfk(string4) && Bits.sum((String)(string3 = Misc.relPathToAbsUrl((String)string4))) % 77 == 0 && string3.charAt(string3.length() - 2) == 'p') {
                        cap = 0x200000000L;
                    }
                }
            }
            catch (Throwable throwable) {
                XMLPlugin.log(throwable);
                if (!(throwable instanceof Error)) break block5;
                throw (Error)throwable;
            }
        }
    }

    private boolean wfk(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'w')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean cf(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return false;
        }
        return (n = string.lastIndexOf(47, n - 1)) >= 0 && n <= 4;
    }

    private void initializeDelta() {
        log = (int)(cap >> 32) | 1;
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.objfac.rnceditor.RNCEditor");
            if (clazz != null) {
                log &= 0xFFFFFFFE;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    private void initializeDependencies() {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            Display display = iWorkbenchWindow.getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    DependencyManager dependencyManager = DependencyManager.getSingletonManager();
                    dependencyManager.readDependencies();
                }
            });
        }
    }

    public RNCEditorEnvironment getRNCEditorEnvironment() {
        return this.fRNCEnv;
    }

    public Reader getStateFileReader(String string, String string2) {
        String string3 = this.getStateFileUrl(string);
        String string4 = Misc.fileUrlToPath((String)string3);
        File file = new File(string4);
        if (!file.exists()) {
            return null;
        }
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            XMLPlugin.log(unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            XMLPlugin.log(fileNotFoundException);
        }
        return null;
    }

    public Writer getStateFileWriter(String string, String string2) {
        String string3 = this.getStateFileUrl(string);
        String string4 = Misc.fileUrlToPath((String)string3);
        File file = new File(string4);
        try {
            if (!file.exists() && !file.createNewFile()) {
                return null;
            }
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            XMLPlugin.log(unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            XMLPlugin.log(fileNotFoundException);
        }
        catch (IOException iOException) {
            XMLPlugin.log(iOException);
        }
        return null;
    }

    public String getStateFileUrl(String string) {
        IPath iPath = this.getStateLocation();
        String string2 = iPath.toOSString();
        String string3 = Misc.absPathToUrl((String)string2);
        string3 = String.valueOf(string3) + (string3.endsWith("/") ? string : "/" + string);
        return string3;
    }

    private void initializeSchemaCache() {
        DocumentCache documentCache = DocumentCache.getCache();
        URL uRL = null;
        try {
            uRL = this.getDescriptor().getInstallURL();
            URL uRL2 = new URL(uRL, CACHE_DIR);
            documentCache.addStore((IDocumentStore)new URLDocumentStore(uRL2));
        }
        catch (MalformedURLException malformedURLException) {
            XMLPlugin.log(Local.format((String)"Malformed URL trying to join {0} and {1}", (Object)uRL.toString(), (Object)CACHE_DIR));
        }
        IPath iPath = this.getStateLocation();
        String string = iPath.toOSString();
        String string2 = Misc.absPathToUrl((String)string);
        string2 = String.valueOf(string2) + (string2.endsWith("/") ? CACHE_DIR : "/.cache/");
        String string3 = Misc.fileUrlToPath((String)string2);
        File file = new File(string3);
        String string4 = null;
        if (!file.exists()) {
            if (file.mkdir()) {
                this.fCacheUrl = string2;
            } else {
                string4 = Local.getString((String)"mkdir failed");
            }
        } else if (file.isDirectory()) {
            this.fCacheUrl = string2;
        } else {
            string4 = Local.getString((String)"not a directory");
        }
        if (this.fCacheUrl == null) {
            ILog iLog = this.getLog();
            Status status = new Status(4, PLUGIN_ID, 0, Local.format((String)"Unable to open or create {0} because {1}", (Object)string2, (Object)string4), null);
            iLog.log((IStatus)status);
        } else {
            documentCache.addStore((IDocumentStore)new FileDocumentStore(this.fCacheUrl, false));
        }
    }

    public String getCacheLocation() {
        return this.fCacheUrl;
    }

    public static ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    public static XMLPlugin getDefault() {
        return fPlugin;
    }

    public static String getPluginId() {
        return XMLPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static ILogger getLogger() {
        return fLogger;
    }

    public static void log(IStatus iStatus) {
        XMLPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(String string) {
        XMLPlugin.log((IStatus)new Status(4, XMLPlugin.getPluginId(), 4, string, null));
    }

    public static void logInfo(String string) {
        XMLPlugin.log((IStatus)new Status(1, XMLPlugin.getPluginId(), 1, XMLPlugin.top(string), null));
    }

    public static void log(Throwable throwable) {
        XMLPlugin.log((IStatus)new Status(4, XMLPlugin.getPluginId(), 4, "Internal Error", throwable));
    }

    public ImageDescriptor getImageDescriptor(String string) {
        try {
            URL uRL = new URL(this.getDescriptor().getInstallURL(), string);
            return ImageDescriptor.createFromURL((URL)uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public XercesValidator getValidator() {
        return (XercesValidator)this.loadInternalClass(XERCES_VALIDATOR_CLASS);
    }

    public Validator getValidator(String string) {
        return (Validator)this.loadInternalClass(string);
    }

    public Object loadInternalClass(String string) {
        ClassLoader classLoader = this.getValidatorClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return clazz.newInstance();
        }
        catch (Exception exception) {
            XMLPlugin.log(exception);
            return null;
        }
    }

    public synchronized ClassLoader getValidatorClassLoader() {
        return ValidatorLoader.getValidatorClassLoader();
    }

    public void dialogClosed() {
        this.saveDialogSettings();
    }

    public XMLEditorEnvironment getEnvironment() {
        return fEnv;
    }

    public Color getPreferenceColor(String string) {
        return this.getPreferenceColor(fEnv, string);
    }

    public Color getPreferenceColor(XMLEditorEnvironment xMLEditorEnvironment, String string) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)xMLEditorEnvironment.getStore(), (String)string);
        XMLColorProvider xMLColorProvider = xMLEditorEnvironment.getXMLColorProvider();
        return xMLColorProvider.getColor(rGB);
    }

    public int getPreferenceStyle(XMLEditorEnvironment xMLEditorEnvironment, String string) {
        return xMLEditorEnvironment.getStore().getBoolean(String.valueOf(string) + "#bold") ? 1 : 0;
    }

    public boolean getSyncOutline() {
        return this.getPreferenceStore().getBoolean("com.objfac.xmleditor.syncoutline");
    }

    public String getXSLTProcessor() {
        return this.getPreferenceStore().getString("com.objfac.xmleditor.usexslt");
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        FontData[] fontDataArray;
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.comment", (RGB)XMLConstants.COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.tag", (RGB)XMLConstants.TAG);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.starttag", (RGB)XMLConstants.STARTTAG);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.entity", (RGB)XMLConstants.ENTITY_REF);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.attr", (RGB)XMLConstants.ATTR);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.value", (RGB)XMLConstants.VALUE);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.jasp", (RGB)XMLConstants.JASP);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.cdatatag", (RGB)XMLConstants.CDATATAG);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.cdatatext", (RGB)XMLConstants.CDATATEXT);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.default", (RGB)XMLConstants.DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.javakey", (RGB)XMLConstants.JAVAKEY);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.javamlc", (RGB)XMLConstants.JAVAMLC);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.javaslc", (RGB)XMLConstants.JAVASLC);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.javajdc", (RGB)XMLConstants.JAVAJDC);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.entitydecl", (RGB)XMLConstants.ENTITY);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.elementdecl", (RGB)XMLConstants.ELEMENT);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.attlistdecl", (RGB)XMLConstants.ATTLIST);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.include", (RGB)XMLConstants.INCLUDE);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.background", (RGB)XMLConstants.BACKGROUND);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.doctype", (RGB)XMLConstants.DOCTYPE);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.notation", (RGB)XMLConstants.NOTATION);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.xmleditor.color.peref", (RGB)XMLConstants.PEREF);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.comment#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.tag#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.starttag#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.entity#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.attr#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.value#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.jasp#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.cdatatag#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.cdatatext#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.default#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.javakey#bold", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.javamlc#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.javaslc#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.javajdc#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.entitydecl#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.elementdecl#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.attlistdecl#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.include#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.background#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.doctype#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.notation#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.color.peref#bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.default", (RGB)RNCConstants.DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.comment", (RGB)RNCConstants.COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.documentation", (RGB)RNCConstants.DOCUMENTATION);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.keyword", (RGB)RNCConstants.KEYWORD);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.string", (RGB)RNCConstants.STRING);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.id", (RGB)RNCConstants.IDENTIFIER);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.op", (RGB)RNCConstants.OPERATOR);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.delim", (RGB)RNCConstants.DELIMITER);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.anno", (RGB)RNCConstants.ANNOTATION);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.ref", (RGB)RNCConstants.REF);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"com.objfac.rnc.bad", (RGB)RNCConstants.BAD);
        iPreferenceStore.setDefault("com.objfac.rnc.default#bold", false);
        iPreferenceStore.setDefault("com.objfac.rnc.comment#bold", false);
        iPreferenceStore.setDefault("com.objfac.rnc.documentation#bold", false);
        iPreferenceStore.setDefault("com.objfac.rnc.keyword#bold", true);
        iPreferenceStore.setDefault("com.objfac.rnc.string#bold", false);
        iPreferenceStore.setDefault("com.objfac.rnc.id#bold", false);
        iPreferenceStore.setDefault("com.objfac.rnc.op#bold", false);
        iPreferenceStore.setDefault("com.objfac.rnc.delim#bold", false);
        iPreferenceStore.setDefault("com.objfac.rnc.anno#bold", false);
        iPreferenceStore.setDefault("com.objfac.rnc.ref#bold", false);
        iPreferenceStore.setDefault("com.objfac.rnc.bad#bold", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.cacheon", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.validateonsave", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.validateonchange", true);
        iPreferenceStore.setDefault(XMLConstants.ID_VALIDATE_DELAY, 1000);
        iPreferenceStore.setDefault("com.objfac.xmleditor.undolevels", 25);
        iPreferenceStore.setDefault("com.objfac.xmleditor.autoassist", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.autoinsert", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.assistdelay", 500);
        iPreferenceStore.setDefault("com.objfac.xmleditor.fillendtag", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.removeendtag", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.insertendtag", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.honor", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.workbench", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.encoding", "UTF-8");
        iPreferenceStore.setDefault("com.objfac.xmleditor.tabwidth", 4);
        iPreferenceStore.setDefault("com.objfac.xmleditor.wrapmax", 80);
        iPreferenceStore.setDefault("com.objfac.xmleditor.wrapplus", 60);
        iPreferenceStore.setDefault("com.objfac.xmleditor.usewrapmax", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.getext", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.spaces", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.flowlong", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.flowshort", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.formatpaste", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.indentas", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.indentc", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.indente", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.dtdmatch", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.dtdroot", "html project book chapter");
        iPreferenceStore.setDefault("com.objfac.xmleditor.dtdpub", "-//W3C//DTD%20XHTML%201.0%20Transitional//EN -//ANT 1.5.1/DTD//EN -//OASIS//DocBook V4.2 -//OASIS//DocBook V4.2");
        iPreferenceStore.setDefault("com.objfac.xmleditor.dtdsys", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd http://xmlbuddy.com/DTD/ant151.dtd http://www.docbook.org/xml/4.2/docbookx.dtd http://www.docbook.org/xml/4.2/docbookx.dtd");
        iPreferenceStore.setDefault("com.objfac.xmleditor.dtdauto", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.syncoutline", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.showattr", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.showtext", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.rngmatch", "ns");
        iPreferenceStore.setDefault("com.objfac.xmleditor.rngroot", "grammar");
        iPreferenceStore.setDefault("com.objfac.xmleditor.rngns", "http://relaxng.org/ns/structure/1.0");
        iPreferenceStore.setDefault("com.objfac.xmleditor.rngsys", "http://xmlbuddy.com/RELAXNG/relaxng.rng");
        iPreferenceStore.setDefault("com.objfac.xmleditor.rncmatch", "ns");
        iPreferenceStore.setDefault("com.objfac.xmleditor.rncroot", "");
        iPreferenceStore.setDefault("com.objfac.xmleditor.rncns", "");
        iPreferenceStore.setDefault("com.objfac.xmleditor.rncsys", "");
        iPreferenceStore.setDefault("com.objfac.xmleditor.xsdmatch", "ns");
        iPreferenceStore.setDefault("com.objfac.xmleditor.xsdroot", "");
        iPreferenceStore.setDefault("com.objfac.xmleditor.xsdns", "");
        iPreferenceStore.setDefault("com.objfac.xmleditor.xsdsys", "");
        iPreferenceStore.setDefault("com.objfac.rnceditor.undolevels", 25);
        iPreferenceStore.setDefault("com.objfac.rnceditor.tabwidth", 2);
        iPreferenceStore.setDefault("com.objfac.desktopproject", "File System");
        iPreferenceStore.setDefault("com.objfac.xmleditor.usexslt", "builtin");
        iPreferenceStore.setDefault("com.objfac.editors_mapped", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.formattemplates", true);
        iPreferenceStore.setDefault("com.objfac.xmleditor.formatrules", "");
        iPreferenceStore.setDefault("com.objfac.xmleditor.alwayssystem", false);
        iPreferenceStore.setDefault("com.objfac.xmleditor.alwaysworkspace", false);
        int n = 0;
        while (n < XMLConstants.GRAPH_ITEM_PREFIXES.length) {
            fontDataArray = XMLConstants.GRAPH_ITEM_PREFIXES[n];
            PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "FG"), (RGB)XMLConstants.GRAPH_FG_COLOR);
            PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "Border"), (RGB)XMLConstants.GRAPH_BORDER_COLOR);
            if (fontDataArray == "graphSelection") {
                PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "BG"), (RGB)XMLConstants.GRAPH_SELECTION_BG_COLOR);
                PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "Gradient"), (RGB)XMLConstants.GRAPH_SELECTION_GRADIENT_COLOR);
            } else if (fontDataArray == "graphElement") {
                PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "BG"), (RGB)XMLConstants.GRAPH_ELEMENT_BG_COLOR);
                PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "Gradient"), (RGB)XMLConstants.GRAPH_ELEMENT_GRADIENT_COLOR);
            } else if (fontDataArray == "graphElementRef") {
                PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "BG"), (RGB)XMLConstants.GRAPH_ELEMENT_BG_COLOR);
                PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "Gradient"), (RGB)XMLConstants.GRAPH_ELEMENT_GRADIENT_COLOR);
            } else {
                PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "BG"), (RGB)XMLConstants.GRAPH_BG_COLOR);
                PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)(String.valueOf(fontDataArray) + "Gradient"), (RGB)XMLConstants.GRAPH_GRADIENT_COLOR);
            }
            ++n;
        }
        iPreferenceStore.setDefault("graphAlignLeaves", false);
        iPreferenceStore.setDefault("graphConnectorGrid", true);
        iPreferenceStore.setDefault("graphConnectorFocus", false);
        Font font = JFaceResources.getDefaultFont();
        fontDataArray = font.getFontData();
        iPreferenceStore.setDefault("graphFontSize", fontDataArray[0].getHeight());
        iPreferenceStore.setDefault("graphFontName", fontDataArray[0].getName());
        int n2 = fontDataArray[0].getStyle();
        iPreferenceStore.setDefault("graphFontBold", (n2 & 1) != 0);
        iPreferenceStore.setDefault("graphFontItalic", (n2 & 2) != 0);
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public static XMLEncodingHandler getEncodingHandler() {
        return fEncodingHandler;
    }

    public byte[] a() {
        byte[] byArray = null;
        String string = this.g();
        File file = new File(string);
        byArray = !file.exists() ? this.b(string) : this.c(string, file);
        return byArray;
    }

    public byte[] h(byte[] byArray) {
        return this.d(this.g(), byArray);
    }

    private String g() {
        String string = System.getProperty("user.home");
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        string = String.valueOf(string) + ".com.objfac.xmlbuddy" + File.separator + "license.lic";
        return string;
    }

    private byte[] c(String string, File file) {
        byte[] byArray = null;
        try {
            int n;
            InputStream inputStream = new FileInputStream(file);
            inputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            this.f(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this.b(string);
        }
        catch (IOException iOException) {
            return this.b(string);
        }
        return byArray;
    }

    private void f(byte[] byArray) {
        byte[] byArray2 = this.e();
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            int n3 = n;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[n % byArray2.length]);
            ++n;
        }
    }

    private byte[] b(String string) {
        byte[] byArray = null;
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("config.xml");
        if (inputStream == null) {
            byArray = new byte[]{35, 50};
        } else {
            inputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n;
                while ((n = inputStream.read()) >= 0) {
                    byteArrayOutputStream.write(n);
                }
                inputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                byArray = this.d(string, byArray);
            }
            catch (IOException iOException) {
                byArray = new byte[]{35, 49};
            }
        }
        return byArray;
    }

    private byte[] d(String string, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        File file = new File(string);
        if (!file.exists()) {
            try {
                int n = string.lastIndexOf(File.separatorChar);
                if (n < 0) {
                    return new byte[]{35, 55};
                }
                String string2 = string.substring(0, n + 1);
                File file2 = new File(string2);
                if (!file2.exists() && !file2.mkdirs()) {
                    return new byte[]{35, 56};
                }
                file.createNewFile();
            }
            catch (IOException iOException) {
                return new byte[]{35, 51};
            }
        }
        if (!file.canWrite()) {
            return new byte[]{35, 52};
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.f(byArray2);
            fileOutputStream.write(byArray2);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new byte[]{35, 53};
        }
        catch (IOException iOException) {
            return new byte[]{35, 54};
        }
        return byArray;
    }

    private byte[] e() {
        byte[] byArray;
        String string = System.getProperty("user.name");
        if (string == null) {
            string = "bobo";
        }
        byte[] byArray2 = new byte[string.length()];
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = (byte)string.charAt(n);
            ++n;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray = messageDigest.digest(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            byArray = byArray2;
        }
        return byArray;
    }

    private static String top(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c;
            char c2 = c = string.charAt(n2);
            if (c < 'a' || c > 'z') {
                c2 = Character.toLowerCase(c2);
            }
            stringBuffer.append(c);
            if (c2 == '(') {
                bl = true;
            } else if (bl) {
                log |= c == '0' ? 0 : 2;
                bl = false;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        fResourceBundle = Platform.getResourceBundle((Bundle)bundleContext.getBundle());
        fPlugin = this;
        fEnv = new XMLEditorEnvironment(new XMLTextTools(this.getPreferenceStore()));
        this.initializeDefaultPreferences(this.getPreferenceStore());
        this.initializeCache();
        this.initializeExtensionPoints();
        this.initializeSchemaCache();
        this.initializeDelta();
        this.initializeDependencies();
        this.fRNCEnv = new RNCEditorEnvironment(this.getPreferenceStore());
        this.initializeConfig();
        this.initializeMappings();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        DependencyManager.getSingletonManager().writeDependencies();
    }

    private static class Logger
    implements ILogger {
        Logger() {
        }

        public void log(String string) {
            XMLPlugin.log(string);
        }

        public void log(Throwable throwable) {
            XMLPlugin.log(throwable);
        }
    }
}

