/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.xmleditor.BaseEditor;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public abstract class EditorActionDelegate
implements IEditorActionDelegate {
    private IAction fAction;
    private static ArrayList fDelegates = new ArrayList();

    public EditorActionDelegate() {
        EditorActionDelegate.addActionDelegate(this);
    }

    private static synchronized void addActionDelegate(EditorActionDelegate editorActionDelegate) {
        fDelegates.add(editorActionDelegate);
    }

    protected void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setEnabled(IAction iAction, boolean bl) {
        this.setAction(iAction);
        if (this.fAction != null) {
            this.fAction.setEnabled(bl);
        }
    }

    public static synchronized void selectionChanged(BaseEditor baseEditor) {
        IDocument iDocument;
        ISourceViewer iSourceViewer = baseEditor.getViewer();
        if (iSourceViewer != null && (iDocument = iSourceViewer.getDocument()) != null) {
            Point point = iSourceViewer.getTextWidget().getSelectionRange();
            TextSelection textSelection = new TextSelection(iDocument, point.x, point.y);
            int n = 0;
            int n2 = fDelegates.size();
            while (n < n2) {
                EditorActionDelegate editorActionDelegate = (EditorActionDelegate)fDelegates.get(n);
                editorActionDelegate.setActiveEditor(editorActionDelegate.getAction(), (IEditorPart)baseEditor);
                editorActionDelegate.selectionChanged(editorActionDelegate.getAction(), (ISelection)textSelection);
                ++n;
            }
        }
    }
}

