/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.TabCalculator;
import com.objfac.walker.IWalker;
import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.FormatRuleRegistry;
import com.objfac.xmleditor.actions.FormatRules;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;

public class Formatter {
    private static final boolean DEBUG = false;
    private XMLTree fTree;
    private String fNewContents;
    private int fReplaceEnd;
    private int fReplaceBeg;
    private int fWrapMargin;
    private XMLNode fEndNode;
    private XMLNode fBegNode;
    private IRegion fEndReg;
    private IRegion fBegReg;
    private int fRelocateLength;
    private int fRelocateOffset;
    private static final XMLNode[] NO_OUTER = new XMLNode[2];
    private TabCalculator fTabber;
    private IDocument fDocument;
    private String EOL;
    private boolean fFirst;
    private boolean fInWs;
    private ArrayList fCountStack;
    private int fBaseCount;
    private StringBuffer fClump;
    private int fCount;
    private FormatRules fRules;
    private StringBuffer fBuf;
    private int fPos;
    private int fSpaceCount;
    private int fClumpCount;
    private Map fPrefixToNs;
    private Set fKeepElements;
    private Set fKeepEndTags;
    private Set fKeepAsIs;
    private Set fStartLeft;
    private ArrayList fQNames;
    private ArrayList fRuleStack;
    private HashMap fSavedRules;
    private boolean fAutoIndent;

    public boolean backgroundFormat(IDocument iDocument, XMLTree xMLTree, IWalker iWalker, Point point, int n, boolean bl, int n2) {
        this.fWrapMargin = n2;
        this.fTabber = new TabCalculator(n, bl);
        this.fTree = xMLTree;
        this.fDocument = iDocument;
        this.EOL = System.getProperty("line.separator");
        this.fFirst = true;
        this.fClump = new StringBuffer();
        this.fBuf = new StringBuffer();
        if (!this.newCalculateRange(iDocument, xMLTree, point)) {
            return false;
        }
        boolean bl2 = false;
        try {
            int n3 = this.fBegReg.getOffset();
            int n4 = this.fBegReg.getLength();
            int cfr_ignored_0 = n3 + n4;
            String string = iDocument.get(n3, n4);
            int n5 = this.fBegNode.getOffset() - n3;
            int[] nArray = new int[2];
            this.fTabber.countLeadingWhitespace(string, nArray);
            this.fCount = nArray[0];
            int n6 = nArray[1];
            if (n6 != n5) {
                return false;
            }
            int n7 = this.fBegReg.getOffset();
            int n8 = this.fEndReg.getOffset() + this.fEndReg.getLength();
            this.fRules = this.getFormatRules(this.fBegNode);
            if (this.fRules.indentToTabBoundaries) {
                this.fCount = this.fTabber.roundUp(this.fCount);
            }
            this.initializeFlowElements();
            this.fAutoIndent = true;
            this.formatNodes(n3 + n5, this.fEndReg.getOffset() + this.fEndReg.getLength());
            String string2 = iDocument.get(n7, n8 - n7);
            String string3 = this.fBuf.toString();
            this.compare(n7, string2, string3);
            this.fReplaceBeg = n7;
            this.fReplaceEnd = n8;
            this.fNewContents = string3;
            bl2 = true;
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        return bl2;
    }

    private void pushFormatRules(XMLNode xMLNode) {
        Rules rules = new Rules(this.makeQName(xMLNode), this.fRules, this.fStartLeft, this.fKeepAsIs, this.fKeepElements, this.fKeepEndTags, this.fPrefixToNs);
        if (this.fRuleStack == null) {
            this.fRuleStack = new ArrayList();
        }
        this.fRuleStack.add(rules);
        this.getSavedRules().put(this.fRules, rules);
        FormatRules formatRules = this.getElementRules(xMLNode);
        if (formatRules != this.fRules && formatRules != FormatRules.DEFAULT_RULES) {
            this.fRules = formatRules;
            Rules rules2 = (Rules)this.getSavedRules().get(this.fRules);
            if (rules2 != null) {
                this.restoreFromEntry(rules2);
            } else {
                this.initializeFlowElements();
            }
            if (this.fRules.indentToTabBoundaries) {
                this.fCount = this.fTabber.roundUp(this.fCount);
            }
        }
    }

    private HashMap getSavedRules() {
        if (this.fSavedRules == null) {
            this.fSavedRules = new HashMap();
        }
        return this.fSavedRules;
    }

    private void popFormatRules(XMLNode xMLNode) {
        if (this.fRuleStack != null && this.fRuleStack.size() > 0) {
            int n = this.fRuleStack.size() - 1;
            Rules rules = (Rules)this.fRuleStack.get(n);
            String string = this.makeQName(xMLNode);
            if (this.equalsQName(string, rules.qname)) {
                this.restoreFromEntry(rules);
                this.fRuleStack.remove(n);
            }
        }
    }

    private void restoreFromEntry(Rules rules) {
        this.fRules = rules.rules;
        this.fStartLeft = rules.startLeft;
        this.fKeepAsIs = rules.keepAsIs;
        this.fKeepElements = rules.keepElements;
        this.fKeepEndTags = rules.keepEndTags;
        this.fPrefixToNs = rules.prefixToNs;
    }

    private void initializeFlowElements() {
        this.fKeepElements = FormatRuleRegistry.makeKeepSet(this.fRules, this.fRules.keepStartTagsOnSameLine);
        this.fKeepEndTags = FormatRuleRegistry.makeKeepSet(this.fRules, this.fRules.keepEndTagsOnSameLine);
        this.fKeepAsIs = FormatRuleRegistry.makeKeepSet(this.fRules, this.fRules.keepContentsAsIs);
        this.fStartLeft = FormatRuleRegistry.makeKeepSet(this.fRules, this.fRules.startLeft);
    }

    private FormatRules getElementRules(XMLNode xMLNode) {
        return FormatRuleRegistry.getRules(xMLNode.getNamespace(), xMLNode.getLocalname());
    }

    private FormatRules getFormatRules(XMLNode xMLNode) {
        if (xMLNode == null) {
            return FormatRules.DEFAULT_RULES;
        }
        FormatRules formatRules = this.getElementRules(xMLNode);
        if (formatRules == FormatRules.DEFAULT_RULES) {
            formatRules = this.getFormatRules(xMLNode.getParent());
        }
        return formatRules;
    }

    public void applyFormat(IDocument iDocument, ISourceViewer iSourceViewer) {
        try {
            iDocument.replace(this.fReplaceBeg, this.fReplaceEnd - this.fReplaceBeg, this.fNewContents);
            iSourceViewer.setSelectedRange(this.fRelocateOffset, this.fRelocateLength);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
    }

    public static boolean allWS(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            if (!XMLCharacter.isWhitespace((char)string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean goodParent(XMLNode xMLNode, XMLNode xMLNode2) {
        return xMLNode != null && xMLNode.getLastChild() == xMLNode2 && (xMLNode.getType() == "com.objfac.xmlstarttag" && xMLNode2.getType() == "com.objfac.xmlendtag" || xMLNode.getType() == "com.objfac.xmldoctypestart" && xMLNode2.getType() == "com.objfac.xmldoctypeend");
    }

    private XMLNode[] findOuter(XMLNode xMLNode, XMLTree xMLTree, IDocument iDocument) {
        XMLNode[] xMLNodeArray = NO_OUTER;
        boolean bl = Formatter.startsLine(xMLNode, xMLTree, iDocument);
        boolean bl2 = Formatter.endsLine(xMLNode, xMLTree, iDocument);
        switch (XMLConstants.getIntType(xMLNode.getType())) {
            case 0: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 21: {
                if (bl && bl2) {
                    xMLNodeArray = new XMLNode[2];
                    xMLNodeArray[0] = xMLNodeArray[1] = xMLNode;
                }
            }
            case 11: {
                XMLNode xMLNode2 = xMLNode.getParent();
                if (xMLNode2 == null) {
                    xMLNodeArray = this.wholeDocument(xMLTree, new XMLNode[2]);
                    break;
                }
                if (!this.goodParent(xMLNode2)) break;
                xMLNodeArray = this.findOuter(xMLNode2, xMLNode2.getLastChild(), xMLTree, iDocument);
                break;
            }
            case 4: 
            case 18: {
                XMLNode xMLNode3 = xMLNode.getParent();
                if (!this.goodParent(xMLNode3)) break;
                xMLNodeArray = this.findOuter(xMLNode3, xMLNode3.getLastChild(), xMLTree, iDocument);
                break;
            }
            case 1: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                xMLNodeArray = this.wholeDocument(xMLTree, new XMLNode[2]);
                break;
            }
            case 2: 
            case 17: {
                XMLNode xMLNode4;
                xMLNodeArray = this.goodParent(xMLNode) ? this.findOuter(xMLNode, xMLNode.getLastChild(), xMLTree, iDocument) : ((xMLNode4 = xMLNode.getParent()) == null ? this.wholeDocument(xMLTree, new XMLNode[2]) : this.findOuter(xMLNode4, xMLNode4.getLastChild(), xMLTree, iDocument));
            }
        }
        return xMLNodeArray;
    }

    private boolean newCalculateRange(IDocument iDocument, XMLTree xMLTree, Point point) {
        XMLNode xMLNode;
        boolean bl = false;
        this.fBegReg = null;
        this.fEndReg = null;
        this.fBegNode = null;
        this.fEndNode = null;
        this.fRelocateOffset = point.x;
        this.fRelocateLength = point.y;
        int n = point.x;
        int n2 = point.y;
        int n3 = n + n2;
        XMLNode[] xMLNodeArray = NO_OUTER;
        XMLNode xMLNode2 = xMLTree.findExactNode(n);
        XMLNode xMLNode3 = xMLTree.findExactNode(n3 - 1);
        XMLNode xMLNode4 = xMLNode2.getType() == "com.objfac.xmltext" && Formatter.allWS(xMLNode2.getContents()) && xMLNode2.getNextSibling() != null ? xMLNode2.getNextSibling() : xMLNode2;
        XMLNode xMLNode5 = xMLNode = xMLNode3.getType() == "com.objfac.xmltext" && Formatter.allWS(xMLNode3.getContents()) && xMLNode3.getPrevSibling() != null ? xMLNode3.getPrevSibling() : xMLNode3;
        if (this.goodParent(xMLNode4, xMLNode)) {
            xMLNodeArray = new XMLNode[]{xMLNode4, xMLNode};
        } else if (n == n3) {
            XMLNode xMLNode6 = xMLTree.findExactNode(n);
            xMLNodeArray = this.findOuter(xMLNode6, xMLTree, iDocument);
        } else if (xMLNode2 == xMLNode3) {
            xMLNodeArray = this.findOuter(xMLNode2, xMLTree, iDocument);
        } else {
            XMLNode xMLNode7 = this.findCommonParent(xMLNode2, xMLNode3);
            if (xMLNode7 != null && this.goodParent(xMLNode7)) {
                xMLNodeArray = this.findOuter(xMLNode7, xMLNode7.getLastChild(), xMLTree, iDocument);
            } else {
                xMLNodeArray = new XMLNode[2];
                XMLNode xMLNode8 = xMLNodeArray[0] = xMLTree.getHead();
                while (xMLNode8.getNextSibling() != null) {
                    xMLNode8 = xMLNode8.getNextSibling();
                }
                if (xMLNode8.getFirstChild() != null) {
                    xMLNode8 = xMLNode8.getLastChild();
                }
                xMLNodeArray[1] = xMLNode8;
            }
        }
        if (xMLNodeArray[0] != null) {
            try {
                this.fBegReg = iDocument.getLineInformationOfOffset(xMLNodeArray[0].getOffset());
                this.fEndReg = iDocument.getLineInformationOfOffset(xMLNodeArray[1].getOffset() + xMLNodeArray[1].getLength());
                this.fBegNode = xMLNodeArray[0];
                this.fEndNode = xMLNodeArray[1];
                bl = true;
            }
            catch (BadLocationException badLocationException) {}
        }
        return bl;
    }

    private XMLNode[] wholeDocument(XMLTree xMLTree, XMLNode[] xMLNodeArray) {
        XMLNode xMLNode = xMLNodeArray[0] = xMLTree.getHead();
        xMLNodeArray[1] = this.findLast(xMLNode);
        return xMLNodeArray;
    }

    private XMLNode findLast(XMLNode xMLNode) {
        while (xMLNode.getNextSibling() != null) {
            xMLNode = xMLNode.getNextSibling();
        }
        if (xMLNode.getFirstChild() != null) {
            return this.findLast(xMLNode.getFirstChild());
        }
        return xMLNode;
    }

    private XMLNode[] findOuter(XMLNode xMLNode, XMLNode xMLNode2, XMLTree xMLTree, IDocument iDocument) {
        XMLNode[] xMLNodeArray = new XMLNode[2];
        boolean bl = Formatter.startsLine(xMLNode, xMLTree, iDocument);
        boolean bl2 = Formatter.endsLine(xMLNode2, xMLTree, iDocument);
        if (bl && bl2 && !Formatter.inflow(xMLNode)) {
            xMLNodeArray[0] = xMLNode;
            xMLNodeArray[1] = xMLNode2;
        } else {
            XMLNode xMLNode3 = xMLNode.getParent();
            if (xMLNode3 == null) {
                XMLNode xMLNode4 = xMLNodeArray[0] = xMLTree.getHead();
                while (xMLNode4.getNextSibling() != null) {
                    xMLNode4 = xMLNode4.getNextSibling();
                }
                xMLNodeArray[1] = xMLNode4;
            } else if (this.goodParent(xMLNode3)) {
                xMLNodeArray = this.findOuter(xMLNode.getParent(), xMLNode.getParent().getLastChild(), xMLTree, iDocument);
            }
        }
        return xMLNodeArray;
    }

    private boolean goodParent(XMLNode xMLNode) {
        return xMLNode != null && xMLNode.getLastChild() != null && (xMLNode.getType() == "com.objfac.xmlstarttag" && xMLNode.getLastChild().getType() == "com.objfac.xmlendtag" || xMLNode.getType() == "com.objfac.xmldoctypestart" && xMLNode.getLastChild().getType() == "com.objfac.xmldoctypeend");
    }

    public static boolean inflow(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode.getParent();
        if (xMLNode2 != null) {
            XMLNode xMLNode3 = xMLNode2.getFirstChild();
            while (xMLNode3 != null) {
                if (xMLNode3.getType() == "com.objfac.xmltext" && !Formatter.allWS(xMLNode3.getContents())) {
                    return true;
                }
                xMLNode3 = xMLNode3.getNextSibling();
            }
        }
        return false;
    }

    public static boolean endsLine(XMLNode xMLNode, XMLTree xMLTree, IDocument iDocument) {
        int n = xMLNode.getOffset() + xMLNode.getLength();
        if (n == iDocument.getLength()) {
            return true;
        }
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset() + iRegion.getLength();
            if (n2 == n) {
                return true;
            }
            XMLNode xMLNode2 = xMLTree.findExactNode(n2);
            if (xMLNode2.getOffset() == n && xMLNode2.getType() == "com.objfac.xmltext" && Formatter.allWS(xMLNode2.getContents())) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public static boolean startsLine(XMLNode xMLNode, XMLTree xMLTree, IDocument iDocument) {
        int n = xMLNode.getOffset();
        if (n == 0) {
            return true;
        }
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            if (n2 == n) {
                return true;
            }
            XMLNode xMLNode2 = xMLTree.findExactNode(n2);
            if (xMLNode2.getOffset() + xMLNode2.getLength() == n && xMLNode2.getType() == "com.objfac.xmltext" && Formatter.allWS(xMLNode2.getContents())) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private XMLNode findCommonParent(XMLNode xMLNode, XMLNode xMLNode2) {
        if (xMLNode.getParent() == xMLNode2.getParent()) {
            return xMLNode.getParent();
        }
        LinkedList<XMLNode> linkedList = new LinkedList<XMLNode>();
        this.getParentList(xMLNode, linkedList);
        linkedList.add(xMLNode);
        LinkedList linkedList2 = new LinkedList();
        this.getParentList(xMLNode2, linkedList2);
        XMLNode xMLNode3 = null;
        while (linkedList.size() > 0 && linkedList2.size() > 0) {
            XMLNode xMLNode4;
            XMLNode xMLNode5 = (XMLNode)linkedList.removeFirst();
            if (xMLNode5 != (xMLNode4 = (XMLNode)linkedList2.removeFirst())) break;
            xMLNode3 = xMLNode5;
        }
        return xMLNode3;
    }

    private void getParentList(XMLNode xMLNode, LinkedList linkedList) {
        XMLNode xMLNode2 = xMLNode.getParent();
        if (xMLNode2 != null) {
            this.getParentList(xMLNode2, linkedList);
        }
        linkedList.add(xMLNode2);
    }

    private void compare(int n, String string, String string2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = string2.length();
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        while (n2 < n4 && n3 < n5) {
            if (cArray[n2] == cArray2[n3]) {
                ++n2;
                ++n3;
                continue;
            }
            int n6 = n2;
            int n7 = n3;
            while (n2 < n4 && XMLCharacter.isWhitespace((char)cArray[n2])) {
                ++n2;
            }
            while (n3 < n5 && XMLCharacter.isWhitespace((char)cArray2[n3])) {
                ++n3;
            }
            int n8 = n2 - n6;
            int n9 = n3 - n7;
            if (n8 == 0 && n9 == 0) {
                throw new IllegalStateException("format changed non-ws chars");
            }
            if (n8 < n9) {
                this.noteInsertCharacters(n7 + n8 + n, n9 - n8);
                continue;
            }
            if (n8 <= n9) continue;
            this.noteDeleteCharacters(n7 + n9 + n, n8 - n9);
        }
        if (n2 < n4) {
            this.noteDeleteCharacters(n5 + n, n4 - n2);
        }
        if (n3 < n5) {
            this.noteInsertCharacters(n3 + n, n5 - n3);
        }
        this.fixRelocate(cArray2, n);
    }

    private void noteDeleteCharacters(int n, int n2) {
        int n3 = n + n2;
        int n4 = this.fRelocateOffset + this.fRelocateLength;
        if (this.fRelocateOffset > n3) {
            this.fRelocateOffset -= n2;
        } else if (n4 > n) {
            if (this.fRelocateOffset <= n) {
                this.fRelocateLength -= n4 <= n3 ? n4 - n : n2;
            } else {
                this.fRelocateLength -= n4 <= n3 ? 0 : n3 - this.fRelocateOffset;
                this.fRelocateOffset = n;
            }
        }
    }

    private void noteInsertCharacters(int n, int n2) {
        int cfr_ignored_0 = n + n2;
        int n3 = this.fRelocateOffset + this.fRelocateLength;
        if (this.fRelocateOffset > n) {
            this.fRelocateOffset += n2;
        } else if (n3 > n) {
            this.fRelocateLength += n2;
        }
    }

    private void fixRelocate(char[] cArray, int n) {
        int n2 = this.fRelocateOffset;
        int n3 = this.fRelocateOffset + this.fRelocateLength;
        this.fRelocateOffset = this.fixRelocate(cArray, n, n2);
        n3 = this.fixRelocate(cArray, n, n3);
        this.fRelocateLength = n3 - this.fRelocateOffset;
    }

    private int fixRelocate(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 0) {
            boolean bl = false;
            int n4 = n3 - 1;
            while (n4 >= 0 && XMLCharacter.isWhitespace((char)cArray[n4])) {
                if (cArray[n4] == '\r' || cArray[n4] == '\n') {
                    bl = true;
                    break;
                }
                --n4;
            }
            if (bl) {
                n4 = n3;
                while (n4 < cArray.length) {
                    if (!XMLCharacter.isWhitespace((char)cArray[n4])) break;
                    ++n4;
                }
                if (n4 > n3) {
                    return n4 + n;
                }
            }
        }
        return n2;
    }

    private void formatNodes(int n, int n2) throws BadLocationException {
        XMLNode xMLNode = this.fTree.findExactNode(n).getParent();
        while (xMLNode != null) {
            if (this.keepAsIs(xMLNode)) {
                this.keepAll(n, n2);
                return;
            }
            xMLNode = xMLNode.getParent();
        }
        boolean bl = false;
        String string = null;
        int n3 = n;
        while (n3 < n2) {
            XMLNode xMLNode2 = this.fTree.findExactNode(n3);
            n3 = xMLNode2.getOffset() + xMLNode2.getLength();
            int n4 = XMLConstants.getIntType(xMLNode2.getType());
            switch (n4) {
                case 0: {
                    if (this.startsOnNewLine(xMLNode2)) {
                        this.appendIndent();
                    }
                    this.formatComment(xMLNode2);
                    break;
                }
                case 1: {
                    this.formatTag(xMLNode2);
                    break;
                }
                case 6: {
                    this.fCount = 0;
                    this.appendIndent();
                    this.formatTag(xMLNode2);
                    break;
                }
                case 8: {
                    this.appendIndent();
                    this.appendString(xMLNode2.getContents(), true);
                    break;
                }
                case 7: {
                    this.appendIndent();
                    this.formatTag(xMLNode2);
                    break;
                }
                case 9: {
                    if (this.whitespaceBefore(xMLNode2)) {
                        this.appendIndent();
                    }
                    this.formatTag(xMLNode2);
                    break;
                }
                case 10: {
                    this.appendIndent();
                    this.formatTag(xMLNode2);
                    break;
                }
                case 3: {
                    if (!this.keepStartTags(xMLNode2)) {
                        this.appendIndent(xMLNode2);
                    }
                    this.pushFormatRules(xMLNode2);
                    this.formatTag(xMLNode2);
                    this.popFormatRules(xMLNode2);
                    break;
                }
                case 2: {
                    this.pushFormatRules(xMLNode2);
                    boolean bl2 = this.keepStartTags(xMLNode2);
                    if (!bl2) {
                        this.appendIndent(xMLNode2);
                    }
                    this.formatTag(xMLNode2);
                    if (this.keepAsIs(xMLNode2)) {
                        n3 = this.formatAsIs(xMLNode2.getFirstChild(), n3);
                        break;
                    }
                    int n5 = this.fCount;
                    string = this.pushCount(xMLNode2, string, bl2);
                    if (!bl2) break;
                    this.fCount = n5;
                    break;
                }
                case 4: {
                    if (!this.keepEndTags(xMLNode2) && !this.textInParentOrEmpty(xMLNode2)) {
                        if (this.fRules.indentEndTags) {
                            this.appendIndent(xMLNode2);
                            this.formatTag(xMLNode2);
                            string = this.popCount(this.makeQName(xMLNode2), string);
                        } else {
                            string = this.popCount(this.makeQName(xMLNode2), string);
                            this.appendIndent();
                            this.formatTag(xMLNode2);
                        }
                    } else {
                        this.formatTag(xMLNode2);
                        string = this.popCount(this.makeQName(xMLNode2), string);
                    }
                    this.popFormatRules(xMLNode2);
                    break;
                }
                case 5: {
                    this.appendString(xMLNode2.getContents(), true);
                    break;
                }
                case 11: {
                    this.formatText(xMLNode2);
                    break;
                }
                case 20: 
                case 21: {
                    if (this.startsOnNewLine(xMLNode2)) {
                        this.appendIndent();
                    }
                    this.formatText(xMLNode2);
                    break;
                }
                case 14: {
                    this.appendIndent();
                    this.formatText(xMLNode2);
                    break;
                }
                case 15: {
                    this.appendIndent();
                    this.formatNodePreserve(xMLNode2);
                    break;
                }
                case 12: 
                case 13: 
                case 16: 
                case 19: {
                    this.appendIndent();
                    if (!bl && xMLNode2.getParent() != null && xMLNode2.getParent().getType() == "com.objfac.xmldoctypestart") {
                        bl = true;
                    }
                    this.formatTag(xMLNode2);
                    break;
                }
                case 17: {
                    this.fCount = 0;
                    this.appendIndent();
                    this.formatTag(xMLNode2);
                    bl = true;
                    if (!this.fRules.indentNestedDeclarations) break;
                    this.pushCount(false);
                    break;
                }
                case 18: {
                    this.appendIndent();
                    this.formatTag(xMLNode2);
                    bl = false;
                    if (!this.fRules.indentNestedDeclarations) break;
                    this.popCount();
                }
            }
        }
        this.pushClump();
    }

    private boolean textInParentOrEmpty(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode.getParent();
        boolean bl = false;
        boolean bl2 = true;
        if (xMLNode2 != null) {
            XMLNode xMLNode3 = xMLNode2.getFirstChild();
            while (xMLNode3 != null) {
                if (xMLNode3.getType().equals("com.objfac.xmltext") && !XMLCharacter.isWhitespace((String)xMLNode3.getContents())) {
                    bl = true;
                    break;
                }
                if (xMLNode3 != xMLNode) {
                    bl2 = false;
                }
                xMLNode3 = xMLNode3.getNextSibling();
            }
        }
        return bl || bl2;
    }

    private void keepAll(int n, int n2) {
        try {
            this.fBuf.append(this.fDocument.get(n, n2 - n));
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean whitespaceBefore(XMLNode xMLNode) {
        int n = xMLNode.getOffset();
        if (n == 0) {
            return true;
        }
        try {
            String string = this.fDocument.get(n - 1, 1);
            return string.charAt(0) <= ' ';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private String pushCount(XMLNode xMLNode, String string, boolean bl) {
        this.pushCount(bl);
        this.pushQName(string);
        return this.makeQName(xMLNode);
    }

    private String popCount(String string, String string2) {
        if (this.equalsQName(string, string2)) {
            this.popCount();
            string2 = this.popQName();
        }
        return string2;
    }

    private int formatAsIs(XMLNode xMLNode, int n) {
        XMLNode xMLNode2 = xMLNode;
        while (xMLNode2 != null) {
            this.appendString(xMLNode2.getContents(), true);
            n = xMLNode2.getOffset() + xMLNode2.getLength();
            n = this.formatAsIs(xMLNode2.getFirstChild(), n);
            xMLNode2 = xMLNode2.getNextSibling();
        }
        return n;
    }

    private boolean keepStartTags(XMLNode xMLNode) {
        return this.keep(xMLNode, this.fKeepElements);
    }

    private boolean keepEndTags(XMLNode xMLNode) {
        return this.keep(xMLNode, this.fKeepEndTags);
    }

    private boolean keepAsIs(XMLNode xMLNode) {
        String string = xMLNode.getAttributeValue("xml:space");
        return this.keep(xMLNode, this.fKeepAsIs) || "preserve".equals(string);
    }

    private boolean startLeft(XMLNode xMLNode) {
        return this.keep(xMLNode, this.fStartLeft);
    }

    private boolean keep(XMLNode xMLNode, Set set) {
        String string = this.makeQName(xMLNode);
        return set.contains(string);
    }

    private String makeQName(XMLNode xMLNode) {
        return FormatRuleRegistry.makeQName(xMLNode.getNamespace(), xMLNode.getLocalname());
    }

    private boolean equalsQName(String string, String string2) {
        if (string2 != null) {
            if (this.fRules.ignoreCaseInElementNames) {
                return string.equalsIgnoreCase(string2);
            }
            return string.equals(string2);
        }
        return false;
    }

    private boolean startsOnNewLine(XMLNode xMLNode) {
        int n = xMLNode.getOffset();
        try {
            IRegion iRegion = this.fDocument.getLineInformationOfOffset(n);
            String string = this.fDocument.get(iRegion.getOffset(), n - iRegion.getOffset());
            return XMLCharacter.isWhitespace((String)string);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean formatText(XMLNode xMLNode) {
        String string = xMLNode.getContents();
        int n = 0;
        boolean bl = true;
        if (this.fRules.flowText) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (XMLCharacter.isWhitespace((char)c)) {
                    stringBuffer.toString();
                    this.formatWord(stringBuffer);
                    this.appendChar(c, false);
                    if (c == '\r' || c == '\n') {
                        ++n;
                        if (c == '\r' && n2 + 1 < string.length() && string.charAt(n2 + 1) == '\n') {
                            ++n2;
                        }
                    }
                } else {
                    this.appendEmptyLines(n);
                    stringBuffer.append(c);
                    n = 0;
                }
                ++n2;
            }
            stringBuffer.toString();
            this.formatWord(stringBuffer);
            this.appendEmptyLines(n);
            bl = n == 0;
        } else {
            this.appendString(string, true);
        }
        return bl;
    }

    private void appendEmptyLines(int n) {
        if (n > 1) {
            if (this.fRules.keepEmptyLines) {
                while (--n > 0) {
                    this.appendIndent();
                }
            } else if (this.fRules.keepOneEmptyLine) {
                this.appendIndent();
            }
        }
    }

    private void formatWord(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            this.appendString(stringBuffer.toString(), false);
            stringBuffer.setLength(0);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatPreserve(String string) {
        boolean bl = this.fAutoIndent;
        this.fAutoIndent = false;
        try {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\r' || c == '\n') {
                    if (c == '\r' && n + 1 < string.length() && string.charAt(n + 1) == '\n') {
                        ++n;
                    }
                    this.appendIndent();
                    while (n + 1 < string.length() && XMLCharacter.isWhitespace((char)(c = string.charAt(n + 1))) && c != '\r' && c != '\n') {
                        ++n;
                    }
                } else {
                    this.appendChar(c, true);
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fAutoIndent = bl;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.fAutoIndent = bl;
            return;
        }
    }

    private void formatNodePreserve(XMLNode xMLNode) {
        String string = xMLNode.getTagStart();
        String string2 = xMLNode.getContents();
        this.appendString(string, false);
        this.formatPreserve(string2.substring(string.length()));
    }

    private void formatTag(XMLNode xMLNode) {
        if (!this.fRules.flowTagContents) {
            this.formatNodePreserve(xMLNode);
        } else {
            String string = xMLNode.getTagStart();
            String string2 = xMLNode.getTagEnd();
            String string3 = xMLNode.getContents();
            if (!string3.endsWith(string2)) {
                this.appendString(string3, true);
            } else {
                String[] stringArray = xMLNode.getAttributeArray();
                if (stringArray.length > 0) {
                    if ((stringArray.length & 1) != 0) {
                        throw new IllegalStateException("odd-sized attribute list");
                    }
                    this.pushCount(false);
                    this.appendString(string, false);
                    int n = 0;
                    while (n < stringArray.length) {
                        this.appendChar(' ', false);
                        String string4 = stringArray[n];
                        String string5 = stringArray[n + 1];
                        String string6 = string4 == null ? string5 : (string5 == null ? string4 : String.valueOf(string4) + "=" + string5);
                        this.appendString(string6, true);
                        n += 2;
                    }
                    this.appendString(string2, true);
                    this.popCount();
                } else {
                    this.appendString(String.valueOf(string) + xMLNode.getTagEnd(), false);
                }
            }
        }
    }

    private String escapeQuote(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '\\') {
                stringBuffer.append(c);
                if (n + 1 < n2) {
                    stringBuffer.append(string.charAt(++n));
                } else {
                    stringBuffer.append('\\');
                }
            } else if (c == '\"') {
                stringBuffer.append("\\\"");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean onSameLine(XMLNode xMLNode, XMLNode xMLNode2) {
        int n;
        boolean bl;
        int n2 = this.getLineNo(xMLNode.getOffset() + xMLNode.getLength());
        boolean bl2 = bl = n2 == (n = this.getLineNo(xMLNode2.getOffset()));
        if (bl && xMLNode2.getType().equals("com.objfac.xmltext")) {
            String string = xMLNode2.getContents();
            int n3 = 0;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                if (c == '\r' || c == '\n') {
                    bl = false;
                    break;
                }
                if (c != ' ' && c != '\t') break;
                ++n3;
            }
        }
        return bl;
    }

    private int getLineNo(int n) {
        try {
            return this.fDocument.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private void pushCount(boolean bl) {
        if (!bl) {
            this.pushClump();
        }
        if (this.fCountStack == null) {
            this.fCountStack = new ArrayList();
            this.fBaseCount = this.fCount;
        }
        this.fCountStack.add(new Integer(this.fCount));
        this.fCount = this.fTabber.tabIn(this.fCount);
    }

    private void popCount() {
        this.pushClump();
        this.fCount = this.fBaseCount;
        if (this.fCountStack != null) {
            this.fCount = (Integer)this.fCountStack.remove(this.fCountStack.size() - 1);
            if (this.fCountStack.size() == 0) {
                this.fCountStack = null;
            }
        }
    }

    private void pushQName(String string) {
        if (this.fQNames == null) {
            this.fQNames = new ArrayList();
        }
        this.fQNames.add(string);
    }

    private String popQName() {
        if (this.fQNames == null) {
            return null;
        }
        String string = (String)this.fQNames.remove(this.fQNames.size() - 1);
        if (this.fQNames.size() == 0) {
            this.fQNames = null;
        }
        return string;
    }

    private void formatComment(XMLNode xMLNode) {
        if (this.fRules.preserveSpaceInComments) {
            this.appendString(xMLNode.getContents(), true);
        } else if (!this.fRules.flowComments) {
            this.formatNodePreserve(xMLNode);
        } else {
            this.formatText(xMLNode);
        }
    }

    private void appendString(String string, boolean bl) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            this.appendChar(c, bl);
            ++n;
        }
    }

    private void appendChar(char c, boolean bl) {
        boolean bl2 = XMLCharacter.isWhitespace((char)c);
        if (!bl && bl2) {
            this.pushClump();
            this.fInWs = true;
        } else {
            if (this.fInWs) {
                this.appendChar(' ');
            }
            this.fInWs = false;
            this.appendChar(c);
        }
    }

    private void appendChar(char c) {
        int n = this.fClump.length();
        if (n == 0) {
            this.fClumpCount = this.fCount;
        }
        if (this.fInWs && n == 0 && c == ' ') {
            ++this.fSpaceCount;
        } else {
            this.fClump.append(c);
        }
    }

    private void pushClump() {
        if (this.fClump.length() > 0) {
            int n = this.fClump.length();
            if (this.fAutoIndent && this.fPos + n > this.fWrapMargin) {
                this.pushIndent(this.fCount);
            }
            if (this.fSpaceCount > 0) {
                this.fBuf.append(' ');
            }
            this.fSpaceCount = 0;
            this.fBuf.append(this.fClump.toString());
            this.fPos += this.fClump.length();
            this.fClump.setLength(0);
        }
    }

    private void pushIndent(int n) {
        if (!this.fFirst) {
            this.fBuf.append(this.EOL);
        }
        this.fFirst = false;
        this.fBuf.append(this.fTabber.countToString(n));
        this.fPos = n;
        this.fSpaceCount = 0;
    }

    private void appendIndent(XMLNode xMLNode) {
        if (this.startLeft(xMLNode)) {
            this.fCount = 0;
        }
        this.appendIndent();
    }

    private void appendIndent() {
        this.pushClump();
        this.pushIndent(this.fCount);
        this.fInWs = false;
        this.fPos = this.fCount;
    }

    private static class Rules {
        String qname;
        FormatRules rules;
        Set keepAsIs;
        Set keepElements;
        Set keepEndTags;
        Set startLeft;
        Map prefixToNs;

        public Rules(String string, FormatRules formatRules, Set set, Set set2, Set set3, Set set4, Map map) {
            this.qname = string;
            this.rules = formatRules;
            this.startLeft = set;
            this.keepAsIs = set2;
            this.keepElements = set3;
            this.keepEndTags = set4;
            this.prefixToNs = map;
        }
    }
}

