/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.xml.parsers.IErrorHandler;
import com.objfac.xmleditor.BaseEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditorExtension;

public class XMLShiftActionBase
implements IEditorActionDelegate,
IErrorHandler {
    private int fOperationCode;
    private BaseEditor fEditor;

    public XMLShiftActionBase(int n) {
        this.fOperationCode = n;
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.fEditor = iEditorPart instanceof BaseEditor ? (BaseEditor)iEditorPart : null;
    }

    public boolean error(String string) {
        return false;
    }

    public void run(IAction iAction) {
        if (this.fEditor == null) {
            return;
        }
        if (this.isMultiLineSelection()) {
            if (this.fOperationCode == 8) {
                this.fEditor.shiftRight();
            } else if (this.fOperationCode == 9) {
                this.fEditor.shiftLeft();
            }
        } else if (this.fOperationCode == 8) {
            this.fEditor.tabRight();
        } else if (this.fOperationCode == 9) {
            this.fEditor.tabLeft();
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        boolean bl = false;
        if (this.fEditor != null && this.fEditor instanceof ITextEditorExtension) {
            BaseEditor baseEditor = this.fEditor;
            bl = this.isEnabled(!baseEditor.isEditorInputReadOnly());
        }
        iAction.setEnabled(bl);
    }

    public boolean isEnabled(boolean bl) {
        return bl;
    }

    public boolean isMultiLineSelection() {
        ISourceViewer iSourceViewer;
        if (this.fEditor != null && (iSourceViewer = this.fEditor.getViewer()) != null) {
            StyledText styledText = iSourceViewer.getTextWidget();
            IDocument iDocument = iSourceViewer.getDocument();
            if (styledText != null && iDocument != null) {
                Point point = styledText.getSelectionRange();
                return this.isMultiLineSelection(point, iDocument);
            }
        }
        return false;
    }

    private boolean isMultiLineSelection(Point point, IDocument iDocument) {
        try {
            int n = iDocument.getLineOfOffset(point.x);
            int n2 = iDocument.getLineOfOffset(point.x + point.y);
            return n != n2;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

